/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility.crawl;

import java.lang.reflect.Proxy;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.utility.JavaSqlTypes;
import us.fatehi.utility.Utility;

public class LightColumn
implements Column {
    private static final long serialVersionUID = -1931193814458050468L;
    private final Table parent;
    private final String name;

    public static ColumnDataType integerColumnDataType() {
        return (ColumnDataType)Proxy.newProxyInstance(ColumnDataType.class.getClassLoader(), new Class[]{ColumnDataType.class}, (proxy, method, args) -> {
            String methodName;
            switch (methodName = method.getName()) {
                case "getName": {
                    return "INTEGER";
                }
                case "getJavaSqlType": {
                    return new JavaSqlTypes().getFromJavaSqlTypeName("INTEGER");
                }
            }
            throw new SQLFeatureNotSupportedException(methodName);
        });
    }

    public LightColumn(Table parent, String name) {
        this.parent = Objects.requireNonNull(parent);
        this.name = Utility.requireNotBlank((String)name, (String)"No name provided");
    }

    public int compareTo(NamedObject o) {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LightColumn other = (LightColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent);
    }

    public <T> T getAttribute(String name) {
        return null;
    }

    public <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        return null;
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>();
    }

    public ColumnDataType getColumnDataType() {
        return LightColumn.integerColumnDataType();
    }

    public int getDecimalDigits() {
        return 0;
    }

    public String getDefaultValue() {
        return "";
    }

    public String getFullName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parent.getFullName()).append(".").append(this.name);
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getOrdinalPosition() {
        return 0;
    }

    public Table getParent() {
        return this.parent;
    }

    public Collection<Privilege<Column>> getPrivileges() {
        return new HashSet<Privilege<Column>>();
    }

    public Column getReferencedColumn() {
        return null;
    }

    public String getRemarks() {
        return "";
    }

    public Schema getSchema() {
        return this.parent.getSchema();
    }

    public String getShortName() {
        return this.name;
    }

    public int getSize() {
        return 0;
    }

    public ColumnDataType getType() {
        return this.getColumnDataType();
    }

    public String getWidth() {
        return "";
    }

    public boolean hasAttribute(String name) {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent);
    }

    public boolean hasRemarks() {
        return false;
    }

    public boolean isAutoIncremented() {
        return false;
    }

    public boolean isColumnDataTypeKnown() {
        return false;
    }

    public boolean isGenerated() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isParentPartial() {
        return false;
    }

    public boolean isPartOfForeignKey() {
        return false;
    }

    public boolean isPartOfIndex() {
        return false;
    }

    public boolean isPartOfPrimaryKey() {
        return true;
    }

    public boolean isPartOfUniqueIndex() {
        return true;
    }

    public NamedObjectKey key() {
        return this.parent.key().with(this.name);
    }

    public <T> Optional<T> lookupAttribute(String name) {
        return Optional.empty();
    }

    public <P extends Privilege<Column>> Optional<P> lookupPrivilege(String name) {
        return Optional.empty();
    }

    public void removeAttribute(String name) {
    }

    public <T> void setAttribute(String name, T value) {
    }

    public void setRemarks(String remarks) {
    }

    public String toString() {
        return this.getFullName();
    }

    public void withQuoting(Identifiers identifiers) {
    }
}

