/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.test.utility.crawl.LightColumn;
import us.fatehi.utility.Utility;

public final class LightTable
implements Table {
    private static final long serialVersionUID = -309232480533750613L;
    private final Schema schema;
    private final String name;
    private final List<Column> columns;
    private final Map<String, Object> attributes;

    public LightTable(Schema schema, String name) {
        this.schema = Objects.requireNonNull(schema, "No schema provided");
        this.name = Utility.requireNotBlank((String)name, (String)"No table name provided");
        this.attributes = new HashMap<String, Object>();
        this.columns = new ArrayList<Column>();
    }

    public LightTable(String name) {
        this((Schema)new SchemaReference(), name);
    }

    public LightColumn addColumn(String name) {
        LightColumn column = new LightColumn(this, name);
        this.columns.add(column);
        return column;
    }

    public int compareTo(NamedObject o) {
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LightTable other = (LightTable)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.schema, other.schema);
    }

    public Collection<PrimaryKey> getAlternateKeys() {
        return Collections.emptyList();
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        if (this.hasAttribute(name)) {
            return this.getAttribute(name);
        }
        return defaultValue;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getDefinition() {
        return "";
    }

    public Collection<ForeignKey> getExportedForeignKeys() {
        return Collections.emptyList();
    }

    public Collection<ForeignKey> getForeignKeys() {
        return Collections.emptyList();
    }

    public String getFullName() {
        return this.getName();
    }

    public Collection<Column> getHiddenColumns() {
        return Collections.emptyList();
    }

    public Collection<ForeignKey> getImportedForeignKeys() {
        return Collections.emptyList();
    }

    public Collection<Index> getIndexes() {
        return Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public PrimaryKey getPrimaryKey() {
        return null;
    }

    public Collection<Privilege<Table>> getPrivileges() {
        return Collections.emptyList();
    }

    public Collection<Table> getRelatedTables(TableRelationshipType tableRelationshipType) {
        return Collections.emptyList();
    }

    public String getRemarks() {
        return "";
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Collection<TableConstraint> getTableConstraints() {
        return null;
    }

    public TableType getTableType() {
        return this.getType();
    }

    public Collection<Trigger> getTriggers() {
        return Collections.emptyList();
    }

    public TableType getType() {
        return TableType.UNKNOWN;
    }

    public Collection<WeakAssociation> getWeakAssociations() {
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean hasDefinition() {
        return false;
    }

    public boolean hasForeignKeys() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.schema);
    }

    public boolean hasPrimaryKey() {
        return false;
    }

    public boolean hasRemarks() {
        return false;
    }

    public NamedObjectKey key() {
        return new NamedObjectKey(new String[]{null, null, this.name});
    }

    public <A extends PrimaryKey> Optional<A> lookupAlternateKey(String name) {
        return Optional.empty();
    }

    public <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    public <C extends Column> Optional<C> lookupColumn(String name) {
        for (Column column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return Optional.of(column);
        }
        return Optional.empty();
    }

    public <F extends ForeignKey> Optional<F> lookupForeignKey(String name) {
        return Optional.empty();
    }

    public <I extends Index> Optional<I> lookupIndex(String name) {
        return Optional.empty();
    }

    public <P extends Privilege<Table>> Optional<P> lookupPrivilege(String name) {
        return Optional.empty();
    }

    public <C extends TableConstraint> Optional<C> lookupTableConstraint(String name) {
        return Optional.empty();
    }

    public <T extends Trigger> Optional<T> lookupTrigger(String name) {
        return Optional.empty();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public <T> void setAttribute(String name, T value) {
        this.attributes.put(name, value);
    }

    public void setRemarks(String remarks) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!Utility.isBlank((CharSequence)this.schema.getFullName())) {
            buffer.append(this.schema).append(".");
        }
        buffer.append(this.name);
        return buffer.toString();
    }

    public void withQuoting(Identifiers identifiers) {
    }
}

