/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.maven;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.RegularExpressionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.options.InfoLevel;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.schema.SchemaTextOptionsBuilder;
import sf.util.ObjectToString;

@Mojo(name="schemacrawler", requiresReports=true, threadSafe=true)
public class SchemaCrawlerMojo
extends AbstractMavenReport {
    private static final String INCLUDE_ALL = ".*";
    private static final String INCLUDE_NONE = "";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="config", defaultValue="schemacrawler.config.properties", required=true)
    private String config;
    @Parameter(property="additional-config", defaultValue="schemacrawler.additional.config.properties")
    private String additionalConfig;
    @Parameter(property="driver", defaultValue="${schemacrawler.driver}", required=true)
    private String driver;
    @Parameter(property="url", defaultValue="${schemacrawler.url}", required=true)
    private String url;
    @Parameter(property="user", defaultValue="${schemacrawler.user}", required=true)
    private String user;
    @Parameter(property="password", defaultValue="${schemacrawler.password}")
    private String password;
    @Parameter(property="command", required=true)
    private String command;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="sorttables", defaultValue="true")
    private boolean sorttables;
    @Parameter(property="sortcolumns", defaultValue="false")
    private boolean sortcolumns;
    @Parameter(property="synonyms", defaultValue=".*")
    private String synonyms;
    @Parameter(property="sequences", defaultValue=".*")
    private String sequences;
    @Parameter(property="hideemptytables", defaultValue="false")
    private boolean hideemptytables;
    @Parameter(property="title", defaultValue="SchemaCrawler Report")
    private String title;
    @Parameter(property="noinfo", defaultValue="true")
    private boolean noinfo;
    @Parameter(property="noremarks", defaultValue="false")
    private boolean noremarks;
    @Parameter(property="portablenames", defaultValue="false")
    private boolean portablenames;
    @Parameter(property="outputformat", defaultValue="html")
    private String outputformat;
    @Parameter(property="sortinout", defaultValue="false")
    private boolean sortinout;
    @Parameter(property="infolevel", defaultValue="standard", required=true)
    private String infolevel;
    @Parameter(property="schemas", defaultValue=".*")
    private String schemas;
    @Parameter(property="table_types")
    private String table_types;
    @Parameter(property="tables", defaultValue=".*")
    private String tables;
    @Parameter(property="excludecolumns", defaultValue="")
    private String excludecolumns;
    @Parameter(property="routines", defaultValue=".*")
    private String routines;
    @Parameter(property="excludeinout", defaultValue="")
    private String excludeinout;

    public String getDescription(Locale locale) {
        return "SchemaCrawler Report";
    }

    public String getName(Locale locale) {
        return "SchemaCrawler Report";
    }

    public String getOutputName() {
        return "schemacrawler";
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Log logger = this.getLog();
        try {
            this.fixClassPath();
            Sink sink = this.getSink();
            logger.info((CharSequence)sink.getClass().getName());
            Path outputFile = this.executeSchemaCrawler();
            Consumer<String> outputLine = line -> {
                sink.rawText(line);
                sink.rawText("\n");
                sink.flush();
            };
            OutputFormat outputFormat = this.getOutputFormat();
            sink.comment("BEGIN SchemaCrawler Report");
            if (outputFormat == TextOutputFormat.html || outputFormat == GraphOutputFormat.htmlx) {
                Files.lines(outputFile).forEach(outputLine);
            } else if (outputFormat instanceof TextOutputFormat) {
                sink.rawText("<pre>");
                Files.lines(outputFile).forEach(outputLine);
                sink.rawText("</pre>");
            } else if (outputFormat instanceof GraphOutputFormat) {
                Path graphFile = Paths.get(this.getReportOutputDirectory().getAbsolutePath(), "schemacrawler." + outputFormat.getFormat());
                Files.move(outputFile, graphFile, StandardCopyOption.REPLACE_EXISTING);
                sink.figure();
                sink.figureGraphics(graphFile.getFileName().toString());
                sink.figure_();
            }
            sink.comment("END SchemaCrawler Report");
            sink.flush();
        }
        catch (Exception e) {
            throw new MavenReportException("Error executing SchemaCrawler command " + this.command, e);
        }
    }

    protected String getOutputDirectory() {
        return null;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return null;
    }

    private Config createAdditionalConfiguration() {
        Config textOptionsConfig = this.createSchemaTextOptions();
        try {
            Config additionalConfiguration = Config.load((String[])new String[]{this.config, this.additionalConfig});
            additionalConfiguration.putAll((Map)textOptionsConfig);
            return additionalConfiguration;
        }
        catch (IOException e) {
            Log logger = this.getLog();
            logger.warn((Throwable)e);
            return textOptionsConfig;
        }
    }

    private ConnectionOptions createConnectionOptions() throws SchemaCrawlerException, MavenReportException {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new MavenReportException("Cannot load JDBC driver", (Exception)e);
        }
        DatabaseConnectionOptions connectionOptions = new DatabaseConnectionOptions(this.url);
        connectionOptions.setUser(this.user);
        connectionOptions.setPassword(this.password);
        return connectionOptions;
    }

    private OutputOptions createOutputOptions(Path outputFile) {
        OutputOptions outputOptions = new OutputOptions();
        outputOptions.setOutputFormatValue(this.getOutputFormat().getFormat());
        outputOptions.setOutputFile(outputFile);
        return outputOptions;
    }

    private SchemaCrawlerOptions createSchemaCrawlerOptions() {
        Log logger = this.getLog();
        SchemaCrawlerOptions schemaCrawlerOptions = new SchemaCrawlerOptions();
        if (!StringUtils.isBlank((String)this.table_types)) {
            schemaCrawlerOptions.setTableTypes(this.splitTableTypes(this.table_types));
        }
        if (!StringUtils.isBlank((String)this.infolevel)) {
            try {
                schemaCrawlerOptions.setSchemaInfoLevel(InfoLevel.valueOf((String)this.infolevel).buildSchemaInfoLevel());
            }
            catch (Exception e) {
                logger.info((CharSequence)("Unknown infolevel - using 'standard': " + this.infolevel));
                schemaCrawlerOptions.setSchemaInfoLevel(InfoLevel.standard.buildSchemaInfoLevel());
            }
        }
        schemaCrawlerOptions.setSchemaInclusionRule((InclusionRule)new RegularExpressionRule(StringUtils.defaultString((String)this.schemas, (String)INCLUDE_ALL), INCLUDE_NONE));
        schemaCrawlerOptions.setSynonymInclusionRule((InclusionRule)new RegularExpressionRule(StringUtils.defaultString((String)this.synonyms, (String)INCLUDE_ALL), INCLUDE_NONE));
        schemaCrawlerOptions.setSequenceInclusionRule((InclusionRule)new RegularExpressionRule(StringUtils.defaultString((String)this.sequences, (String)INCLUDE_ALL), INCLUDE_NONE));
        schemaCrawlerOptions.setTableInclusionRule((InclusionRule)new RegularExpressionRule(StringUtils.defaultString((String)this.tables, (String)INCLUDE_ALL), INCLUDE_NONE));
        schemaCrawlerOptions.setRoutineInclusionRule((InclusionRule)new RegularExpressionRule(StringUtils.defaultString((String)this.routines, (String)INCLUDE_ALL), INCLUDE_NONE));
        schemaCrawlerOptions.setColumnInclusionRule((InclusionRule)new RegularExpressionRule(INCLUDE_ALL, StringUtils.defaultString((String)this.excludecolumns, (String)INCLUDE_NONE)));
        schemaCrawlerOptions.setColumnInclusionRule((InclusionRule)new RegularExpressionRule(INCLUDE_ALL, StringUtils.defaultString((String)this.excludeinout, (String)INCLUDE_NONE)));
        schemaCrawlerOptions.setHideEmptyTables(this.hideemptytables);
        schemaCrawlerOptions.setTitle(this.title);
        return schemaCrawlerOptions;
    }

    private Config createSchemaTextOptions() {
        SchemaTextOptionsBuilder textOptionsBuilder = new SchemaTextOptionsBuilder();
        textOptionsBuilder.hideHeader();
        textOptionsBuilder.hideFooter();
        if (this.noinfo) {
            textOptionsBuilder.hideInfo();
        }
        if (this.noremarks) {
            textOptionsBuilder.hideRemarks();
        }
        if (this.portablenames) {
            textOptionsBuilder.portableNames();
        }
        if (this.sorttables) {
            textOptionsBuilder.sortTables();
        }
        if (this.sortcolumns) {
            textOptionsBuilder.sortTableColumns();
        }
        if (this.sortinout) {
            textOptionsBuilder.sortInOut();
        }
        Config textOptionsConfig = textOptionsBuilder.toConfig();
        return textOptionsConfig;
    }

    private Path executeSchemaCrawler() throws Exception {
        Log logger = this.getLog();
        SchemaCrawlerOptions schemaCrawlerOptions = this.createSchemaCrawlerOptions();
        ConnectionOptions connectionOptions = this.createConnectionOptions();
        Config additionalConfiguration = this.createAdditionalConfiguration();
        Path outputFile = Files.createTempFile("schemacrawler.report.", ".data", new FileAttribute[0]);
        OutputOptions outputOptions = this.createOutputOptions(outputFile);
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        executable.setOutputOptions(outputOptions);
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setAdditionalConfiguration(additionalConfiguration);
        logger.debug((CharSequence)ObjectToString.toString((Object)executable));
        Connection connection = connectionOptions.getConnection();
        executable.execute(connection);
        return outputFile;
    }

    private void fixClassPath() throws MavenReportException {
        Log logger = this.getLog();
        try {
            ArrayList<URL> jdbcJarUrls = new ArrayList<URL>();
            for (Object e : this.project.getArtifacts()) {
                jdbcJarUrls.add(((Artifact)e).getFile().toURI().toURL());
            }
            for (Artifact artifact : this.pluginArtifacts) {
                jdbcJarUrls.add(artifact.getFile().toURI().toURL());
            }
            logger.debug((CharSequence)("SchemaCrawler - Maven Plugin: classpath: " + jdbcJarUrls));
            Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrlMethod.setAccessible(true);
            URLClassLoader uRLClassLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
            for (URL jdbcJarUrl : jdbcJarUrls) {
                addUrlMethod.invoke((Object)uRLClassLoader, jdbcJarUrl);
            }
            logger.info((CharSequence)("Fixed SchemaCrawler classpath: " + Arrays.asList(uRLClassLoader.getURLs())));
        }
        catch (Exception e) {
            throw new MavenReportException("Error fixing classpath", e);
        }
    }

    private OutputFormat getOutputFormat() {
        Object outputFormat = StringUtils.isBlank((String)this.outputformat) ? TextOutputFormat.html : (TextOutputFormat.isTextOutputFormat((String)this.outputformat) ? TextOutputFormat.valueOfFromString((String)this.outputformat) : (GraphOutputFormat.isGraphOutputFormat((String)this.outputformat) ? GraphOutputFormat.fromFormat((String)this.outputformat) : TextOutputFormat.html));
        return outputFormat;
    }

    private Collection<String> splitTableTypes(String tableTypesString) {
        HashSet<String> tableTypes;
        if (tableTypesString != null) {
            tableTypes = new HashSet<String>();
            String[] tableTypeStrings = tableTypesString.split(",");
            if (tableTypeStrings != null && tableTypeStrings.length > 0) {
                for (String tableTypeString : tableTypeStrings) {
                    tableTypes.add(tableTypeString.trim());
                }
            }
        } else {
            tableTypes = null;
        }
        return tableTypes;
    }
}

