/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.mysql;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.server.mysql.MySQLEnumDataTypeHelper;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.ioresource.ClasspathInputResource;
import us.fatehi.utility.ioresource.InputResource;

public final class MySQLDatabaseConnector
extends DatabaseConnector {
    public MySQLDatabaseConnector() throws IOException {
        super(new DatabaseServerType("mysql", "MySQL"), (InputResource)new ClasspathInputResource("/schemacrawler-mysql.config.properties"), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/mysql.information_schema"));
    }

    public EnumDataTypeHelper getEnumDataTypeHelper() {
        return new MySQLEnumDataTypeHelper();
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = super.getHelpCommand();
        pluginCommand.addOption("server", "--server=mysql%nLoads SchemaCrawler plug-in for MySQL", String.class).addOption("host", "Host name%nOptional, defaults to localhost", String.class).addOption("port", "Port number%nOptional, defaults to 3306", Integer.class).addOption("database", "Database name", String.class);
        return pluginCommand;
    }

    protected Predicate<String> supportsUrlPredicate() {
        return url -> Pattern.matches("jdbc:(mysql|mariadb):.*", url);
    }
}

