SELECT /*+ PARALLEL(AUTO) */
  NULL AS INDEX_CATALOG,
  INDEXES.OWNER AS INDEX_SCHEMA,
  INDEXES.INDEX_NAME AS INDEX_NAME,
  INDEXES.TABLE_NAME AS TABLE_NAME,
  CASE WHEN INDEXES.UNIQUENESS = 'UNIQUE' THEN 'YES' ELSE 'NO' END AS IS_UNIQUE,
  DBMS_METADATA.GET_DDL('INDEX', INDEXES.INDEX_NAME, INDEXES.OWNER) AS INDEX_DEFINITION
FROM
  ALL_INDEXES INDEXES
  INNER JOIN ALL_USERS USERS
    ON INDEXES.OWNER = USERS.USERNAME
WHERE
  USERS.USERNAME NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'HR', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL')  
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5,6}$')
  AND INDEXES.TABLE_NAME NOT LIKE 'BIN$%'
  AND INDEXES.INDEX_NAME NOT LIKE 'BIN$%'
ORDER BY
  INDEX_SCHEMA,
  TABLE_NAME,
  INDEX_NAME
