SELECT /*+ PARALLEL(AUTO) */
  NULL AS SYNONYM_CATALOG,
  SYNONYMS.OWNER AS SYNONYM_SCHEMA,
  SYNONYMS.SYNONYM_NAME,
  NULL AS REFERENCED_OBJECT_CATALOG,
  SYNONYMS.TABLE_OWNER AS REFERENCED_OBJECT_SCHEMA,
  SYNONYMS.TABLE_NAME AS REFERENCED_OBJECT_NAME
FROM
  ALL_SYNONYMS SYNONYMS
  INNER JOIN ALL_USERS USERS
    ON SYNONYMS.OWNER = USERS.USERNAME
WHERE
  USERS.USERNAME NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'HR', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL')  
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5,6}$')
  AND SYNONYMS.TABLE_NAME NOT LIKE 'BIN$%'
ORDER BY
  SYNONYM_SCHEMA,
  SYNONYM_NAME
