/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.script.CommandChain;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.string.StringFormat;

public final class ScriptCommand
extends BaseSchemaCrawlerCommand<ScriptOptions> {
    private static final Logger LOGGER = Logger.getLogger(ScriptCommand.class.getName());
    static final String COMMAND = "script";

    private static void logScriptEngineDetails(Level level, ScriptEngineFactory scriptEngineFactory) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LOGGER.log(level, String.format("Using script engine%n%s %s (%s %s)%nScript engine names: %s%nSupported file extensions: %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), ObjectToString.toString(scriptEngineFactory.getNames()), ObjectToString.toString(scriptEngineFactory.getExtensions())));
    }

    public ScriptCommand() {
        super(COMMAND);
    }

    public void checkAvailability() throws Exception {
        this.getScriptEngine();
        ((ScriptOptions)this.commandOptions).getResource().orElseThrow(() -> new SchemaCrawlerException("No script found, " + ((ScriptOptions)this.commandOptions).getScript()));
    }

    public void execute() throws Exception {
        Objects.requireNonNull(this.commandOptions, "No script language provided");
        this.checkCatalog();
        Charset inputCharset = this.outputOptions.getInputCharset();
        ScriptEngine scriptEngine = this.getScriptEngine();
        InputResource inputResource = ((ScriptOptions)this.commandOptions).getResource().get();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Evaluating script, ", new Object[]{inputResource}));
        try (Reader reader = inputResource.openNewInputReader(inputCharset);
             Writer writer = this.outputOptions.openNewOutputWriter();){
            scriptEngine.getContext().setWriter(writer);
            scriptEngine.put("catalog", this.catalog);
            scriptEngine.put("connection", this.connection);
            scriptEngine.put("chain", (Object)new CommandChain(this));
            if (scriptEngine instanceof Compilable) {
                CompiledScript script = ((Compilable)((Object)scriptEngine)).compile(reader);
                Object result = script.eval();
                LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Script execution result:%n%s", new Object[]{result}));
            } else {
                scriptEngine.eval(reader);
            }
        }
    }

    public boolean usesConnection() {
        return true;
    }

    private ScriptEngine getScriptEngine() throws SchemaCrawlerException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = null;
        String scriptingLanguage = ((ScriptOptions)this.commandOptions).getLanguage();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Using script language <%s>", new Object[]{scriptingLanguage}));
        try {
            scriptEngine = scriptEngineManager.getEngineByName(scriptingLanguage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scriptEngine == null) {
            scriptEngine = scriptEngineManager.getEngineByExtension(scriptingLanguage);
        }
        if (scriptEngine == null) {
            throw new SchemaCrawlerException("Script engine not found");
        }
        ScriptCommand.logScriptEngineDetails(Level.CONFIG, scriptEngine.getFactory());
        return scriptEngine;
    }
}

