/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;

public final class FreeMarkerRenderer
extends BaseTemplateRenderer {
    @Override
    public void execute() throws Exception {
        OutputOptions outputOptions = this.getOutputOptions();
        String templateLocation = this.getResourceFilename();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        System.setProperty("org.freemarker.loggerLibrary", "JUL");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        ClassTemplateLoader ctl = new ClassTemplateLoader(FreeMarkerRenderer.class, "/");
        FileTemplateLoader ftl = new FileTemplateLoader(new File(templatePath));
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
        cfg.setTemplateLoader((TemplateLoader)mtl);
        cfg.setEncoding(Locale.getDefault(), outputOptions.getInputCharset().name());
        cfg.setWhitespaceStripping(true);
        try (Writer writer = outputOptions.openNewOutputWriter();){
            Template template = cfg.getTemplate(templateLocation);
            Map<String, Object> context = this.getContext();
            template.process(context, writer);
        }
    }
}

