/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import java.util.HashMap;
import java.util.Objects;
import schemacrawler.tools.command.template.TemplateRenderer;
import schemacrawler.tools.command.template.options.TemplateLanguageType;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.LanguageOptions;

public final class TemplateCommand
extends BaseSchemaCrawlerCommand<LanguageOptions> {
    static final String COMMAND = "template";

    public TemplateCommand() {
        super(COMMAND);
    }

    public void checkAvailability() throws Exception {
    }

    public void execute() throws Exception {
        Objects.requireNonNull(this.commandOptions, "No template language provided");
        this.checkCatalog();
        TemplateLanguageType languageType = TemplateLanguageType.valueOf(((LanguageOptions)this.commandOptions).getLanguage());
        String templateRendererClassName = languageType.getTemplateRendererClassName();
        Class<?> templateRendererClass = Class.forName(templateRendererClassName);
        TemplateRenderer templateRenderer = (TemplateRenderer)templateRendererClass.newInstance();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("catalog", this.catalog);
        context.put("identifiers", this.identifiers);
        templateRenderer.setResourceFilename(((LanguageOptions)this.commandOptions).getScript());
        templateRenderer.setContext(context);
        templateRenderer.setOutputOptions(this.outputOptions);
        templateRenderer.execute();
    }

    public boolean usesConnection() {
        return true;
    }
}

