/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;

public final class JavaSerializedCatalog
implements CatalogSerializer {
    private final Catalog catalog;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Catalog readCatalog(InputStream in) throws SchemaCrawlerException {
        Objects.requireNonNull(in, "No input stream provided");
        try (ObjectInputStream objIn = new ObjectInputStream(in);){
            Catalog catalog = (Catalog)objIn.readObject();
            return catalog;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SchemaCrawlerException("Cannot deserialize catalog", (Throwable)e);
        }
    }

    public JavaSerializedCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public JavaSerializedCatalog(InputStream in) throws SchemaCrawlerException {
        this(JavaSerializedCatalog.readCatalog(in));
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void save(OutputStream out) throws SchemaCrawlerException {
        Objects.requireNonNull(out, "No output stream provided");
        try (ObjectOutputStream objOut = new ObjectOutputStream(out);){
            objOut.writeObject(this.catalog);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not serialize catalog", (Throwable)e);
        }
    }

    @Override
    public void save(Writer out) {
        throw new UnsupportedOperationException("Cannot serialize binary format using character data");
    }
}

