/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema.options;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.tools.command.text.schema.options.BaseSchemaTextOptionsBuilder;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.text.options.BaseTextOptions;

public class SchemaTextOptions
extends BaseTextOptions {
    private final boolean isAlphabeticalSortForForeignKeys;
    private final boolean isAlphabeticalSortForIndexes;
    private final boolean isHideRemarks;
    private final boolean isShowOrdinalNumbers;
    private final boolean isShowStandardColumnTypeNames;
    private final boolean isHideTableRowCounts;
    private final Map<HideDatabaseObjectNamesType, Boolean> hideNames;

    protected SchemaTextOptions(BaseSchemaTextOptionsBuilder<?, ? extends SchemaTextOptions> builder) {
        super(builder);
        this.isAlphabeticalSortForForeignKeys = builder.isAlphabeticalSortForForeignKeys;
        this.isAlphabeticalSortForIndexes = builder.isAlphabeticalSortForIndexes;
        this.isHideRemarks = builder.isHideRemarks;
        this.isShowOrdinalNumbers = builder.isShowOrdinalNumbers;
        this.isShowStandardColumnTypeNames = builder.isShowStandardColumnTypeNames;
        this.isHideTableRowCounts = builder.isHideTableRowCounts;
        this.hideNames = new EnumMap<HideDatabaseObjectNamesType, Boolean>(HideDatabaseObjectNamesType.class);
        for (HideDatabaseObjectNamesType databaseObjectNamesType : HideDatabaseObjectNamesType.values()) {
            this.hideNames.put(databaseObjectNamesType, builder.hideNames.getOrDefault((Object)databaseObjectNamesType, false));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaTextOptions)) {
            return false;
        }
        SchemaTextOptions that = (SchemaTextOptions)o;
        return this.isAlphabeticalSortForForeignKeys == that.isAlphabeticalSortForForeignKeys && this.isAlphabeticalSortForIndexes == that.isAlphabeticalSortForIndexes && this.isHideRemarks == that.isHideRemarks && this.isShowOrdinalNumbers == that.isShowOrdinalNumbers && this.isShowStandardColumnTypeNames == that.isShowStandardColumnTypeNames && this.isHideTableRowCounts == that.isHideTableRowCounts && this.hideNames.equals(that.hideNames);
    }

    public boolean get(HideDatabaseObjectNamesType key) {
        return this.hideNames.getOrDefault((Object)key, false);
    }

    public int hashCode() {
        return Objects.hash(this.isAlphabeticalSortForForeignKeys, this.isAlphabeticalSortForIndexes, this.isHideRemarks, this.isShowOrdinalNumbers, this.isShowStandardColumnTypeNames, this.isHideTableRowCounts, this.hideNames);
    }

    public boolean isAlphabeticalSortForForeignKeys() {
        return this.isAlphabeticalSortForForeignKeys;
    }

    public boolean isAlphabeticalSortForIndexes() {
        return this.isAlphabeticalSortForIndexes;
    }

    public boolean isHideAlternateKeyNames() {
        return this.get(HideDatabaseObjectNamesType.hideAlternateKeyNames);
    }

    public boolean isHideForeignKeyNames() {
        return this.get(HideDatabaseObjectNamesType.hideForeignKeyNames);
    }

    public boolean isHideIndexNames() {
        return this.get(HideDatabaseObjectNamesType.hideIndexNames);
    }

    public boolean isHidePrimaryKeyNames() {
        return this.get(HideDatabaseObjectNamesType.hidePrimaryKeyNames);
    }

    public boolean isHideRemarks() {
        return this.isHideRemarks;
    }

    public boolean isHideRoutineSpecificNames() {
        return this.get(HideDatabaseObjectNamesType.hideRoutineSpecificNames);
    }

    public boolean isHideTableConstraintNames() {
        return this.get(HideDatabaseObjectNamesType.hideTableConstraintNames);
    }

    public boolean isHideTableRowCounts() {
        return this.isHideTableRowCounts;
    }

    public boolean isHideTriggerNames() {
        return this.get(HideDatabaseObjectNamesType.hideTriggerNames);
    }

    public boolean isHideWeakAssociationNames() {
        return this.get(HideDatabaseObjectNamesType.hideWeakAssociationNames);
    }

    public boolean isShowOrdinalNumbers() {
        return this.isShowOrdinalNumbers;
    }

    public boolean isShowStandardColumnTypeNames() {
        return this.isShowStandardColumnTypeNames;
    }
}

