/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.base.helper;

import java.io.PrintWriter;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.utility.BinaryData;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

abstract class BaseTextFormattingHelper
implements TextFormattingHelper {
    static final String DASHED_SEPARATOR = BaseTextFormattingHelper.separator("-");
    protected final PrintWriter out;
    private final TextOutputFormat outputFormat;

    static String separator(String pattern) {
        StringBuilder dashedSeparator = new StringBuilder(72);
        for (int i = 0; i < 72 / pattern.length(); ++i) {
            dashedSeparator.append(pattern);
        }
        return dashedSeparator.toString();
    }

    public BaseTextFormattingHelper(PrintWriter out, TextOutputFormat outputFormat) {
        this.out = out;
        this.outputFormat = outputFormat;
    }

    @Override
    public TextFormattingHelper append(String text) {
        this.out.write(text);
        this.out.flush();
        return this;
    }

    @Override
    public String createAnchor(String text, String link) {
        return TagBuilder.anchor().withEscapedText(text).withHyperlink(link).make().render(TagOutputFormat.valueOf((String)this.outputFormat.name()));
    }

    @Override
    public void println() {
        this.out.println();
    }

    @Override
    public void writeDescriptionRow(String description) {
        Tag row = TagBuilder.tableRow().make();
        row.addInnerTag(TagBuilder.tableCell().withStyleClass("spacer").make());
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(description).withColumnSpan(2).make());
        this.out.println(row.render(TagOutputFormat.valueOf((String)this.outputFormat.name())));
    }

    @Override
    public void writeDetailRow(String text1, String text2, String text3) {
        this.writeDetailRow(text1, text2, text3, true, false, "");
    }

    @Override
    public void writeDetailRow(String text1, String text2, String text3, boolean escapeText, boolean emphasize, String style) {
        int text2Width = 32;
        int text3Width = 28;
        String text3Sytle = !Utility.isBlank((CharSequence)style) ? " " + style : "";
        Tag row = TagBuilder.tableRow().make();
        if (Utility.isBlank((CharSequence)text1)) {
            row.addInnerTag(TagBuilder.tableCell().withStyleClass("spacer").make());
        } else {
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(text1).withWidth(2).withStyleClass("spacer").make());
        }
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(text2, escapeText).withWidth(32).withEmphasis(emphasize).withStyleClass("minwidth").make());
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(text3).withWidth(28).withAlignment(Alignment.inherit).withStyleClass("minwidth" + text3Sytle).make());
        this.out.println(row.render(TagOutputFormat.valueOf((String)this.outputFormat.name())));
    }

    @Override
    public void writeEmptyRow() {
        Tag tableRow = TagBuilder.tableRow().make();
        tableRow.addInnerTag(TagBuilder.tableCell().withColumnSpan(3).make());
        this.out.println(tableRow.render(TagOutputFormat.valueOf((String)this.outputFormat.name())));
    }

    @Override
    public void writeNameRow(String name, String description) {
        int nameWidth = 34;
        int descriptionWidth = 36;
        if (name.length() > nameWidth && description.length() < descriptionWidth) {
            descriptionWidth = Math.max(description.length(), descriptionWidth - (name.length() - nameWidth));
        }
        if (description.length() > descriptionWidth && name.length() < nameWidth) {
            nameWidth = Math.max(name.length(), nameWidth - (description.length() - descriptionWidth));
        }
        Tag row = TagBuilder.tableRow().make();
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(name).withWidth(nameWidth).withStyleClass("name").withColumnSpan(2).make());
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(description).withWidth(descriptionWidth).withAlignment(Alignment.right).withStyleClass("description right").make());
        this.out.println(row.render(TagOutputFormat.valueOf((String)this.outputFormat.name())));
    }

    @Override
    public void writeNameValueRow(String name, String value, Alignment valueAlignment) {
        int nameWidth = 40;
        int valueWidth = 30;
        Alignment alignmentForValue = valueAlignment == null ? Alignment.inherit : valueAlignment;
        String valueStyle = "property_value" + (alignmentForValue == Alignment.inherit ? "" : " right");
        Tag row = TagBuilder.tableRow().make();
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(name).withWidth(40).withStyleClass("property_name").make());
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(value).withWidth(30).withAlignment(alignmentForValue).withStyleClass(valueStyle).make());
        this.out.println(row.render(TagOutputFormat.valueOf((String)this.outputFormat.name())));
    }

    @Override
    public void writeRow(Object ... columnData) {
        TextOutputFormat outputFormat = this.outputFormat;
        if (outputFormat == TextOutputFormat.text) {
            outputFormat = TextOutputFormat.tsv;
        }
        Tag row = TagBuilder.tableRow().make();
        for (Object element : columnData) {
            if (element == null) {
                row.addInnerTag(TagBuilder.tableCell().withText("NULL").withStyleClass("data_null").make());
                continue;
            }
            if (element instanceof BinaryData) {
                row.addInnerTag(TagBuilder.tableCell().withEscapedText(element.toString()).withStyleClass("data_binary").make());
                continue;
            }
            if (element instanceof Number) {
                row.addInnerTag(TagBuilder.tableCell().withEscapedText(element.toString()).withStyleClass("data_number").make());
                continue;
            }
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(element.toString()).make());
        }
        this.out.println(row.render(TagOutputFormat.valueOf((String)outputFormat.name())));
    }

    @Override
    public void writeRowHeader(String ... columnNames) {
        TextOutputFormat outputFormat = this.outputFormat;
        if (outputFormat == TextOutputFormat.text) {
            outputFormat = TextOutputFormat.tsv;
        }
        Tag row = TagBuilder.tableRow().make();
        for (String columnName : columnNames) {
            Tag headerCell = TagBuilder.tableHeaderCell().withText(columnName).make();
            row.addInnerTag(headerCell);
        }
        this.out.println(row.render(TagOutputFormat.valueOf((String)outputFormat.name())));
    }

    @Override
    public void writeWideRow(String definition, String style) {
        Tag row = TagBuilder.tableRow().make();
        row.addInnerTag(TagBuilder.tableCell().withEscapedText(definition).withStyleClass(style).withColumnSpan(3).make());
        this.out.println(row.render(TagOutputFormat.valueOf((String)this.outputFormat.name())));
    }
}

