/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.schema.DatabaseObject;
import us.fatehi.utility.Color;
import us.fatehi.utility.RegularExpressionColorMap;
import us.fatehi.utility.Utility;

public class DatabaseObjectColorMap {
    private final RegularExpressionColorMap colorMap;

    public DatabaseObjectColorMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(Color.fromHSV((float)0.0f, (float)0.0f, (float)0.95f).toString().substring(1), ".*");
        this.colorMap = new RegularExpressionColorMap(properties);
    }

    public DatabaseObjectColorMap(Map<String, String> properties) {
        Objects.requireNonNull(properties, "No properties provided");
        this.colorMap = new RegularExpressionColorMap(properties);
    }

    public Color getColor(DatabaseObject dbObject) {
        Objects.requireNonNull(dbObject, "No database object provided");
        String schemaName = dbObject.getSchema().getFullName();
        Color dbObjectColor = this.colorMap.match(schemaName).orElseGet(() -> {
            Color color = this.generatePastelColor(schemaName);
            this.colorMap.putLiteral(schemaName, color);
            return color;
        });
        return dbObjectColor;
    }

    private Color generatePastelColor(String text) {
        float hue;
        if (Utility.isBlank((CharSequence)text)) {
            hue = 0.123456f;
        } else {
            int hash = new StringBuilder(text).reverse().toString().hashCode();
            hue = (float)hash / 32771.0f % 1.0f;
        }
        float saturation = 0.2f;
        float brightness = 0.95f;
        Color color = Color.fromHSV((float)hue, (float)0.2f, (float)0.95f);
        return color;
    }
}

