/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema.options;

import java.util.EnumMap;
import java.util.Map;
import schemacrawler.tools.command.text.schema.options.BaseSchemaTextOptionsBuilder;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.HideDependantDatabaseObjectsType;
import schemacrawler.tools.text.options.BaseTextOptions;

public class SchemaTextOptions
extends BaseTextOptions {
    private final boolean isAlphabeticalSortForForeignKeys;
    private final boolean isAlphabeticalSortForIndexes;
    private final boolean isHideRemarks;
    private final boolean isShowOrdinalNumbers;
    private final boolean isShowStandardColumnTypeNames;
    private final boolean isHideTableRowCounts;
    private final Map<HideDatabaseObjectsType, Boolean> hideDatabaseObjects;
    private final Map<HideDependantDatabaseObjectsType, Boolean> hideDependantDatabaseObjects;
    private final Map<HideDatabaseObjectNamesType, Boolean> hideNames;

    protected SchemaTextOptions(BaseSchemaTextOptionsBuilder<?, ? extends SchemaTextOptions> builder) {
        super(builder);
        this.isAlphabeticalSortForForeignKeys = builder.isAlphabeticalSortForForeignKeys;
        this.isAlphabeticalSortForIndexes = builder.isAlphabeticalSortForIndexes;
        this.isHideRemarks = builder.isHideRemarks;
        this.isShowOrdinalNumbers = builder.isShowOrdinalNumbers;
        this.isShowStandardColumnTypeNames = builder.isShowStandardColumnTypeNames;
        this.isHideTableRowCounts = builder.isHideTableRowCounts;
        this.hideDatabaseObjects = new EnumMap<HideDatabaseObjectsType, Boolean>(HideDatabaseObjectsType.class);
        for (HideDatabaseObjectsType hideDatabaseObjectsType : HideDatabaseObjectsType.values()) {
            this.hideDatabaseObjects.put(hideDatabaseObjectsType, builder.hideDatabaseObjects.getOrDefault((Object)hideDatabaseObjectsType, false));
        }
        this.hideDependantDatabaseObjects = new EnumMap<HideDependantDatabaseObjectsType, Boolean>(HideDependantDatabaseObjectsType.class);
        for (Enum enum_ : HideDependantDatabaseObjectsType.values()) {
            this.hideDependantDatabaseObjects.put((HideDependantDatabaseObjectsType)enum_, builder.hideDependantDatabaseObjects.getOrDefault(enum_, false));
        }
        this.hideNames = new EnumMap<HideDatabaseObjectNamesType, Boolean>(HideDatabaseObjectNamesType.class);
        for (Enum enum_ : HideDatabaseObjectNamesType.values()) {
            this.hideNames.put((HideDatabaseObjectNamesType)enum_, builder.hideNames.getOrDefault(enum_, false));
        }
    }

    public boolean is(HideDatabaseObjectNamesType key) {
        return this.hideNames.getOrDefault((Object)key, false);
    }

    public boolean is(HideDatabaseObjectsType key) {
        return this.hideDatabaseObjects.getOrDefault((Object)key, false);
    }

    public boolean is(HideDependantDatabaseObjectsType key) {
        return this.hideDependantDatabaseObjects.getOrDefault((Object)key, false);
    }

    public boolean isAlphabeticalSortForForeignKeys() {
        return this.isAlphabeticalSortForForeignKeys;
    }

    public boolean isAlphabeticalSortForIndexes() {
        return this.isAlphabeticalSortForIndexes;
    }

    public boolean isHideRemarks() {
        return this.isHideRemarks;
    }

    public boolean isHideTableRowCounts() {
        return this.isHideTableRowCounts;
    }

    public boolean isShowOrdinalNumbers() {
        return this.isShowOrdinalNumbers;
    }

    public boolean isShowStandardColumnTypeNames() {
        return this.isShowStandardColumnTypeNames;
    }
}

