/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.hebi.quickbuf.ByteUtil;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.UnsafeAccess;
import us.hebi.quickbuf.Utf8;

class ArraySink
extends ProtoSink {
    protected byte[] buffer;
    protected int offset;
    protected int limit;
    protected int position;

    ArraySink() {
    }

    @Override
    public int getTotalBytesWritten() {
        return this.position - this.offset;
    }

    @Override
    public int spaceLeft() {
        return this.limit - this.position;
    }

    @Override
    public ArraySink reset() {
        this.position = this.offset;
        return this;
    }

    protected ProtoSink.OutOfSpaceException outOfSpace() {
        return new ProtoSink.OutOfSpaceException(this.position, this.limit);
    }

    @Override
    public final void writeStringNoTag(CharSequence value) throws IOException {
        try {
            int maxLengthVarIntSize = ArraySink.computeRawVarint32Size(value.length() * 3);
            if (maxLengthVarIntSize == 1 || maxLengthVarIntSize == ArraySink.computeRawVarint32Size(value.length())) {
                int startPosition = this.position + maxLengthVarIntSize;
                int endPosition = this.writeUtf8Encoded(value, this.buffer, startPosition, this.spaceLeft() - maxLengthVarIntSize);
                this.writeLength(endPosition - startPosition);
                this.position = endPosition;
            } else {
                this.writeLength(Utf8.encodedLength(value));
                this.position = this.writeUtf8Encoded(value, this.buffer, this.position, this.spaceLeft());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ProtoSink.OutOfSpaceException outOfSpaceException = this.outOfSpace();
            outOfSpaceException.initCause(e);
            throw outOfSpaceException;
        }
    }

    @Override
    public void writeRawByte(byte value) throws IOException {
        if (this.position == this.limit) {
            throw this.outOfSpace();
        }
        this.buffer[this.position++] = value;
    }

    @Override
    public ProtoSink setOutput(byte[] buffer, long offset, int length) {
        if (offset < 0L || length < 0 || offset > (long)buffer.length || offset + (long)length > (long)buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buffer = buffer;
        this.offset = (int)offset;
        this.limit = this.offset + length;
        this.position = this.offset;
        return this;
    }

    @Override
    public ProtoSink setOutput(ByteBuffer buffer) {
        ProtoUtil.checkArgument(!buffer.isDirect(), "ArraySink does not support direct buffers");
        ProtoUtil.checkArgument(!buffer.isReadOnly(), "Buffer is read only");
        return ByteUtil.setRawOutput(this, buffer);
    }

    @Override
    public ProtoSink clear() {
        return this.setOutput(ProtoUtil.EMPTY_BYTE_ARRAY);
    }

    @Override
    public void writeRawLittleEndian16(short value) throws IOException {
        ByteUtil.writeLittleEndian16(this.buffer, this.require(2), value);
    }

    @Override
    public void writeRawLittleEndian32(int value) throws IOException {
        ByteUtil.writeLittleEndian32(this.buffer, this.require(4), value);
    }

    @Override
    public void writeRawLittleEndian64(long value) throws IOException {
        ByteUtil.writeLittleEndian64(this.buffer, this.require(8), value);
    }

    @Override
    public void writeFloatNoTag(float value) throws IOException {
        ByteUtil.writeFloat(this.buffer, this.require(4), value);
    }

    @Override
    public void writeDoubleNoTag(double value) throws IOException {
        ByteUtil.writeDouble(this.buffer, this.require(8), value);
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        ByteUtil.writeBytes(this.buffer, this.require(length), value, offset, length);
    }

    @Override
    protected void writeRawBooleans(boolean[] values, int length) throws IOException {
        ByteUtil.writeBooleans(this.buffer, this.require(length), values, length);
    }

    @Override
    protected void writeRawFixed32s(int[] values, int length) throws IOException {
        ByteUtil.writeLittleEndian32s(this.buffer, this.require(length * 4), values, length);
    }

    @Override
    protected void writeRawFixed64s(long[] values, int length) throws IOException {
        ByteUtil.writeLittleEndian64s(this.buffer, this.require(length * 8), values, length);
    }

    @Override
    protected void writeRawFloats(float[] values, int length) throws IOException {
        ByteUtil.writeFloats(this.buffer, this.require(length * 4), values, length);
    }

    @Override
    protected void writeRawDoubles(double[] values, int length) throws IOException {
        ByteUtil.writeDoubles(this.buffer, this.require(length * 8), values, length);
    }

    protected int writeUtf8Encoded(CharSequence value, byte[] buffer, int position, int maxSize) {
        return Utf8.encodeArray(value, buffer, position, maxSize);
    }

    private int require(int numBytes) throws ProtoSink.OutOfSpaceException {
        if (this.spaceLeft() < numBytes) {
            throw this.outOfSpace();
        }
        try {
            int n = this.position;
            return n;
        }
        finally {
            this.position += numBytes;
        }
    }

    static class RepeatedByteSink
    extends ProtoSink {
        int initialPosition = 0;
        RepeatedByte output;

        RepeatedByteSink() {
        }

        @Override
        public ProtoSink setOutput(RepeatedByte bytes) {
            this.initialPosition = bytes.length;
            this.output = bytes;
            return this;
        }

        @Override
        public ProtoSink clear() {
            this.initialPosition = 0;
            this.output = null;
            return this;
        }

        @Override
        public int spaceLeft() {
            throw new UnsupportedOperationException("Output grows automatically and has no size limit");
        }

        @Override
        public int getTotalBytesWritten() {
            return this.output.length() - this.initialPosition;
        }

        @Override
        public ProtoSink reset() {
            this.output.setLength(this.initialPosition);
            return this;
        }

        @Override
        public void writeRawByte(byte value) {
            this.output.add(value);
        }

        @Override
        public void writeLength(int length) throws IOException {
            this.output.reserve(5 + length);
            super.writeLength(length);
        }

        @Override
        public void writeRawLittleEndian16(short value) {
            int position = this.output.addLength(2);
            ByteUtil.writeLittleEndian16(this.output.array(), position, value);
        }

        @Override
        public void writeRawLittleEndian32(int value) {
            int position = this.output.addLength(4);
            ByteUtil.writeLittleEndian32(this.output.array(), position, value);
        }

        @Override
        public void writeRawLittleEndian64(long value) {
            int position = this.output.addLength(8);
            ByteUtil.writeLittleEndian64(this.output.array(), position, value);
        }

        @Override
        public void writeFloatNoTag(float value) {
            int position = this.output.addLength(4);
            ByteUtil.writeFloat(this.output.array(), position, value);
        }

        @Override
        public void writeDoubleNoTag(double value) {
            int position = this.output.addLength(8);
            ByteUtil.writeDouble(this.output.array(), position, value);
        }

        @Override
        public void writeRawBytes(byte[] value, int offset, int length) {
            this.output.addAll(value, offset, length);
        }

        @Override
        protected void writeRawBooleans(boolean[] values, int length) {
            int position = this.output.addLength(length);
            ByteUtil.writeBooleans(this.output.array(), position, values, length);
        }

        @Override
        protected void writeRawFixed32s(int[] values, int length) {
            int position = this.output.addLength(length * 4);
            ByteUtil.writeLittleEndian32s(this.output.array(), position, values, length);
        }

        @Override
        protected void writeRawFixed64s(long[] values, int length) {
            int position = this.output.addLength(length * 8);
            ByteUtil.writeLittleEndian64s(this.output.array(), position, values, length);
        }

        @Override
        protected void writeRawFloats(float[] values, int length) {
            int position = this.output.addLength(length * 4);
            ByteUtil.writeFloats(this.output.array(), position, values, length);
        }

        @Override
        protected void writeRawDoubles(double[] values, int length) {
            int position = this.output.addLength(length * 8);
            ByteUtil.writeDoubles(this.output.array(), position, values, length);
        }
    }

    static class DirectArraySink
    extends ArraySink {
        private long baseOffset;
        Object gcRef;

        DirectArraySink() {
            if (!UnsafeAccess.isAvailable()) {
                throw new AssertionError((Object)"DirectArraySink requires access to sun.misc.Unsafe");
            }
        }

        @Override
        public ProtoSink setOutput(byte[] buffer, long offset, int length) {
            this.gcRef = null;
            if (buffer != null) {
                this.baseOffset = UnsafeAccess.BYTE_ARRAY_OFFSET;
                return super.setOutput(buffer, offset, length);
            }
            if (offset <= 0L) {
                throw new NullPointerException("null reference with invalid address offset");
            }
            this.buffer = null;
            this.baseOffset = offset;
            this.offset = 0;
            this.position = 0;
            this.limit = length;
            return this;
        }

        @Override
        public ProtoSink setOutput(ByteBuffer buffer) {
            ProtoUtil.checkArgument(!buffer.isReadOnly(), "Buffer is read only");
            return ByteUtil.setRawOutput(this, buffer);
        }

        @Override
        public void writeRawByte(byte value) throws IOException {
            if (this.position == this.limit) {
                throw this.outOfSpace();
            }
            UnsafeAccess.UNSAFE.putByte(this.buffer, this.baseOffset + (long)this.position++, value);
        }

        @Override
        public void writeRawLittleEndian16(short value) throws IOException {
            ByteUtil.writeUnsafeLittleEndian16(this.buffer, this.require(2), value);
        }

        @Override
        public void writeRawLittleEndian32(int value) throws IOException {
            ByteUtil.writeUnsafeLittleEndian32(this.buffer, this.require(4), value);
        }

        @Override
        public void writeRawLittleEndian64(long value) throws IOException {
            ByteUtil.writeUnsafeLittleEndian64(this.buffer, this.require(8), value);
        }

        @Override
        public void writeFloatNoTag(float value) throws IOException {
            ByteUtil.writeUnsafeFloat(this.buffer, this.require(4), value);
        }

        @Override
        public void writeDoubleNoTag(double value) throws IOException {
            ByteUtil.writeUnsafeDouble(this.buffer, this.require(8), value);
        }

        @Override
        public void writeRawBytes(byte[] values, int offset, int length) throws IOException {
            ProtoUtil.checkBounds(values, offset, length);
            ByteUtil.writeUnsafeBytes(this.buffer, this.require(length), values, offset, length);
        }

        @Override
        protected void writeRawBooleans(boolean[] values, int length) throws IOException {
            ByteUtil.writeUnsafeBooleans(this.buffer, this.require(length), values, length);
        }

        @Override
        protected void writeRawFixed32s(int[] values, int length) throws IOException {
            ByteUtil.writeUnsafeLittleEndian32s(this.buffer, this.require(length * 4), values, length);
        }

        @Override
        protected void writeRawFixed64s(long[] values, int length) throws IOException {
            ByteUtil.writeUnsafeLittleEndian64s(this.buffer, this.require(length * 8), values, length);
        }

        @Override
        protected void writeRawFloats(float[] values, int length) throws IOException {
            ByteUtil.writeUnsafeFloats(this.buffer, this.require(length * 4), values, length);
        }

        @Override
        protected void writeRawDoubles(double[] values, int length) throws IOException {
            ByteUtil.writeUnsafeDoubles(this.buffer, this.require(length * 8), values, length);
        }

        @Override
        protected int writeUtf8Encoded(CharSequence value, byte[] buffer, int position, int maxSize) {
            return Utf8.encodeUnsafe(value, buffer, this.baseOffset, position, maxSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long require(int numBytes) throws ProtoSink.OutOfSpaceException {
            if (this.spaceLeft() < numBytes) {
                throw this.outOfSpace();
            }
            try {
                long l = this.baseOffset + (long)this.position;
                return l;
            }
            finally {
                this.position += numBytes;
            }
        }
    }
}

