/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.hebi.quickbuf.ArraySink;
import us.hebi.quickbuf.ArraySource;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.UnsafeAccess;

final class ByteUtil {
    static void writeUInt32(RepeatedByte output, int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                output.add((byte)value);
                return;
            }
            output.add((byte)(value | 0x80));
            value >>>= 7;
        }
    }

    static void writeVarint64(RepeatedByte output, long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.add((byte)value);
                return;
            }
            output.add((byte)(value | 0x80L));
            value >>>= 7;
        }
    }

    static void writeBytes(RepeatedByte store, int length, ProtoSource source) throws IOException {
        int position = store.addLength(length);
        source.readRawBytes(store.array, position, length);
    }

    static int writeUInt32(byte[] buffer, int offset, int limit, int value) throws ProtoSink.OutOfSpaceException {
        int position = offset;
        while (true) {
            if (position == limit) {
                throw new ProtoSink.OutOfSpaceException(position, limit);
            }
            if ((value & 0xFFFFFF80) == 0) {
                buffer[position++] = (byte)value;
                return position - offset;
            }
            buffer[position++] = (byte)(value | 0x80);
            value >>>= 7;
        }
    }

    static int writeVarint64(byte[] buffer, int offset, int limit, long value) throws ProtoSink.OutOfSpaceException {
        int position = offset;
        while (true) {
            if (position == limit) {
                throw new ProtoSink.OutOfSpaceException(position, limit);
            }
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer[position++] = (byte)value;
                return position - offset;
            }
            buffer[position++] = (byte)(value | 0x80L);
            value >>>= 7;
        }
    }

    static void writeLittleEndian16(byte[] buffer, int offset, short value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            if (UnsafeAccess.IS_LITTLE_ENDIAN) {
                UnsafeAccess.UNSAFE.putShort(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
            } else {
                UnsafeAccess.UNSAFE.putShort(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, Short.reverseBytes(value));
            }
        } else {
            buffer[offset] = (byte)(value & 0xFF);
            buffer[offset + 1] = (byte)(value >>> 8);
        }
    }

    static void writeLittleEndian32(byte[] buffer, int offset, int value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            if (UnsafeAccess.IS_LITTLE_ENDIAN) {
                UnsafeAccess.UNSAFE.putInt(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
            } else {
                UnsafeAccess.UNSAFE.putInt(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, Integer.reverseBytes(value));
            }
        } else {
            buffer[offset] = (byte)(value & 0xFF);
            buffer[offset + 1] = (byte)(value >>> 8);
            buffer[offset + 2] = (byte)(value >>> 16);
            buffer[offset + 3] = (byte)(value >>> 24);
        }
    }

    static void writeLittleEndian64(byte[] buffer, int offset, long value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            if (UnsafeAccess.IS_LITTLE_ENDIAN) {
                UnsafeAccess.UNSAFE.putLong(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
            } else {
                UnsafeAccess.UNSAFE.putLong(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, Long.reverseBytes(value));
            }
        } else {
            buffer[offset] = (byte)(value & 0xFFL);
            buffer[offset + 1] = (byte)(value >>> 8);
            buffer[offset + 2] = (byte)(value >>> 16);
            buffer[offset + 3] = (byte)(value >>> 24);
            buffer[offset + 4] = (byte)(value >>> 32);
            buffer[offset + 5] = (byte)(value >>> 40);
            buffer[offset + 6] = (byte)(value >>> 48);
            buffer[offset + 7] = (byte)(value >>> 56);
        }
    }

    static void writeFloat(byte[] buffer, int offset, float value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            UnsafeAccess.UNSAFE.putFloat(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
        } else {
            ByteUtil.writeLittleEndian32(buffer, offset, Float.floatToIntBits(value));
        }
    }

    static void writeDouble(byte[] buffer, int offset, double value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            UnsafeAccess.UNSAFE.putDouble(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
        } else {
            ByteUtil.writeLittleEndian64(buffer, offset, Double.doubleToLongBits(value));
        }
    }

    static void writeBytes(byte[] buffer, int offset, byte[] values, int srcOffset, int length) {
        System.arraycopy(values, srcOffset, buffer, offset, length);
    }

    static void writeBooleans(byte[] buffer, int offset, boolean[] values, int length) {
        if (UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.BOOLEAN_ARRAY_OFFSET, buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                buffer[offset + i] = values[i] ? (byte)1 : 0;
            }
        }
    }

    static void writeLittleEndian32s(byte[] buffer, int offset, int[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.INT_ARRAY_OFFSET, buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, 4L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeLittleEndian32(buffer, offset, values[i]);
                ++i;
                offset += 4;
            }
        }
    }

    static void writeLittleEndian64s(byte[] buffer, int offset, long[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.LONG_ARRAY_OFFSET, buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, 8L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeLittleEndian64(buffer, offset, values[i]);
                ++i;
                offset += 8;
            }
        }
    }

    static void writeFloats(byte[] buffer, int offset, float[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.FLOAT_ARRAY_OFFSET, buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, 4L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeFloat(buffer, offset, values[i]);
                ++i;
                offset += 4;
            }
        }
    }

    static void writeDoubles(byte[] buffer, int offset, double[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.DOUBLE_ARRAY_OFFSET, buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, 8L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeDouble(buffer, offset, values[i]);
                ++i;
                offset += 8;
            }
        }
    }

    static short readLittleEndian16(byte[] buffer, int offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            short value = UnsafeAccess.UNSAFE.getShort(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
            return UnsafeAccess.IS_LITTLE_ENDIAN ? value : Short.reverseBytes(value);
        }
        return (short)(buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8);
    }

    static int readLittleEndian32(byte[] buffer, int offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            int value = UnsafeAccess.UNSAFE.getInt(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
            return UnsafeAccess.IS_LITTLE_ENDIAN ? value : Integer.reverseBytes(value);
        }
        return buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    static long readLittleEndian64(byte[] buffer, int offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            long value = UnsafeAccess.UNSAFE.getLong(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
            return UnsafeAccess.IS_LITTLE_ENDIAN ? value : Long.reverseBytes(value);
        }
        return (long)buffer[offset] & 0xFFL | ((long)buffer[offset + 1] & 0xFFL) << 8 | ((long)buffer[offset + 2] & 0xFFL) << 16 | ((long)buffer[offset + 3] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 32 | ((long)buffer[offset + 5] & 0xFFL) << 40 | ((long)buffer[offset + 6] & 0xFFL) << 48 | ((long)buffer[offset + 7] & 0xFFL) << 56;
    }

    static float readFloat(byte[] buffer, int offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            return UnsafeAccess.UNSAFE.getFloat(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        }
        return Float.intBitsToFloat(ByteUtil.readLittleEndian32(buffer, offset));
    }

    static double readDouble(byte[] buffer, int offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            return UnsafeAccess.UNSAFE.getDouble(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        }
        return Double.longBitsToDouble(ByteUtil.readLittleEndian64(buffer, offset));
    }

    static void readBytes(byte[] buffer, int offset, byte[] dst, int dstOffset, int dstLength) {
        System.arraycopy(buffer, offset, dst, dstOffset, dstLength);
    }

    static void readLittleEndian32s(byte[] buffer, int offset, int[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 4;
            long targetOffset = UnsafeAccess.INT_ARRAY_OFFSET + (long)dstOffset * 4L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, dst, targetOffset, numBytes);
        } else {
            int i = 0;
            while (i < dstLength) {
                dst[i] = ByteUtil.readLittleEndian32(buffer, offset);
                ++i;
                offset += 4;
            }
        }
    }

    static void readLittleEndian64s(byte[] buffer, int offset, long[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 8;
            long targetOffset = UnsafeAccess.LONG_ARRAY_OFFSET + (long)dstOffset * 8L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, dst, targetOffset, numBytes);
        } else {
            int i = 0;
            while (i < dstLength) {
                dst[i] = ByteUtil.readLittleEndian64(buffer, offset);
                ++i;
                offset += 8;
            }
        }
    }

    static void readFloats(byte[] buffer, int offset, float[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 4;
            long targetOffset = UnsafeAccess.FLOAT_ARRAY_OFFSET + (long)dstOffset * 4L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, dst, targetOffset, numBytes);
        } else {
            int i = 0;
            while (i < dstLength) {
                dst[i] = ByteUtil.readFloat(buffer, offset);
                ++i;
                offset += 4;
            }
        }
    }

    static void readDoubles(byte[] buffer, int offset, double[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 8;
            long targetOffset = UnsafeAccess.DOUBLE_ARRAY_OFFSET + (long)dstOffset * 8L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, dst, targetOffset, numBytes);
        } else {
            int i = 0;
            while (i < dstLength) {
                dst[i] = ByteUtil.readDouble(buffer, offset);
                ++i;
                offset += 8;
            }
        }
    }

    static int writeUnsafeUInt32(byte[] buffer, long addressOffset, int offset, int limit, int value) throws ProtoSink.OutOfSpaceException {
        int position = offset;
        while (true) {
            if (position == limit) {
                throw new ProtoSink.OutOfSpaceException(position, limit);
            }
            if ((value & 0xFFFFFF80) == 0) {
                UnsafeAccess.UNSAFE.putByte(buffer, addressOffset + (long)position++, (byte)value);
                return position - offset;
            }
            UnsafeAccess.UNSAFE.putByte(buffer, addressOffset + (long)position++, (byte)(value | 0x80));
            value >>>= 7;
        }
    }

    static void writeUnsafeLittleEndian16(byte[] buffer, long offset, short value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            if (UnsafeAccess.IS_LITTLE_ENDIAN) {
                UnsafeAccess.UNSAFE.putShort(buffer, offset, value);
            } else {
                UnsafeAccess.UNSAFE.putShort(buffer, offset, Short.reverseBytes(value));
            }
        } else {
            UnsafeAccess.UNSAFE.putByte(buffer, offset, (byte)(value & 0xFF));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 1L, (byte)(value >>> 8));
        }
    }

    static void writeUnsafeLittleEndian32(byte[] buffer, long offset, int value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            if (UnsafeAccess.IS_LITTLE_ENDIAN) {
                UnsafeAccess.UNSAFE.putInt(buffer, offset, value);
            } else {
                UnsafeAccess.UNSAFE.putInt(buffer, offset, Integer.reverseBytes(value));
            }
        } else {
            UnsafeAccess.UNSAFE.putByte(buffer, offset, (byte)(value & 0xFF));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 1L, (byte)(value >>> 8));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 2L, (byte)(value >>> 16));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 3L, (byte)(value >>> 24));
        }
    }

    static void writeUnsafeLittleEndian64(byte[] buffer, long offset, long value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            if (UnsafeAccess.IS_LITTLE_ENDIAN) {
                UnsafeAccess.UNSAFE.putLong(buffer, offset, value);
            } else {
                UnsafeAccess.UNSAFE.putLong(buffer, offset, Long.reverseBytes(value));
            }
        } else {
            UnsafeAccess.UNSAFE.putByte(buffer, offset, (byte)(value & 0xFFL));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 1L, (byte)(value >>> 8));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 2L, (byte)(value >>> 16));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 3L, (byte)(value >>> 24));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 4L, (byte)(value >>> 32));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 5L, (byte)(value >>> 40));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 6L, (byte)(value >>> 48));
            UnsafeAccess.UNSAFE.putByte(buffer, offset + 7L, (byte)(value >>> 56));
        }
    }

    static void writeUnsafeFloat(byte[] buffer, long offset, float value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            UnsafeAccess.UNSAFE.putFloat(buffer, offset, value);
        } else {
            ByteUtil.writeUnsafeLittleEndian32(buffer, offset, Float.floatToIntBits(value));
        }
    }

    static void writeUnsafeDouble(byte[] buffer, long offset, double value) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            UnsafeAccess.UNSAFE.putDouble(buffer, offset, value);
        } else {
            ByteUtil.writeUnsafeLittleEndian64(buffer, offset, Double.doubleToLongBits(value));
        }
    }

    static void writeUnsafeBytes(byte[] buffer, long offset, byte[] values, int srcOffset, int length) {
        if (UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)srcOffset, buffer, offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                UnsafeAccess.UNSAFE.putByte(buffer, offset + (long)i, values[srcOffset + i]);
            }
        }
    }

    static void writeUnsafeBooleans(byte[] buffer, long offset, boolean[] values, int length) {
        if (UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.BOOLEAN_ARRAY_OFFSET, buffer, offset, length);
        } else {
            int i = 0;
            while (i < length) {
                UnsafeAccess.UNSAFE.putByte(buffer, offset, values[i] ? (byte)1 : 0);
                ++i;
                ++offset;
            }
        }
    }

    static void writeUnsafeLittleEndian32s(byte[] buffer, long offset, int[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.INT_ARRAY_OFFSET, buffer, offset, 4L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeUnsafeLittleEndian32(buffer, offset, values[i]);
                ++i;
                offset += 4L;
            }
        }
    }

    static void writeUnsafeLittleEndian64s(byte[] buffer, long offset, long[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.LONG_ARRAY_OFFSET, buffer, offset, 8L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeUnsafeLittleEndian64(buffer, offset, values[i]);
                ++i;
                offset += 8L;
            }
        }
    }

    static void writeUnsafeFloats(byte[] buffer, long offset, float[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.FLOAT_ARRAY_OFFSET, buffer, offset, 4L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeUnsafeFloat(buffer, offset, values[i]);
                ++i;
                offset += 4L;
            }
        }
    }

    static void writeUnsafeDoubles(byte[] buffer, long offset, double[] values, int length) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(values, UnsafeAccess.DOUBLE_ARRAY_OFFSET, buffer, offset, 8L * (long)length);
        } else {
            int i = 0;
            while (i < length) {
                ByteUtil.writeUnsafeDouble(buffer, offset, values[i]);
                ++i;
                offset += 8L;
            }
        }
    }

    static short readUnsafeLittleEndian16(byte[] buffer, long offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            short value = UnsafeAccess.UNSAFE.getShort(buffer, offset);
            return UnsafeAccess.IS_LITTLE_ENDIAN ? value : Short.reverseBytes(value);
        }
        return (short)(UnsafeAccess.UNSAFE.getByte(buffer, offset) & 0xFF | (UnsafeAccess.UNSAFE.getByte(buffer, offset + 1L) & 0xFF) << 8);
    }

    static int readUnsafeLittleEndian32(byte[] buffer, long offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            int value = UnsafeAccess.UNSAFE.getInt(buffer, offset);
            return UnsafeAccess.IS_LITTLE_ENDIAN ? value : Integer.reverseBytes(value);
        }
        return UnsafeAccess.UNSAFE.getByte(buffer, offset) & 0xFF | (UnsafeAccess.UNSAFE.getByte(buffer, offset + 1L) & 0xFF) << 8 | (UnsafeAccess.UNSAFE.getByte(buffer, offset + 2L) & 0xFF) << 16 | (UnsafeAccess.UNSAFE.getByte(buffer, offset + 3L) & 0xFF) << 24;
    }

    static long readUnsafeLittleEndian64(byte[] buffer, long offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED) {
            long value = UnsafeAccess.UNSAFE.getLong(buffer, offset);
            return UnsafeAccess.IS_LITTLE_ENDIAN ? value : Long.reverseBytes(value);
        }
        return (long)UnsafeAccess.UNSAFE.getByte(buffer, offset) & 0xFFL | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 1L) & 0xFFL) << 8 | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 2L) & 0xFFL) << 16 | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 3L) & 0xFFL) << 24 | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 4L) & 0xFFL) << 32 | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 5L) & 0xFFL) << 40 | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 6L) & 0xFFL) << 48 | ((long)UnsafeAccess.UNSAFE.getByte(buffer, offset + 7L) & 0xFFL) << 56;
    }

    static float readUnsafeFloat(byte[] buffer, long offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            return UnsafeAccess.UNSAFE.getFloat(buffer, offset);
        }
        return Float.intBitsToFloat(ByteUtil.readUnsafeLittleEndian32(buffer, offset));
    }

    static double readUnsafeDouble(byte[] buffer, long offset) {
        if (UnsafeAccess.ENABLE_UNSAFE_UNALIGNED && UnsafeAccess.IS_LITTLE_ENDIAN) {
            return UnsafeAccess.UNSAFE.getDouble(buffer, offset);
        }
        return Double.longBitsToDouble(ByteUtil.readUnsafeLittleEndian64(buffer, offset));
    }

    static void readUnsafeBytes(byte[] buffer, long offset, byte[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.ENABLE_UNSAFE_COPY) {
            UnsafeAccess.UNSAFE.copyMemory(buffer, offset, dst, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)dstOffset, dstLength);
        } else {
            for (int i = 0; i < dstLength; ++i) {
                dst[dstOffset + i] = UnsafeAccess.UNSAFE.getByte(buffer, offset + (long)i);
            }
        }
    }

    static void readUnsafeLittleEndian32s(byte[] buffer, long offset, int[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 4;
            long targetOffset = UnsafeAccess.INT_ARRAY_OFFSET + (long)dstOffset * 4L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, offset, dst, targetOffset, numBytes);
        } else {
            for (int i = 0; i < dstLength; ++i) {
                dst[i] = ByteUtil.readUnsafeLittleEndian32(buffer, offset);
                offset += 4L;
            }
        }
    }

    static void readUnsafeLittleEndian64s(byte[] buffer, long offset, long[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 8;
            long targetOffset = UnsafeAccess.LONG_ARRAY_OFFSET + (long)dstOffset * 8L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, offset, dst, targetOffset, numBytes);
        } else {
            for (int i = 0; i < dstLength; ++i) {
                dst[i] = ByteUtil.readUnsafeLittleEndian64(buffer, offset);
                offset += 8L;
            }
        }
    }

    static void readUnsafeFloats(byte[] buffer, long offset, float[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 4;
            long targetOffset = UnsafeAccess.FLOAT_ARRAY_OFFSET + (long)dstOffset * 4L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, offset, dst, targetOffset, numBytes);
        } else {
            for (int i = 0; i < dstLength; ++i) {
                dst[i] = ByteUtil.readUnsafeFloat(buffer, offset);
                offset += 4L;
            }
        }
    }

    static void readUnsafeDoubles(byte[] buffer, long offset, double[] dst, int dstOffset, int dstLength) {
        if (UnsafeAccess.IS_LITTLE_ENDIAN && UnsafeAccess.ENABLE_UNSAFE_COPY) {
            int numBytes = dstLength * 8;
            long targetOffset = UnsafeAccess.DOUBLE_ARRAY_OFFSET + (long)dstOffset * 8L;
            UnsafeAccess.UNSAFE.copyMemory(buffer, offset, dst, targetOffset, numBytes);
        } else {
            for (int i = 0; i < dstLength; ++i) {
                dst[i] = ByteUtil.readUnsafeDouble(buffer, offset);
                offset += 8L;
            }
        }
    }

    static boolean isDirectBufferAccessEnabled() {
        return UnsafeAccess.BufferAccess.isAvailable();
    }

    static ProtoSource setRawInput(ProtoSource wrapper, ByteBuffer buffer) {
        ProtoUtil.checkArgument(wrapper instanceof ArraySource, "Expected ArraySource");
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            long offset = buffer.arrayOffset() + buffer.position();
            int length = buffer.remaining();
            wrapper.setInput(array, offset, length);
        } else if (buffer.isReadOnly() && !buffer.isDirect()) {
            ProtoUtil.checkArgument(UnsafeAccess.BufferAccess.isAvailable(), "Accessors for read only buffers are not available");
            byte[] array = UnsafeAccess.BufferAccess.array(buffer);
            long offset = UnsafeAccess.BufferAccess.arrayOffset(buffer) + buffer.position();
            int length = buffer.remaining();
            wrapper.setInput(array, offset, length);
        } else {
            ProtoUtil.checkArgument(UnsafeAccess.BufferAccess.isAvailable(), "Accessors for direct buffers are not available");
            ProtoUtil.checkArgument(wrapper instanceof ArraySource.DirectArraySource, "Expected DirectArraySource");
            long offset = UnsafeAccess.BufferAccess.address(buffer) + (long)buffer.position();
            int length = buffer.remaining();
            wrapper.setInput(null, offset, length);
            ((ArraySource.DirectArraySource)wrapper).gcRef = buffer;
        }
        return wrapper;
    }

    static ProtoSink setRawOutput(ProtoSink wrapper, ByteBuffer buffer) {
        ProtoUtil.checkArgument(!buffer.isReadOnly(), "ByteBuffer is read only");
        ProtoUtil.checkArgument(wrapper instanceof ArraySink, "Expected ArraySource");
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            long offset = buffer.arrayOffset() + buffer.position();
            int length = buffer.remaining();
            wrapper.setOutput(array, offset, length);
        } else {
            ProtoUtil.checkArgument(UnsafeAccess.BufferAccess.isAvailable(), "Accessors for direct buffers are not available");
            ProtoUtil.checkArgument(wrapper instanceof ArraySink.DirectArraySink, "Expected DirectArraySource");
            long offset = UnsafeAccess.BufferAccess.address(buffer) + (long)buffer.position();
            int length = buffer.remaining();
            wrapper.setOutput(null, offset, length);
            ((ArraySink.DirectArraySink)wrapper).gcRef = buffer;
        }
        return wrapper;
    }

    private ByteUtil() {
    }
}

