/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.Utf8String;

class JsonEncoding {
    JsonEncoding() {
    }

    static class BooleanEncoding {
        private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
        private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};

        BooleanEncoding() {
        }

        static void writeBoolean(boolean value, RepeatedByte output) {
            if (value) {
                output.addAll(TRUE);
            } else {
                output.addAll(FALSE);
            }
        }
    }

    static class NumberEncoding {
        private static final int[] THREE_DIGITS = new int[1000];
        private static final int DIGIT_00X = 0;
        private static final int DIGIT_0X0 = 8;
        private static final int DIGIT_X00 = 16;
        private static final int NUM_DIGITS = 28;
        private static final int NUM_FINAL_DIGITS = 24;
        private static final int pow3 = 1000;
        private static final int pow6 = 1000000;
        private static final int pow9 = 1000000000;
        private static final long pow12 = 1000000000000L;
        private static final long pow15 = 1000000000000000L;
        private static final long pow18 = 1000000000000000000L;
        static final double WHOLE_NUMBER = 4.503599627370496E15;
        static final double max3 = 4.503599627370496E12;
        static final double max6 = 4.503599627370496E9;
        static final double max9 = 4503599.627370496;
        static final double max12 = 4503.599627370496;
        private static final byte[] NEGATIVE_INF;
        private static final byte[] POSITIVE_INF;
        private static final byte[] NAN;
        private static final byte[] MIN_INT;
        private static final byte[] MIN_LONG;
        private static final int MAX_INT_SIZE;
        private static final int MAX_LONG_SIZE;
        private static final int MAX_FIXED_DOUBLE_SIZE;

        NumberEncoding() {
        }

        public static void writeInt(int value, RepeatedByte output) {
            output.reserve(MAX_INT_SIZE);
            if (value < 0) {
                if (value == Integer.MIN_VALUE) {
                    output.addAll(MIN_INT);
                    return;
                }
                output.array[output.length++] = 45;
                output.length = NumberEncoding.writePositiveInt(-value, output.array, output.length);
            } else {
                output.length = NumberEncoding.writePositiveInt(value, output.array, output.length);
            }
        }

        public static void writeLong(long value, RepeatedByte output) {
            output.reserve(MAX_LONG_SIZE);
            if (value < 0L) {
                if (value == Long.MIN_VALUE) {
                    output.addAll(MIN_LONG);
                    return;
                }
                output.array[output.length++] = 45;
                output.length = NumberEncoding.writePositiveLong(-value, output.array, output.length);
            } else {
                output.length = NumberEncoding.writePositiveLong(value, output.array, output.length);
            }
        }

        private static int writePositiveInt(int q10, byte[] buf, int pos) {
            int q7 = q10 / 1000;
            if (q7 == 0) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q10);
                return pos;
            }
            int q4 = q10 / 1000000;
            if (q4 == 0) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q7);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000);
                return pos;
            }
            int q1 = q10 / 1000000000;
            if (q1 == 0) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q4);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000);
                return pos;
            }
            pos += NumberEncoding.writeSingleDigit(buf, pos, q1);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q4 - q1 * 1000);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000);
            return pos;
        }

        private static int writePositiveLong(long q19, byte[] buf, int pos) {
            long q16 = q19 / 1000L;
            if (q16 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q19);
                return pos;
            }
            long q13 = q19 / 1000000L;
            if (q13 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q16);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q10 = q19 / 1000000000L;
            if (q10 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q13);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q7 = q19 / 1000000000000L;
            if (q7 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q10);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q4 = q19 / 1000000000000000L;
            if (q4 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q7);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q1 = q19 / 1000000000000000000L;
            if (q1 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q4);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            pos += NumberEncoding.writeSingleDigit(buf, pos, q1);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q4 - q1 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
            return pos;
        }

        public static void writeFloat(float val, RepeatedByte output) {
            NumberEncoding.writeDouble6(val, output);
        }

        public static void writeDouble(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE + 1);
            double pval = NumberEncoding.writeSpecialValues(val, 4.503599627370496E12, output);
            if (pval >= 0.0) {
                if (pval < 4503.599627370496) {
                    NumberEncoding.writeDouble12(pval, output);
                } else if (pval < 4503599.627370496) {
                    NumberEncoding.writeDouble9(pval, output);
                } else if (pval < 4.503599627370496E9) {
                    NumberEncoding.writeDouble6(pval, output);
                } else {
                    NumberEncoding.writeDouble3(pval, output);
                }
            }
        }

        static void writeDouble12(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4503.599627370496, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1.0E12 + 0.5);
                long q7 = q19 / 1000000000000L;
                int pos = NumberEncoding.writePositiveInt((int)q7, buffer, output.length);
                long q12 = q19 - q7 * 1000000000000L;
                if (q12 != 0L) {
                    long q9 = q12 / 1000L;
                    long q6 = q12 / 1000000L;
                    long q3 = q12 / 1000000000L;
                    long r6 = q6 - q3 * 1000L;
                    long r9 = q9 - q6 * 1000L;
                    long r12 = q12 - q9 * 1000L;
                    buffer[pos++] = 46;
                    if (r12 != 0L) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r6);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r9);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r12);
                    } else if (r9 != 0L) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r6);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r9);
                    } else if (r6 != 0L) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r6);
                    } else {
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
                    }
                }
                output.length = pos;
            }
        }

        static void writeDouble9(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4503599.627370496, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1.0E9 + 0.5);
                long q10 = q19 / 1000000000L;
                int pos = NumberEncoding.writePositiveLong(q10, buffer, output.length);
                int q9 = (int)(q19 - q10 * 1000000000L);
                if (q9 != 0) {
                    int q6 = q9 / 1000;
                    int q3 = q9 / 1000000;
                    int r6 = q6 - q3 * 1000;
                    int r9 = q9 - q6 * 1000;
                    buffer[pos++] = 46;
                    if (r9 != 0) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r6);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r9);
                    } else if (r6 != 0) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r6);
                    } else {
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
                    }
                }
                output.length = pos;
            }
        }

        static void writeDouble6(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4.503599627370496E9, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1000000.0 + 0.5);
                long q13 = q19 / 1000000L;
                int pos = NumberEncoding.writePositiveLong(q13, buffer, output.length);
                int q6 = (int)(q19 - q13 * 1000000L);
                if (q6 != 0) {
                    buffer[pos++] = 46;
                    int q3 = q6 / 1000;
                    int r6 = q6 - q3 * 1000;
                    if (r6 != 0) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r6);
                    } else {
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
                    }
                }
                output.length = pos;
            }
        }

        static void writeDouble3(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4.503599627370496E12, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1000.0 + 0.5);
                long q16 = q19 / 1000L;
                int pos = NumberEncoding.writePositiveLong(q16, buffer, output.length);
                int q3 = (int)(q19 - q16 * 1000L);
                if (q3 != 0) {
                    buffer[pos++] = 46;
                    pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
                }
                output.length = pos;
            }
        }

        private static double writeSpecialValues(double val, double maxValue, RepeatedByte output) {
            if (val < 0.0) {
                if (val == Double.NEGATIVE_INFINITY) {
                    output.addAll(NEGATIVE_INF);
                    return -1.0;
                }
                output.add((byte)45);
                val = -val;
            }
            if (val > maxValue) {
                if (val == Double.POSITIVE_INFINITY) {
                    output.addAll(POSITIVE_INF);
                } else if (val > 4.503599627370496E15 && val < 9.223372036854776E18) {
                    NumberEncoding.writeLong((long)val, output);
                } else {
                    StringEncoding.writeRawAscii(Double.toString(val), output);
                }
                return -1.0;
            }
            if (Double.isNaN(val)) {
                output.addAll(NAN);
                return -1.0;
            }
            return val;
        }

        private static int writeSingleDigit(byte[] buf, int pos, long number) {
            buf[pos] = (byte)(48L + number);
            return 1;
        }

        private static int writeFirstDigits(byte[] buf, int pos, long number) {
            return NumberEncoding.writeFirstDigits(buf, pos, (int)number);
        }

        private static int writeFinalDigits(byte[] buf, int pos, long number) {
            return NumberEncoding.writeFinalDigits(buf, pos, (int)number);
        }

        private static int writeThreeDigits(byte[] buf, int pos, long number) {
            NumberEncoding.writeThreeDigits(buf, pos, (int)number);
            return 3;
        }

        private static int writeFirstDigits(byte[] buf, int pos, int number) {
            int v = THREE_DIGITS[number];
            int numDigits = v >>> 28;
            switch (numDigits) {
                case 3: {
                    buf[pos++] = (byte)(v >>> 16);
                }
                case 2: {
                    buf[pos++] = (byte)(v >>> 8);
                }
                case 1: {
                    buf[pos] = (byte)(v >>> 0);
                }
            }
            return numDigits;
        }

        private static int writeFinalDigits(byte[] buf, int pos, int number) {
            int v = THREE_DIGITS[number];
            int numDigits = v >>> 24 & 0xF;
            switch (numDigits) {
                case 3: {
                    buf[pos + 2] = (byte)(v >>> 0);
                }
                case 2: {
                    buf[pos + 1] = (byte)(v >>> 8);
                }
                case 1: {
                    buf[pos] = (byte)(v >>> 16);
                }
            }
            return numDigits;
        }

        private static int writeThreeDigits(byte[] buf, int pos, int number) {
            int v = THREE_DIGITS[number];
            buf[pos] = (byte)(v >>> 16);
            buf[pos + 1] = (byte)(v >>> 8);
            buf[pos + 2] = (byte)(v >>> 0);
            return 3;
        }

        static {
            for (int i = 0; i < 1000; ++i) {
                int numDigits;
                int digit100 = 48 + i / 100;
                int digit10 = 48 + i % 100 / 10;
                int digit1 = 48 + i % 10;
                int n = digit100 == 48 ? (digit10 == 48 ? 1 : 2) : (numDigits = 3);
                int numFinalDigits = digit1 == 48 ? (digit10 == 48 ? 1 : 2) : 3;
                NumberEncoding.THREE_DIGITS[i] = numDigits << 28 | numFinalDigits << 24 | digit100 << 16 | digit10 << 8 | digit1 << 0;
            }
            NEGATIVE_INF = "\"-Infinity\"".getBytes(ProtoUtil.Charsets.ASCII);
            POSITIVE_INF = "\"Infinity\"".getBytes(ProtoUtil.Charsets.ASCII);
            NAN = "\"NaN\"".getBytes(ProtoUtil.Charsets.ASCII);
            MIN_INT = "-2147483648".getBytes(ProtoUtil.Charsets.ASCII);
            MIN_LONG = "-9223372036854775808".getBytes(ProtoUtil.Charsets.ASCII);
            MAX_INT_SIZE = MIN_INT.length;
            MAX_LONG_SIZE = MIN_LONG.length;
            MAX_FIXED_DOUBLE_SIZE = MAX_LONG_SIZE + 1;
        }
    }

    static class StringEncoding {
        private static final byte[] BASE16 = "0123456789abcdef".getBytes(ProtoUtil.Charsets.ASCII);
        private static final boolean[] CAN_DIRECT_WRITE_ASCII = new boolean[128];
        private static final boolean[] CAN_DIRECT_WRITE_UTF8 = new boolean[256];
        private static final byte[] ESCAPE_CHAR = new byte[128];

        StringEncoding() {
        }

        static void writeRawAscii(CharSequence sequence, RepeatedByte output) {
            int length = sequence.length();
            output.reserve(length);
            for (int i = 0; i < length; ++i) {
                output.array[output.length++] = (byte)sequence.charAt(i);
            }
        }

        static void writeQuotedUtf8(Utf8String sequence, RepeatedByte output) {
            int i;
            int offset;
            byte[] utf8;
            int numBytes;
            block5: {
                numBytes = sequence.size();
                utf8 = sequence.bytes();
                offset = output.addLength(numBytes + 2) + 1;
                byte[] out = output.array;
                out[offset - 1] = 34;
                for (i = 0; i < numBytes; ++i) {
                    byte c = utf8[i];
                    if (!CAN_DIRECT_WRITE_UTF8[c & 0xFF]) {
                        output.length = offset + i;
                        break block5;
                    }
                    out[offset + i] = c;
                }
                out[offset + i] = 34;
                return;
            }
            while (i < numBytes) {
                byte c = utf8[i];
                if (CAN_DIRECT_WRITE_UTF8[c & 0xFF]) {
                    int offset2 = output.addLength(1);
                    output.array[offset2] = c;
                } else {
                    StringEncoding.writeEscapedAscii((char)c, output);
                }
                ++i;
            }
            offset = output.addLength(1);
            output.array[offset] = 34;
        }

        static void writeQuotedUtf8(CharSequence sequence, RepeatedByte output) {
            int i;
            int offset;
            int numChars;
            block12: {
                numChars = sequence.length();
                offset = output.addLength(numChars + 2) + 1;
                byte[] ascii = output.array;
                ascii[offset - 1] = 34;
                for (i = 0; i < numChars; ++i) {
                    char c = sequence.charAt(i);
                    if (c >= '\u0080' || !CAN_DIRECT_WRITE_ASCII[c]) {
                        output.length = offset + i;
                        break block12;
                    }
                    ascii[offset + i] = (byte)c;
                }
                ascii[offset + i] = 34;
                return;
            }
            while (i < numChars) {
                char c = sequence.charAt(i);
                if (c < '\u0080') {
                    if (CAN_DIRECT_WRITE_ASCII[c]) {
                        int offset2 = output.addLength(1);
                        output.array[offset2] = (byte)c;
                    } else {
                        StringEncoding.writeEscapedAscii(c, output);
                    }
                } else if (c < '\u0800') {
                    int offset3 = output.addLength(2);
                    output.array[offset3] = (byte)(0x3C0 | c >>> 6);
                    output.array[offset3 + 1] = (byte)(0x80 | 0x3F & c);
                } else if (c < '\ud800' || '\udfff' < c) {
                    int offset4 = output.addLength(3);
                    output.array[offset4] = (byte)(0x1E0 | c >>> 12);
                    output.array[offset4 + 1] = (byte)(0x80 | 0x3F & c >>> 6);
                    output.array[offset4 + 2] = (byte)(0x80 | 0x3F & c);
                } else {
                    char low;
                    if (i + 1 == numChars || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                        throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    int offset5 = output.addLength(4);
                    output.array[offset5] = (byte)(0xF0 | codePoint >>> 18);
                    output.array[offset5 + 1] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    output.array[offset5 + 2] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    output.array[offset5 + 3] = (byte)(0x80 | 0x3F & codePoint);
                }
                ++i;
            }
            offset = output.addLength(1);
            output.array[offset] = 34;
        }

        private static void writeEscapedAscii(char c, RepeatedByte output) {
            byte escapeChar = ESCAPE_CHAR[c];
            if (escapeChar != 0) {
                int offset = output.addLength(2);
                output.array[offset] = 92;
                output.array[offset + 1] = escapeChar;
            } else {
                int offset = output.addLength(6);
                output.array[offset] = 92;
                output.array[offset + 1] = 117;
                output.array[offset + 2] = BASE16[c >> 12 & 0xF];
                output.array[offset + 3] = BASE16[c >> 8 & 0xF];
                output.array[offset + 4] = BASE16[c >> 4 & 0xF];
                output.array[offset + 5] = BASE16[c & 0xF];
            }
        }

        static {
            Arrays.fill(CAN_DIRECT_WRITE_UTF8, true);
            for (int i = 0; i < CAN_DIRECT_WRITE_ASCII.length; ++i) {
                if (i > 31 && i < 126 && i != 34 && i != 92) {
                    StringEncoding.CAN_DIRECT_WRITE_ASCII[i] = true;
                }
                StringEncoding.CAN_DIRECT_WRITE_UTF8[i] = CAN_DIRECT_WRITE_ASCII[i];
            }
            StringEncoding.ESCAPE_CHAR[34] = 34;
            StringEncoding.ESCAPE_CHAR[92] = 92;
            StringEncoding.ESCAPE_CHAR[8] = 98;
            StringEncoding.ESCAPE_CHAR[12] = 102;
            StringEncoding.ESCAPE_CHAR[10] = 110;
            StringEncoding.ESCAPE_CHAR[13] = 114;
            StringEncoding.ESCAPE_CHAR[9] = 116;
        }
    }

    static class Base64Encoding {
        private static final byte[] BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(ProtoUtil.Charsets.ASCII);

        Base64Encoding() {
        }

        static void writeQuotedBase64(byte[] bytes, int length, RepeatedByte output) {
            int encodedLength = (length + 2) / 3 << 2;
            int pos = output.addLength(encodedLength + 2);
            byte[] buffer = output.array;
            buffer[pos++] = 34;
            int blockableLength = length / 3 * 3;
            int i = 0;
            while (i < blockableLength) {
                int bits = (bytes[i] & 0xFF) << 16 | (bytes[i + 1] & 0xFF) << 8 | bytes[i + 2] & 0xFF;
                buffer[pos] = BASE64[bits >>> 18 & 0x3F];
                buffer[pos + 1] = BASE64[bits >>> 12 & 0x3F];
                buffer[pos + 2] = BASE64[bits >>> 6 & 0x3F];
                buffer[pos + 3] = BASE64[bits & 0x3F];
                i += 3;
                pos += 4;
            }
            int remaining = length - blockableLength;
            if (remaining > 0) {
                int bits = (bytes[i] & 0xFF) << 10 | (remaining == 2 ? (bytes[i + 1] & 0xFF) << 2 : 0);
                buffer[pos] = BASE64[bits >>> 12];
                buffer[pos + 1] = BASE64[bits >>> 6 & 0x3F];
                buffer[pos + 2] = remaining == 2 ? BASE64[bits & 0x3F] : 61;
                buffer[pos + 3] = 61;
                pos += 4;
            }
            buffer[pos] = 34;
        }
    }
}

