/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import us.hebi.quickbuf.FieldName;
import us.hebi.quickbuf.JsonEncoding;
import us.hebi.quickbuf.ProtoEnum;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedBoolean;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.RepeatedBytes;
import us.hebi.quickbuf.RepeatedDouble;
import us.hebi.quickbuf.RepeatedEnum;
import us.hebi.quickbuf.RepeatedFloat;
import us.hebi.quickbuf.RepeatedInt;
import us.hebi.quickbuf.RepeatedLong;
import us.hebi.quickbuf.RepeatedMessage;
import us.hebi.quickbuf.RepeatedString;
import us.hebi.quickbuf.Utf8String;

public abstract class JsonSink
implements Closeable,
Flushable {
    protected boolean writeEnumsAsInts = false;
    protected boolean preserveProtoFieldNames = false;
    private RepeatedByte tmpBytes = null;

    public static JsonSink newInstance(RepeatedByte output) {
        return new DefaultJsonSink().setOutput(output);
    }

    public static JsonSink newInstance() {
        return JsonSink.newInstance(RepeatedByte.newEmptyInstance());
    }

    public static JsonSink newPrettyInstance() {
        return JsonSink.newInstance(RepeatedByte.newEmptyInstance()).setPrettyPrinting(true).setWriteEnumsAsInts(false);
    }

    public JsonSink setOutput(RepeatedByte output) {
        throw new UnsupportedOperationException("JsonSink does not support writing to RepeatedByte");
    }

    public JsonSink reserve(int length) {
        throw new UnsupportedOperationException("JsonSink does not support reserving space");
    }

    public abstract JsonSink clear();

    public RepeatedByte getBytes() {
        throw new UnsupportedOperationException("JsonSink does not support access to byte output");
    }

    public CharSequence getChars() {
        throw new UnsupportedOperationException("JsonSink does not support access to character output");
    }

    public JsonSink setWriteEnumsAsInts(boolean writeEnumsAsInts) {
        this.writeEnumsAsInts = writeEnumsAsInts;
        return this;
    }

    public JsonSink setPreserveProtoFieldNames(boolean preserveProtoFieldNames) {
        this.preserveProtoFieldNames = preserveProtoFieldNames;
        return this;
    }

    public JsonSink setPrettyPrinting(boolean prettyPrinting) {
        throw new UnsupportedOperationException("JsonSink does not support setPrettyPrinting");
    }

    public JsonSink writeMessageSilent(ProtoMessage<?> value) {
        try {
            return this.writeMessage(value);
        }
        catch (IOException e) {
            throw new AssertionError("silent write should not have errors", e);
        }
    }

    public JsonSink writeRepeatedMessageSilent(RepeatedMessage<?> value) {
        try {
            return this.writeRepeatedMessage(value);
        }
        catch (IOException e) {
            throw new AssertionError("silent write should not have errors", e);
        }
    }

    public JsonSink writeMessage(ProtoMessage<?> value) throws IOException {
        value.writeTo(this);
        return this;
    }

    public JsonSink writeRepeatedMessage(RepeatedMessage<?> value) throws IOException {
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeMessageValue(((ProtoMessage[])value.array)[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeFixed64(FieldName name, long value) throws IOException {
        return this.writeInt64(name, value);
    }

    public JsonSink writeSFixed64(FieldName name, long value) throws IOException {
        return this.writeInt64(name, value);
    }

    public JsonSink writeUInt64(FieldName name, long value) throws IOException {
        return this.writeInt64(name, value);
    }

    public JsonSink writeSInt64(FieldName name, long value) throws IOException {
        return this.writeInt64(name, value);
    }

    public JsonSink writeFixed32(FieldName name, int value) throws IOException {
        return this.writeInt32(name, value);
    }

    public JsonSink writeSFixed32(FieldName name, int value) throws IOException {
        return this.writeInt32(name, value);
    }

    public JsonSink writeUInt32(FieldName name, int value) throws IOException {
        return this.writeInt32(name, value);
    }

    public JsonSink writeSInt32(FieldName name, int value) throws IOException {
        return this.writeInt32(name, value);
    }

    public JsonSink writeGroup(FieldName name, ProtoMessage value) throws IOException {
        return this.writeMessage(name, value);
    }

    public JsonSink writeRepeatedFixed64(FieldName name, RepeatedLong value) throws IOException {
        return this.writeRepeatedInt64(name, value);
    }

    public JsonSink writeRepeatedSFixed64(FieldName name, RepeatedLong value) throws IOException {
        return this.writeRepeatedInt64(name, value);
    }

    public JsonSink writeRepeatedUInt64(FieldName name, RepeatedLong value) throws IOException {
        return this.writeRepeatedInt64(name, value);
    }

    public JsonSink writeRepeatedSInt64(FieldName name, RepeatedLong value) throws IOException {
        return this.writeRepeatedInt64(name, value);
    }

    public JsonSink writeRepeatedFixed32(FieldName name, RepeatedInt value) throws IOException {
        return this.writeRepeatedInt32(name, value);
    }

    public JsonSink writeRepeatedSFixed32(FieldName name, RepeatedInt value) throws IOException {
        return this.writeRepeatedInt32(name, value);
    }

    public JsonSink writeRepeatedUInt32(FieldName name, RepeatedInt value) throws IOException {
        return this.writeRepeatedInt32(name, value);
    }

    public JsonSink writeRepeatedSInt32(FieldName name, RepeatedInt value) throws IOException {
        return this.writeRepeatedInt32(name, value);
    }

    public JsonSink writeRepeatedGroup(FieldName name, RepeatedMessage<?> value) throws IOException {
        return this.writeRepeatedMessage(name, value);
    }

    public JsonSink writeDouble(FieldName name, double value) throws IOException {
        this.writeFieldName(name);
        this.writeNumber(value);
        return this;
    }

    public JsonSink writeFloat(FieldName name, float value) throws IOException {
        this.writeFieldName(name);
        this.writeNumber(value);
        return this;
    }

    public JsonSink writeInt64(FieldName name, long value) throws IOException {
        this.writeFieldName(name);
        this.writeNumber(value);
        return this;
    }

    public JsonSink writeInt32(FieldName name, int value) throws IOException {
        this.writeFieldName(name);
        this.writeNumber(value);
        return this;
    }

    public JsonSink writeEnum(FieldName name, int value, ProtoEnum.EnumConverter<?> converter) throws IOException {
        this.writeFieldName(name);
        this.writeEnumValue(value, converter);
        return this;
    }

    public JsonSink writeBool(FieldName name, boolean value) throws IOException {
        this.writeFieldName(name);
        this.writeBoolean(value);
        return this;
    }

    public JsonSink writeBytes(FieldName name, RepeatedByte value) throws IOException {
        this.writeFieldName(name);
        this.writeBinary(value);
        return this;
    }

    public JsonSink writeMessage(FieldName name, ProtoMessage<?> value) throws IOException {
        this.writeFieldName(name);
        this.writeMessageValue(value);
        return this;
    }

    public JsonSink writeString(FieldName name, Utf8String value) throws IOException {
        this.writeFieldName(name);
        this.writeString(value);
        return this;
    }

    public JsonSink writeString(FieldName name, CharSequence value) throws IOException {
        this.writeFieldName(name);
        this.writeString(value);
        return this;
    }

    public JsonSink writeRepeatedDouble(FieldName name, RepeatedDouble value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeNumber(value.array[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedInt64(FieldName name, RepeatedLong value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeNumber(value.array[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedFloat(FieldName name, RepeatedFloat value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeNumber(value.array[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedInt32(FieldName name, RepeatedInt value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeNumber(value.array[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedMessage(FieldName name, RepeatedMessage<?> value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeMessageValue(((ProtoMessage[])value.array)[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedString(FieldName name, RepeatedString value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeString(((Utf8String[])value.array)[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedEnum(FieldName name, RepeatedEnum<?> value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeEnumValue(value.array[i], value.converter);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedBool(FieldName name, RepeatedBoolean value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeBoolean(value.array[i]);
        }
        this.endArray();
        return this;
    }

    public JsonSink writeRepeatedBytes(FieldName name, RepeatedBytes value) throws IOException {
        this.writeFieldName(name);
        this.beginArray();
        for (int i = 0; i < value.length; ++i) {
            this.writeBinary(((RepeatedByte[])value.array)[i]);
        }
        this.endArray();
        return this;
    }

    protected void writeEnumValue(int number, ProtoEnum.EnumConverter<?> converter) throws IOException {
        Object value;
        if (!this.writeEnumsAsInts && (value = converter.forNumber(number)) != null) {
            this.writeString(value.getName());
        } else {
            this.writeNumber(number);
        }
    }

    protected abstract void writeFieldName(FieldName var1) throws IOException;

    protected abstract void writeNumber(double var1) throws IOException;

    protected abstract void writeNumber(float var1) throws IOException;

    protected abstract void writeNumber(long var1) throws IOException;

    protected abstract void writeNumber(int var1) throws IOException;

    protected abstract void writeBoolean(boolean var1) throws IOException;

    protected abstract void writeString(Utf8String var1) throws IOException;

    protected abstract void writeString(CharSequence var1) throws IOException;

    protected void writeBinary(RepeatedByte value) throws IOException {
        if (this.tmpBytes == null) {
            this.tmpBytes = RepeatedByte.newEmptyInstance();
        }
        this.tmpBytes.clear();
        JsonEncoding.Base64Encoding.writeQuotedBase64(value.array, value.length, this.tmpBytes);
        String str = new String(this.tmpBytes.array, 1, this.tmpBytes.length - 2, ProtoUtil.Charsets.ASCII);
        this.writeString(str);
    }

    protected abstract void writeMessageValue(ProtoMessage<?> var1) throws IOException;

    public abstract JsonSink beginObject() throws IOException;

    public abstract JsonSink endObject() throws IOException;

    protected abstract void beginArray() throws IOException;

    protected abstract void endArray() throws IOException;

    static class DefaultJsonSink
    extends JsonSink {
        protected RepeatedByte output;
        protected boolean pretty = false;
        protected int indentLevel = 0;
        protected int trailingSpace = 0;
        private boolean isEmptyObjectOrArray = false;
        private static final int SPACES_PER_LEVEL = 2;

        @Override
        public JsonSink setOutput(RepeatedByte output) {
            if (output == null) {
                throw new NullPointerException();
            }
            this.output = output;
            return this;
        }

        @Override
        public JsonSink clear() {
            this.output.clear();
            return this;
        }

        @Override
        public JsonSink setPrettyPrinting(boolean prettyPrinting) {
            this.pretty = prettyPrinting;
            return this;
        }

        @Override
        public JsonSink reserve(int length) {
            this.output.reserve(length);
            return this;
        }

        @Override
        public RepeatedByte getBytes() {
            return this.output;
        }

        @Override
        public CharSequence getChars() {
            return this.toString();
        }

        public String toString() {
            return new String(this.output.array, 0, this.output.length, ProtoUtil.Charsets.UTF_8);
        }

        @Override
        public JsonSink writeRepeatedMessage(RepeatedMessage<?> value) throws IOException {
            super.writeRepeatedMessage(value);
            this.removeTrailingComma();
            return this;
        }

        @Override
        protected void writeFieldName(FieldName name) {
            byte[] key = !this.preserveProtoFieldNames ? name.getJsonKeyBytes() : name.getProtoKeyBytes();
            int pos = this.output.addLength(key.length);
            System.arraycopy(key, 0, this.output.array, pos, key.length);
            this.writeSpaceAfterFieldName();
        }

        @Override
        protected void writeNumber(double value) {
            JsonEncoding.NumberEncoding.writeDouble(value, this.output);
            this.writeMore();
        }

        @Override
        protected void writeNumber(float value) {
            JsonEncoding.NumberEncoding.writeFloat(value, this.output);
            this.writeMore();
        }

        @Override
        protected void writeNumber(long value) {
            JsonEncoding.NumberEncoding.writeLong(value, this.output);
            this.writeMore();
        }

        @Override
        protected void writeNumber(int value) {
            JsonEncoding.NumberEncoding.writeInt(value, this.output);
            this.writeMore();
        }

        @Override
        protected void writeBoolean(boolean value) {
            JsonEncoding.BooleanEncoding.writeBoolean(value, this.output);
            this.writeMore();
        }

        @Override
        protected void writeString(Utf8String value) {
            if (value.hasBytes()) {
                JsonEncoding.StringEncoding.writeQuotedUtf8(value, this.output);
            } else {
                JsonEncoding.StringEncoding.writeQuotedUtf8(value.getString(), this.output);
            }
            this.writeMore();
        }

        @Override
        protected void writeString(CharSequence value) {
            JsonEncoding.StringEncoding.writeQuotedUtf8(value, this.output);
            this.writeMore();
        }

        @Override
        protected void writeBinary(RepeatedByte value) {
            JsonEncoding.Base64Encoding.writeQuotedBase64(value.array, value.length, this.output);
            this.writeMore();
        }

        @Override
        public void writeMessageValue(ProtoMessage<?> value) throws IOException {
            value.writeTo(this);
            this.writeMore();
        }

        @Override
        public JsonSink beginObject() {
            this.isEmptyObjectOrArray = true;
            this.writeChar('{');
            ++this.indentLevel;
            this.writeNewline();
            return this;
        }

        @Override
        public JsonSink endObject() {
            --this.indentLevel;
            this.removeTrailingComma();
            if (!this.isEmptyObjectOrArray) {
                this.writeNewline();
            }
            this.writeChar('}');
            return this;
        }

        @Override
        protected void beginArray() {
            this.isEmptyObjectOrArray = true;
            this.writeChar('[');
            ++this.indentLevel;
            this.writeNewline();
        }

        @Override
        protected void endArray() {
            this.removeTrailingComma();
            --this.indentLevel;
            if (!this.isEmptyObjectOrArray) {
                this.writeNewline();
            }
            this.writeChar(']');
            this.writeMore();
        }

        private void writeMore() {
            this.isEmptyObjectOrArray = false;
            int pos = this.output.length;
            this.writeChar(',');
            this.writeNewline();
            this.trailingSpace = this.output.length - pos;
        }

        private void removeTrailingComma() {
            this.output.length -= this.trailingSpace;
            this.trailingSpace = 0;
        }

        private final void writeSpaceAfterFieldName() {
            if (this.pretty) {
                this.writeChar(' ');
            }
        }

        private void writeNewline() {
            if (this.pretty) {
                int numSpaces = this.indentLevel * 2;
                int pos = this.output.addLength(numSpaces + 1);
                this.output.array[pos++] = 10;
                Arrays.fill(this.output.array, pos, this.output.length, (byte)32);
                this.trailingSpace = numSpaces + 1;
            } else {
                this.trailingSpace = 0;
            }
        }

        private void writeChar(char c) {
            int pos = this.output.addLength(1);
            this.output.array[pos] = (byte)c;
        }

        @Override
        public void close() throws IOException {
            this.output.extendCapacityTo(0);
        }

        @Override
        public void flush() throws IOException {
        }

        protected DefaultJsonSink() {
        }
    }
}

