/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedField;

public final class RepeatedDouble
extends RepeatedField<RepeatedDouble, Double> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 10;
    double[] array = EMPTY_ARRAY;
    private static final double[] EMPTY_ARRAY = new double[0];

    public static RepeatedDouble newEmptyInstance() {
        return new RepeatedDouble();
    }

    public static RepeatedDouble newInstance(double[] initialValue) {
        return RepeatedDouble.newEmptyInstance().copyFrom(initialValue);
    }

    RepeatedDouble() {
    }

    @Override
    protected void extendCapacityTo(int desiredSize) {
        this.array = Arrays.copyOf(this.array, desiredSize);
    }

    @Override
    protected Double getValueAt(int index) {
        return this.get(index);
    }

    public double get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    public RepeatedDouble set(int index, double value) {
        this.checkIndex(index);
        this.array[index] = value;
        return this;
    }

    public RepeatedDouble add(double value) {
        int pos = this.addLength(1);
        this.array[pos] = value;
        return this;
    }

    public RepeatedDouble addAll(double[] values) {
        return this.addAll(values, 0, values.length);
    }

    public RepeatedDouble addAll(double[] buffer, int offset, int length) {
        int pos = this.addLength(length);
        System.arraycopy(buffer, offset, this.array, pos, length);
        return this;
    }

    public RepeatedDouble copyFrom(double[] buffer) {
        return this.copyFrom(buffer, 0, buffer.length);
    }

    public RepeatedDouble copyFrom(double[] buffer, int offset, int length) {
        this.setLength(length);
        System.arraycopy(buffer, offset, this.array, 0, length);
        return this;
    }

    @Override
    public void addAll(RepeatedDouble values) {
        this.addAll(values.array, 0, values.length);
    }

    @Override
    public void copyFrom(RepeatedDouble other) {
        if (other.length > this.length) {
            this.extendCapacityTo(other.length);
        }
        System.arraycopy(other.array, 0, this.array, 0, other.length);
        this.length = other.length;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public final double[] toArray() {
        if (this.length == 0) {
            return EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.array, this.length);
    }

    public final double[] array() {
        return this.array;
    }

    public final RepeatedDouble setLength(int length) {
        if (length - this.array.length > 0) {
            this.extendCapacityTo(length);
        }
        this.length = length;
        return this;
    }

    public final int addLength(int length) {
        int oldLength = this.length;
        int newLength = oldLength + length;
        int oldCapacity = this.array.length;
        if (newLength - oldCapacity > 0) {
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.array == EMPTY_ARRAY ? Math.max(newLength, 10) : newLength;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = RepeatedDouble.hugeCapacity(minCapacity);
            }
            this.extendCapacityTo(newCapacity);
        }
        this.length = newLength;
        return oldLength;
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatedDouble other = (RepeatedDouble)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (ProtoUtil.isEqual(this.array[i], other.array[i])) continue;
            return false;
        }
        return true;
    }
}

