/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.ProtoEnum;
import us.hebi.quickbuf.RepeatedField;

public final class RepeatedEnum<E extends ProtoEnum>
extends RepeatedField<RepeatedEnum<E>, E> {
    final ProtoEnum.EnumConverter<E> converter;
    int[] array = EMPTY_ARRAY;
    private static final int[] EMPTY_ARRAY = new int[0];

    public static <E extends ProtoEnum> RepeatedEnum<E> newEmptyInstance(ProtoEnum.EnumConverter<E> converter) {
        return new RepeatedEnum<E>(converter);
    }

    @Override
    protected E getValueAt(int index) {
        return this.get(index);
    }

    public E get(int index) {
        return this.converter.forNumber(this.getValue(index));
    }

    public RepeatedEnum<E> set(int index, E value) {
        return this.setValue(index, value.getNumber());
    }

    public RepeatedEnum<E> add(E value) {
        return this.addValue(value.getNumber());
    }

    public RepeatedEnum<E> addAll(E ... values) {
        return this.addAll((ProtoEnum[])values, 0, values.length);
    }

    public RepeatedEnum<E> addAll(E[] buffer, int offset, int length) {
        int pos = this.addLength(length);
        for (int i = 0; i < length; ++i) {
            this.array[pos + i] = buffer[i].getNumber();
        }
        return this;
    }

    public RepeatedEnum<E> copyFrom(E[] buffer) {
        return this.setLength(0).addAll((ProtoEnum[])buffer);
    }

    public RepeatedEnum<E> copyFrom(E[] buffer, int offset, int length) {
        return this.setLength(0).addAll((ProtoEnum[])buffer, offset, length);
    }

    @Override
    public void copyFrom(RepeatedEnum<E> other) {
        if (this.converter != other.converter) {
            throw new IllegalArgumentException("Enum types do not match");
        }
        if (other.length > this.length) {
            this.extendCapacityTo(other.length);
        }
        System.arraycopy(other.array, 0, this.array, 0, other.length);
        this.length = other.length;
    }

    @Override
    public void addAll(RepeatedEnum<E> values) {
        int pos = this.addLength(values.length);
        System.arraycopy(values.array, 0, this.array, pos, values.length);
    }

    public int getValue(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    public RepeatedEnum<E> setValue(int index, int value) {
        this.checkIndex(index);
        this.array[index] = value;
        return this;
    }

    public RepeatedEnum<E> addValue(int value) {
        this.reserve(1);
        this.array[this.length++] = value;
        return this;
    }

    public RepeatedEnum<E> addAllValues(int ... values) {
        return this.addAllValues(values, 0, values.length);
    }

    public RepeatedEnum<E> addAllValues(int[] buffer, int offset, int length) {
        int pos = this.addLength(length);
        System.arraycopy(buffer, offset, this.array, pos, length);
        return this;
    }

    public RepeatedEnum<E> copyFromValues(int[] buffer) {
        return this.setLength(0).addAllValues(buffer);
    }

    public RepeatedEnum<E> copyFromValues(int[] buffer, int offset, int length) {
        return this.setLength(0).addAllValues(buffer, offset, length);
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public final int[] toArray() {
        if (this.length == 0) {
            return EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.array, this.length);
    }

    public final int[] array() {
        return this.array;
    }

    public final RepeatedEnum<E> setLength(int length) {
        if (this.array.length < length) {
            this.extendCapacityTo(length);
        }
        this.length = length;
        return this;
    }

    public final int addLength(int length) {
        int oldLength = this.length;
        int newLength = oldLength + length;
        if (this.array.length < newLength) {
            this.extendCapacityTo(newLength);
        }
        this.length = newLength;
        return oldLength;
    }

    @Override
    protected void extendCapacityTo(int desiredSize) {
        int[] newValues = new int[desiredSize];
        System.arraycopy(this.array, 0, newValues, 0, this.length);
        this.array = newValues;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatedEnum other = (RepeatedEnum)o;
        if (this.converter != other.converter || this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] == other.array[i]) continue;
            return false;
        }
        return true;
    }

    private RepeatedEnum(ProtoEnum.EnumConverter<E> converter) {
        if (converter == null) {
            throw new NullPointerException();
        }
        this.converter = converter;
    }
}

