/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.RepeatedField;

abstract class RepeatedObject<SubType extends RepeatedObject<SubType, STORE, IN, OUT>, STORE, IN, OUT>
extends RepeatedField<SubType, OUT> {
    final STORE[] EMPTY = this.allocateArray0(0);
    protected STORE[] array = this.EMPTY;

    RepeatedObject() {
    }

    public final STORE next() {
        this.reserve(1);
        return this.array[this.length++];
    }

    @Override
    protected OUT getValueAt(int index) {
        return this.get(index);
    }

    public final OUT get(int index) {
        this.checkIndex(index);
        return this.getIndex0(index);
    }

    public final void set(int index, IN value) {
        this.checkIndex(index);
        this.setIndex0(index, value);
    }

    @Override
    public final void addAll(IN[] values) {
        this.addAll(values, 0, values.length);
    }

    public final void addAll(IN[] buffer, int offset, int length) {
        this.reserve(length);
        for (int i = offset; i < length; ++i) {
            this.add(buffer[i]);
        }
    }

    public final void add(IN value) {
        this.reserve(1);
        this.setIndex0(this.length++, value);
    }

    @Override
    public final void copyFrom(IN[] buffer) {
        this.copyFrom(buffer, 0, buffer.length);
    }

    public final void copyFrom(IN[] buffer, int offset, int length) {
        this.length = 0;
        this.addAll(buffer, offset, length);
    }

    @Override
    public final void copyFrom(SubType other) {
        if (((RepeatedObject)other).length > this.length) {
            this.extendCapacityTo(((RepeatedObject)other).length);
        }
        this.length = ((RepeatedObject)other).length;
        for (int i = 0; i < this.length; ++i) {
            this.copyFrom0(this.array[i], ((RepeatedObject)other).array[i]);
        }
    }

    @Override
    public void addAll(SubType values) {
        int newLength = this.length + ((RepeatedObject)values).length;
        this.extendCapacityTo(newLength);
        for (int i = 0; i < ((RepeatedObject)values).length; ++i) {
            this.copyFrom0(this.array[this.length + i], ((RepeatedObject)values).array[i]);
        }
        this.length = newLength;
    }

    @Override
    public final int capacity() {
        return this.array.length;
    }

    public final String toString() {
        return Arrays.toString(Arrays.copyOf(this.array, this.length));
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatedObject other = (RepeatedObject)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.isEqual(this.array[i], other.array[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(STORE a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    public final SubType clear() {
        for (int i = 0; i < this.length; ++i) {
            this.clearIndex0(i);
        }
        return (SubType)((RepeatedObject)super.clear());
    }

    @Override
    protected final void extendCapacityTo(int desiredSize) {
        STORE[] newValues = this.allocateArray0(desiredSize);
        System.arraycopy(this.array, 0, newValues, 0, this.length);
        this.array = newValues;
        for (int i = this.length; i < this.array.length; ++i) {
            this.array[i] = this.createEmpty();
        }
    }

    protected abstract void copyFrom0(STORE var1, STORE var2);

    protected abstract void clearIndex0(int var1);

    protected abstract void setIndex0(int var1, IN var2);

    protected abstract OUT getIndex0(int var1);

    protected abstract STORE createEmpty();

    protected abstract STORE[] allocateArray0(int var1);
}

