/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;
import us.hebi.quickbuf.ProtoUtil;

class UnsafeAccess {
    static final boolean IS_LITTLE_ENDIAN;
    static final Unsafe UNSAFE;
    static final long BYTE_ARRAY_OFFSET;
    static final long BOOLEAN_ARRAY_OFFSET;
    static final long FLOAT_ARRAY_OFFSET;
    static final long INT_ARRAY_OFFSET;
    static final long DOUBLE_ARRAY_OFFSET;
    static final long LONG_ARRAY_OFFSET;
    static final int MAJOR_JAVA_VERSION;
    static final boolean IS_ARM;
    static final boolean ENABLE_UNSAFE;
    static final boolean ENABLE_UNSAFE_UNALIGNED;
    static final boolean ENABLE_UNSAFE_COPY;

    UnsafeAccess() {
    }

    static boolean isAvailable() {
        return UNSAFE != null && ENABLE_UNSAFE;
    }

    static boolean isCopyMemoryAvailable() {
        return ENABLE_UNSAFE_COPY;
    }

    static boolean allowUnalignedAccess() {
        return ENABLE_UNSAFE_UNALIGNED;
    }

    static {
        Unsafe unsafe = null;
        long byteArrayOffset = 0L;
        long booleanArrayOffset = 0L;
        long floatArrayOffset = 0L;
        long intArrayOffset = 0L;
        long doubleArrayOffset = 0L;
        long longArrayOffset = 0L;
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return (Unsafe)f.get(null);
                }
            };
            unsafe = AccessController.doPrivileged(action);
            byteArrayOffset = unsafe.arrayBaseOffset(byte[].class);
            booleanArrayOffset = unsafe.arrayBaseOffset(boolean[].class);
            floatArrayOffset = unsafe.arrayBaseOffset(float[].class);
            intArrayOffset = unsafe.arrayBaseOffset(int[].class);
            doubleArrayOffset = unsafe.arrayBaseOffset(double[].class);
            longArrayOffset = unsafe.arrayBaseOffset(long[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UNSAFE = unsafe;
        BYTE_ARRAY_OFFSET = byteArrayOffset;
        BOOLEAN_ARRAY_OFFSET = booleanArrayOffset;
        FLOAT_ARRAY_OFFSET = floatArrayOffset;
        INT_ARRAY_OFFSET = intArrayOffset;
        DOUBLE_ARRAY_OFFSET = doubleArrayOffset;
        LONG_ARRAY_OFFSET = longArrayOffset;
        IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        String specVersion = System.getProperty("java.specification.version", "1.6");
        String[] parts = specVersion.split("\\.");
        MAJOR_JAVA_VERSION = "0.9".equals(specVersion) ? 6 : ("1".equals(parts[0]) ? Integer.parseInt(parts[1]) : Integer.parseInt(parts[0]));
        IS_ARM = Boolean.getBoolean("jvm.isarm") || System.getProperty("os.arch", "N/A").startsWith("arm") || System.getProperty("os.arch", "N/A").startsWith("aarch");
        ENABLE_UNSAFE = !Boolean.getBoolean("quickbuf.disable_unsafe_access");
        ENABLE_UNSAFE_UNALIGNED = ENABLE_UNSAFE && !IS_ARM && !Boolean.getBoolean("quickbuf.disable_unaligned_access");
        ENABLE_UNSAFE_COPY = ENABLE_UNSAFE && MAJOR_JAVA_VERSION >= 7;
    }

    static class BufferAccess {
        static final boolean IS_AVAILABLE;
        static final long ARRAY_BASE_OFFSET;
        static final long BYTE_BUFFER_HB_FIELD_OFFSET;
        static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET;
        static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;

        BufferAccess() {
        }

        public static boolean isAvailable() {
            return IS_AVAILABLE;
        }

        static long address(ByteBuffer buffer) {
            ProtoUtil.checkState(BufferAccess.isAvailable(), "native buffer access is disabled on this platform");
            ProtoUtil.checkArgument(buffer.isDirect(), "buffer.isDirect() must be true");
            return UNSAFE.getLong(buffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
        }

        static byte[] array(ByteBuffer buffer) {
            ProtoUtil.checkState(BufferAccess.isAvailable(), "native buffer access is disabled on this platform");
            ProtoUtil.checkArgument(!buffer.isDirect(), "buffer must wrap an array");
            return (byte[])UNSAFE.getObject(buffer, BYTE_BUFFER_HB_FIELD_OFFSET);
        }

        static int arrayOffset(ByteBuffer buffer) {
            ProtoUtil.checkState(BufferAccess.isAvailable(), "native buffer access is disabled on this platform");
            ProtoUtil.checkArgument(!buffer.isDirect(), "buffer must wrap an array");
            return UNSAFE.getInt(buffer, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
        }

        static {
            boolean isAvailable;
            ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            long hb = -1L;
            long offset = -1L;
            long address = -1L;
            try {
                hb = UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("hb"));
                offset = UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("offset"));
                address = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
                isAvailable = true;
            }
            catch (Exception ex) {
                isAvailable = false;
            }
            BYTE_BUFFER_HB_FIELD_OFFSET = hb;
            BYTE_BUFFER_OFFSET_FIELD_OFFSET = offset;
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = address;
            IS_AVAILABLE = ENABLE_UNSAFE && isAvailable;
        }
    }
}

