/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.UnsafeAccess;

class Utf8 {
    static final int MAX_UTF8_EXPANSION = 3;

    Utf8() {
    }

    static int encodedLength(CharSequence sequence) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return utf8Length;
    }

    static int encodeArray(CharSequence sequence, byte[] bytes, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        int j = offset;
        int limit = offset + length;
        for (i = 0; i < utf16Length && i + j < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            bytes[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length;
        }
        j += i;
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080' && j < limit) {
                bytes[j++] = (byte)c;
            } else if (c < '\u0800' && j <= limit - 2) {
                bytes[j++] = (byte)(0x3C0 | c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                bytes[j++] = (byte)(0x1E0 | c >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if (j <= limit - 4) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                }
                int codePoint = Character.toCodePoint(c, low);
                bytes[j++] = (byte)(0xF0 | codePoint >>> 18);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint);
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
            }
            ++i;
        }
        return j;
    }

    static int encodeUnsafe(CharSequence sequence, byte[] bytes, long baseOffset, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        long j = baseOffset + (long)offset;
        long limit = baseOffset + (long)offset + (long)length;
        for (i = 0; i < utf16Length && (long)i + j < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            UnsafeAccess.UNSAFE.putByte(bytes, j + (long)i, (byte)c);
        }
        if (i == utf16Length) {
            return offset + utf16Length;
        }
        j += (long)i;
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080' && j < limit) {
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)c);
            } else if (c < '\u0800' && j <= limit - 2L) {
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x3C0 | c >>> 6));
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x80 | 0x3F & c));
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3L) {
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x1E0 | c >>> 12));
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x80 | 0x3F & c >>> 6));
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x80 | 0x3F & c));
            } else if (j <= limit - 4L) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                }
                int codePoint = Character.toCodePoint(c, low);
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0xF0 | codePoint >>> 18));
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                UnsafeAccess.UNSAFE.putByte(bytes, j++, (byte)(0x80 | 0x3F & codePoint));
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
            }
            ++i;
        }
        return (int)(j - baseOffset);
    }

    static void encodeSink(CharSequence sequence, ProtoSink sink) throws IOException {
        char c;
        int i;
        int utf16Length = sequence.length();
        for (i = 0; i < utf16Length && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            sink.writeRawByte(c);
        }
        if (i == utf16Length) {
            return;
        }
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080') {
                sink.writeRawByte((byte)c);
            } else if (c < '\u0800') {
                sink.writeRawByte((byte)(0x3C0 | c >>> 6));
                sink.writeRawByte((byte)(0x80 | 0x3F & c));
            } else if (c < '\ud800' || '\udfff' < c) {
                sink.writeRawByte((byte)(0x1E0 | c >>> 12));
                sink.writeRawByte((byte)(0x80 | 0x3F & c >>> 6));
                sink.writeRawByte((byte)(0x80 | 0x3F & c));
            } else {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                }
                int codePoint = Character.toCodePoint(c, low);
                sink.writeRawByte((byte)(0xF0 | codePoint >>> 18));
                sink.writeRawByte((byte)(0x80 | 0x3F & codePoint >>> 12));
                sink.writeRawByte((byte)(0x80 | 0x3F & codePoint >>> 6));
                sink.writeRawByte((byte)(0x80 | 0x3F & codePoint));
            }
            ++i;
        }
    }

    static void decodeArray(byte[] bytes, int index, int size, StringBuilder result) {
        byte b;
        int offset;
        if ((index | size | bytes.length - index - size) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index, size));
        }
        int limit = offset + size;
        result.setLength(size);
        int resultPos = 0;
        for (offset = index; offset < limit && DecodeUtil.isOneByte(b = bytes[offset]); ++offset) {
            DecodeUtil.handleOneByte(b, result, resultPos++);
        }
        while (offset < limit) {
            byte byte1;
            if (DecodeUtil.isOneByte(byte1 = bytes[offset++])) {
                byte b2;
                DecodeUtil.handleOneByte(byte1, result, resultPos++);
                while (offset < limit && DecodeUtil.isOneByte(b2 = bytes[offset])) {
                    ++offset;
                    DecodeUtil.handleOneByte(b2, result, resultPos++);
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (offset >= limit) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                DecodeUtil.handleTwoBytes(byte1, bytes[offset++], result, resultPos++);
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (offset >= limit - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                DecodeUtil.handleThreeBytes(byte1, bytes[offset++], bytes[offset++], result, resultPos++);
                continue;
            }
            if (offset >= limit - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            DecodeUtil.handleFourBytes(byte1, bytes[offset++], bytes[offset++], bytes[offset++], result, resultPos++);
            ++resultPos;
        }
        result.setLength(resultPos);
    }

    static void decodeUnsafe(byte[] bytes, int bufferSize, long baseOffset, int index, int size, StringBuilder result) {
        byte b;
        int remaining;
        if ((index | size | bufferSize - index - size) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bufferSize, index, size));
        }
        long offset = baseOffset + (long)index;
        result.setLength(size);
        int resultPos = 0;
        for (remaining = size; remaining > 0 && DecodeUtil.isOneByte(b = UnsafeAccess.UNSAFE.getByte(bytes, offset)); --remaining) {
            ++offset;
            DecodeUtil.handleOneByte(b, result, resultPos++);
        }
        while (remaining > 0) {
            byte byte1 = UnsafeAccess.UNSAFE.getByte(bytes, offset++);
            --remaining;
            if (DecodeUtil.isOneByte(byte1)) {
                byte b2;
                DecodeUtil.handleOneByte(byte1, result, resultPos++);
                while (remaining > 0 && DecodeUtil.isOneByte(b2 = UnsafeAccess.UNSAFE.getByte(bytes, offset))) {
                    ++offset;
                    --remaining;
                    DecodeUtil.handleOneByte(b2, result, resultPos++);
                }
                continue;
            }
            if (DecodeUtil.isTwoBytes(byte1)) {
                if (remaining < 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                byte byte2 = UnsafeAccess.UNSAFE.getByte(bytes, offset++);
                --remaining;
                DecodeUtil.handleTwoBytes(byte1, byte2, result, resultPos++);
                continue;
            }
            if (DecodeUtil.isThreeBytes(byte1)) {
                if (remaining < 2) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                DecodeUtil.handleThreeBytes(byte1, UnsafeAccess.UNSAFE.getByte(bytes, offset++), UnsafeAccess.UNSAFE.getByte(bytes, offset++), result, resultPos++);
                remaining -= 2;
                continue;
            }
            if (remaining < 3) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            DecodeUtil.handleFourBytes(byte1, UnsafeAccess.UNSAFE.getByte(bytes, offset++), UnsafeAccess.UNSAFE.getByte(bytes, offset++), UnsafeAccess.UNSAFE.getByte(bytes, offset++), result, resultPos++);
            remaining -= 3;
            ++resultPos;
        }
        result.setLength(resultPos);
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + index + " of " + length);
        }
    }

    static class DecodeUtil {
        DecodeUtil() {
        }

        static boolean isOneByte(byte b) {
            return b >= 0;
        }

        static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        static void handleOneByte(byte byte1, StringBuilder result, int resultPos) {
            result.setCharAt(resultPos, (char)byte1);
        }

        static void handleTwoBytes(byte byte1, byte byte2, StringBuilder result, int resultPos) throws IllegalArgumentException {
            if (byte1 < -62) {
                throw new IllegalArgumentException("Invalid UTF-8: Illegal leading byte in 2 bytes utf");
            }
            if (DecodeUtil.isNotTrailingByte(byte2)) {
                throw new IllegalArgumentException("Invalid UTF-8: Illegal trailing byte in 2 bytes utf");
            }
            result.setCharAt(resultPos, (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2)));
        }

        static void handleThreeBytes(byte byte1, byte byte2, byte byte3, StringBuilder result, int resultPos) throws IllegalArgumentException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            result.setCharAt(resultPos, (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3)));
        }

        static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, StringBuilder result, int resultPos) throws IllegalArgumentException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            result.setCharAt(resultPos, DecodeUtil.highSurrogate(codepoint));
            result.setCharAt(resultPos + 1, DecodeUtil.lowSurrogate(codepoint));
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }
}

