/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.Utf8;
import us.hebi.quickbuf.Utf8Decoder;

public final class Utf8String {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private int serializedSize = 0;
    private byte[] bytes = ProtoUtil.EMPTY_BYTE_ARRAY;
    private String string = "";

    public static Utf8String newEmptyInstance() {
        return new Utf8String();
    }

    public static Utf8String newInstance(String initialValue) {
        return Utf8String.newEmptyInstance().copyFrom(initialValue);
    }

    byte[] bytes() {
        return this.bytes;
    }

    boolean hasString() {
        return this.string != null;
    }

    boolean hasBytes() {
        return this.serializedSize >= 0;
    }

    public int size() {
        this.ensureSerialized();
        return this.serializedSize;
    }

    void setSize(int size) {
        this.ensureCapacity(size);
        this.serializedSize = size;
        this.string = null;
    }

    private void ensureSerialized() {
        if (this.serializedSize < 0) {
            this.ensureCapacity(this.string.length() * 3);
            this.serializedSize = Utf8.encodeArray(this.string, this.bytes, 0, this.bytes.length);
        }
    }

    public String getString() {
        return this.getString(ProtoUtil.DEFAULT_UTF8_DECODER);
    }

    public String getString(Utf8Decoder decoder) {
        if (this.string == null) {
            this.string = decoder.decode(this.bytes, 0, this.serializedSize);
        }
        return this.string;
    }

    public StringBuilder getChars(StringBuilder store) {
        store.setLength(0);
        if (this.string == null) {
            Utf8.decodeArray(this.bytes, 0, this.serializedSize, store);
        } else {
            store.append(this.string);
        }
        return store;
    }

    public Utf8String copyFrom(CharSequence other) {
        return other instanceof String ? this.copyFrom((String)other) : this.copyFromEncoded(other);
    }

    public Utf8String copyFromUtf8(byte[] bytes) {
        return this.copyFromUtf8(bytes, 0, bytes.length);
    }

    public Utf8String copyFromUtf8(byte[] bytes, int offset, int length) {
        this.setSize(length);
        System.arraycopy(bytes, offset, this.bytes, 0, length);
        return this;
    }

    public Utf8String copyFromEncoded(CharSequence other) {
        this.ensureCapacityInternal(other.length() * 3);
        this.serializedSize = Utf8.encodeArray(other, this.bytes, 0, this.bytes.length);
        this.string = null;
        return this;
    }

    public Utf8String copyFrom(String other) {
        this.serializedSize = -1;
        this.string = other;
        return this;
    }

    public Utf8String copyFrom(Utf8String other) {
        this.string = other.string;
        this.serializedSize = other.serializedSize;
        if (this.serializedSize >= 0) {
            this.ensureCapacityInternal(this.serializedSize);
            System.arraycopy(other.bytes, 0, this.bytes, 0, this.serializedSize);
        }
        return this;
    }

    public void clear() {
        this.serializedSize = 0;
        this.string = "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Utf8String other = (Utf8String)o;
        if (this.string != null && other.string != null) {
            return this.string.equals(other.string);
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.serializedSize; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return 0;
    }

    public String toString() {
        return this.getString();
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.bytes.length > 0) {
            this.bytes = Arrays.copyOf(this.bytes, this.newCapacity(minimumCapacity));
        }
    }

    private int newCapacity(int minCapacity) {
        int newCapacity = (this.bytes.length << 1) + 2;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        return newCapacity <= 0 || 0x7FFFFFF7 - newCapacity < 0 ? this.hugeCapacity(minCapacity) : newCapacity;
    }

    private int hugeCapacity(int minCapacity) {
        if (Integer.MAX_VALUE - minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return Math.max(minCapacity, 0x7FFFFFF7);
    }

    private Utf8String() {
    }
}

