/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import us.hebi.quickbuf.Base64;
import us.hebi.quickbuf.RepeatedByte;

public class Base64Test {
    private final RepeatedByte tmp = RepeatedByte.newEmptyInstance();
    private static final List<byte[]> randomSamples = Base64Test.generateRandomSamples();

    @Test
    public void testDecodeBase64() throws Exception {
        for (byte[] sample : randomSamples) {
            String input = java.util.Base64.getEncoder().encodeToString(sample);
            Assert.assertArrayEquals((byte[])sample, (byte[])this.decodeBase64(input));
        }
    }

    @Test
    public void testDecodeBase64_noPadding() throws Exception {
        for (byte[] sample : randomSamples) {
            String input = java.util.Base64.getEncoder().encodeToString(sample).replaceAll("=", "");
            Assert.assertArrayEquals((byte[])sample, (byte[])this.decodeBase64(input));
        }
    }

    @Test
    public void testDecodeBase64_url() throws Exception {
        for (byte[] sample : randomSamples) {
            String input = java.util.Base64.getUrlEncoder().encodeToString(sample);
            Assert.assertArrayEquals((byte[])sample, (byte[])this.decodeBase64(input));
        }
    }

    @Test
    public void testDecodeBase64_url_noPadding() throws Exception {
        for (byte[] sample : randomSamples) {
            String input = java.util.Base64.getUrlEncoder().encodeToString(sample).replaceAll("=", "");
            Assert.assertArrayEquals((byte[])sample, (byte[])this.decodeBase64(input));
        }
    }

    private byte[] decodeBase64(CharSequence input) {
        return Base64.decodeFast((String)input.toString());
    }

    private static List<byte[]> generateRandomSamples() {
        int n = 50;
        ArrayList<byte[]> samples = new ArrayList<byte[]>(n);
        Random rnd = new Random(0L);
        for (int i = 0; i < n; ++i) {
            byte[] bytes = new byte[i];
            rnd.nextBytes(bytes);
            samples.add(bytes);
        }
        return samples;
    }
}

