/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import protos.test.protobuf.ForeignEnum;
import protos.test.protobuf.ForeignMessage;
import protos.test.protobuf.RepeatedPackables;
import protos.test.protobuf.TestAllTypes;
import protos.test.protobuf.TestEnumsMessage;
import protos.test.protobuf.external.ImportEnum;
import us.hebi.quickbuf.ProtoSource;

public class CompatibilityTest {
    public static String JSON_MANUAL_INPUT = "{\n  \"optionalDouble\": 100,\n  \"optionalFixed64\": 103,\n  \"optionalSfixed64\": 105,\n  \"optionalInt64\": 109,\n  \"optionalUint64\": 111,\n  \"optionalSint64\": 107,\n  \"optionalFloat\": 101,\n  \"optionalFixed32\": 102,\n  \"optionalSfixed32\": 104,\n  \"optionalInt32\": 108,\n  \"optionalUint32\": 110,\n  \"optionalSint32\": 106,\n  \"optionalNestedEnum\": \"FOO\",\n  \"optionalForeignEnum\": \"FOREIGN_BAR\",\n  \"optionalImportEnum\": \"IMPORT_BAZ\",\n  \"optionalBool\": true,\n  \"optionalNestedMessage\": {\n    \"bb\": 2\n  },\n  \"optionalForeignMessage\": {\n    \"c\": 3\n  },\n  \"optionalImportMessage\": {\n  },\n  \"optionalBytes\": \"dXRmOPCfkqk=\",\n  \"defaultBytes\": \"YLQguzhR2dR6y5M9vnA5m/bJLaM68B1Pt3DpjAMl9B0+uviYbacSyCvNTVVL8LVAI8KbYk3p75wvkx78WA+a+wgbEuEHsegF8rT18PHQDC0PYmNGcJIcUFhn/yD2qDNemK+HJThVhrQf7/IFtOBaAAgj94tfj1wCQ5zo9np4HZDL5r8a5/K8QKSXCaBsDjFJm/ApacpC0gPlZrzGlt4I+gECoP0uIzCwlkq7fEQwIN4crQm/1jgf+5Tar7uQxO2RoGE60dxLRwOvhMHWOxqHaSHG1YadYcy5jtE65sCaE/yR4Uki8wHPi8+TQxWmBJ0vB9mD+qkbj05yZey4FafLqw==\",\n  \"optionalString\": \"optionalString\\\\escape\\t\\b\\n\\funi\ud83d\udca9\",\n  \"optionalCord\": \"hello!\",\n  \"repeatedDouble\": [\"NaN\", \"-Infinity\", 0, -28.3],\n  \"repeatedFloat\": [],\n  \"repeatedInt32\": [-2, -1, 0, 1, 2, 3, 4, 5],\n  \"repeatedPackedInt32\": [-1, 0, 1, 2, 3, 4, 5],\n  \"repeatedForeignMessage\": [{\n    \"c\": 0\n  }, {\n    \"c\": 1\n  }, {\n    \"c\": 2\n  }, {\n  }, {\n  }],\n  \"repeatedBytes\": [\"YXNjaWk=\", \"dXRmOPCfkqk=\", \"YXNjaWk=\", \"dXRmOPCfkqk=\", \"\"],\n  \"repeatedString\": [\"hello\", \"world\", \"ascii\", \"utf8\ud83d\udca9\"]\n}";
    public static final String JSON_OBJECT_TYPES_NULL = "{\"optionalNestedMessage\":null,\"repeatedString\":null,\"optionalForeignMessage\":{},\"repeatedBytes\":null}";
    public static final String JSON_ALL_TYPES_NULL = "{\n  \"optionalDouble\": null,\n  \"optionalFixed64\": null,\n  \"optionalSfixed64\": null,\n  \"optionalInt64\": null,\n  \"optionalUint64\": null,\n  \"optionalSint64\": null,\n  \"optionalFloat\": null,\n  \"optionalFixed32\": null,\n  \"optionalSfixed32\": null,\n  \"optionalInt32\": null,\n  \"optionalUint32\": null,\n  \"optionalSint32\": null,\n  \"optionalNestedEnum\": null,\n  \"optionalForeignEnum\": null,\n  \"optionalImportEnum\": null,\n  \"optionalBool\": null,\n  \"optionalNestedMessage\": null,\n  \"optionalForeignMessage\": null,\n  \"optionalImportMessage\": null,\n  \"optionalBytes\": null,\n  \"defaultBytes\": null,\n  \"optionalString\": null,\n  \"optionalCord\": null,\n  \"repeatedDouble\": null,\n  \"repeatedFloat\": null,\n  \"repeatedInt32\": null,\n  \"repeatedPackedInt32\": null,\n  \"repeatedForeignMessage\": null,\n  \"repeatedBytes\": null,\n  \"repeatedString\": null\n}";
    public static String JSON_NULL = "null";
    public static String JSON_EMPTY = "{\n}";
    public static String JSON_LIST_EMPTY = "[]";
    public static String JSON_BAD_BOOLEAN = "{\"optionalBool\": fals}";
    public static String JSON_UNKNOWN_FIELD = "{\"unknownField\": false}";
    public static String JSON_UNKNOWN_FIELD_NULL = "{\"unknownField\": null}";
    public static String JSON_REPEATED_BYTES_NULL_VALUE = "{\"repeatedBytes\": [null,null]}";
    public static String JSON_REPEATED_MSG_NULL_VALUE = "{\"repeatedForeignMessage\": [null,null]}";
    public static final String JSON_SPECIAL_NUMBERS = "{\n  \"repeated_double\": [\n    \"NaN\",\n    \"-Infinity\",\n    0,\n    -28.3,\n    3E6,\n    -0,\n    17E-3,\n    Infinity\n  ],\n  \"repeated_int32\": [\n    \"0\",\n    \"2147483647\",\n    -2147483648,\n    0,\n    1,\n    2\n  ]\n}";
    public static final String JSON_ROOT_LIST = "[" + JSON_EMPTY + ",\n" + "{\n  \"repeated_double\": [\n    \"NaN\",\n    \"-Infinity\",\n    0,\n    -28.3,\n    3E6,\n    -0,\n    17E-3,\n    Infinity\n  ],\n  \"repeated_int32\": [\n    \"0\",\n    \"2147483647\",\n    -2147483648,\n    0,\n    1,\n    2\n  ]\n}" + ",\n" + JSON_MANUAL_INPUT + "]";

    @Test
    public void testCompatibilityWithProtobufJava() throws IOException {
        byte[] serializedMsg = CompatibilityTest.getCombinedMessage();
        TestAllTypes.Builder expected = TestAllTypes.newBuilder();
        protos.test.quickbuf.TestAllTypes msg = protos.test.quickbuf.TestAllTypes.newInstance();
        for (int i = 0; i < 3; ++i) {
            expected.mergeFrom(serializedMsg);
            msg.mergeFrom(ProtoSource.newInstance((byte[])serializedMsg));
        }
        Assert.assertEquals((Object)expected.build(), (Object)TestAllTypes.parseFrom(msg.toByteArray()));
        Assert.assertEquals((Object)msg, (Object)protos.test.quickbuf.TestAllTypes.parseFrom(msg.toByteArray()));
    }

    @Test
    public void testCompatibilityWithProtobufJava_Unsafe() throws IOException {
        byte[] serializedMsg = CompatibilityTest.getCombinedMessage();
        TestAllTypes.Builder expected = TestAllTypes.newBuilder();
        protos.test.quickbuf.TestAllTypes msg = protos.test.quickbuf.TestAllTypes.newInstance();
        for (int i = 0; i < 3; ++i) {
            expected.mergeFrom(serializedMsg);
            msg.mergeFrom(ProtoSource.newDirectSource().setInput(serializedMsg));
        }
        Assert.assertEquals((Object)expected.build(), (Object)TestAllTypes.parseFrom(msg.toByteArray()));
        Assert.assertEquals((Object)msg, (Object)protos.test.quickbuf.TestAllTypes.parseFrom(msg.toByteArray()));
    }

    public static byte[] getDescriptorBytes() {
        return TestAllTypes.getDescriptor().toProto().toByteArray();
    }

    public static String printDescriptor(byte[] bytes) {
        try {
            return DescriptorProtos.DescriptorProto.parseFrom((byte[])bytes).toString();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Iterable<byte[]> getAllMessages() {
        return Arrays.asList(CompatibilityTest.optionalBytes(), CompatibilityTest.optionalPrimitives(), CompatibilityTest.optionalMessages(), CompatibilityTest.optionalBytes(), CompatibilityTest.optionalEnums(), CompatibilityTest.optionalString(), CompatibilityTest.repeatedMessages(), CompatibilityTest.repeatedBytes(), CompatibilityTest.repeatedStrings(), CompatibilityTest.repeatedBytes());
    }

    public static byte[] getCombinedMessage() throws IOException {
        TestAllTypes.Builder msg = TestAllTypes.newBuilder();
        for (byte[] bytes : CompatibilityTest.getAllMessages()) {
            msg.mergeFrom(bytes);
        }
        return msg.addAllRepeatedPackedInt32(Arrays.asList(-1, 0, 1, 2, 3, 4, 5)).addAllRepeatedInt32(Arrays.asList(-2, -1, 0, 1, 2, 3, 4, 5)).build().toByteArray();
    }

    public static byte[] optionalPrimitives() {
        TestAllTypes msg = TestAllTypes.newBuilder().setOptionalBool(true).setOptionalDouble(100.0).setOptionalFloat(101.0f).setOptionalFixed32(102).setOptionalFixed64(103L).setOptionalSfixed32(104).setOptionalSfixed64(105L).setOptionalSint32(106).setOptionalSint64(107L).setOptionalInt32(108).setOptionalInt64(109L).setOptionalUint32(110).setOptionalUint64(111L).build();
        return msg.toByteArray();
    }

    public static byte[] repeatedPackablesNonPacked() {
        RepeatedPackables.NonPacked msg = RepeatedPackables.NonPacked.newBuilder().addAllBools(Arrays.asList(true, false, true, true)).addAllDoubles(Arrays.asList(Double.POSITIVE_INFINITY, -2.0, 3.0, 4.0)).addAllFloats(Arrays.asList(Float.valueOf(10.0f), Float.valueOf(20.0f), Float.valueOf(-30.0f), Float.valueOf(Float.NaN))).addAllFixed32S(Arrays.asList(2, -2, 4, 67423)).addAllFixed64S(Arrays.asList(3231313L, 6L, -7L, 8L)).addAllSfixed32S(Arrays.asList(2, -3, 4, 5)).addAllSfixed64S(Arrays.asList(5L, -6L, 7L, -8L)).addAllSint32S(Arrays.asList(2, -3, 4, 5)).addAllSint64S(Arrays.asList(5L, 6L, -7L, 8L)).addAllInt32S(Arrays.asList(2, 3, -4, 5)).addAllInt64S(Arrays.asList(5L, -6L, 7L, 8L)).addAllUint32S(Arrays.asList(2, 300, 4, 5)).addAllUint64S(Arrays.asList(5L, 6L, 0x170000000000L, 8L)).build();
        return msg.toByteArray();
    }

    public static byte[] repeatedPackablesPacked() {
        RepeatedPackables.Packed msg = RepeatedPackables.Packed.newBuilder().addAllBools(Arrays.asList(true, false, true, true)).addAllDoubles(Arrays.asList(Double.POSITIVE_INFINITY, -2.0, 3.0, 4.0)).addAllFloats(Arrays.asList(Float.valueOf(10.0f), Float.valueOf(20.0f), Float.valueOf(-30.0f), Float.valueOf(Float.NaN))).addAllFixed32S(Arrays.asList(2, -2, 4, 67423)).addAllFixed64S(Arrays.asList(3231313L, 6L, -7L, 8L)).addAllSfixed32S(Arrays.asList(2, -3, 4, 5)).addAllSfixed64S(Arrays.asList(5L, -6L, 7L, -8L)).addAllSint32S(Arrays.asList(2, -3, 4, 5)).addAllSint64S(Arrays.asList(5L, 6L, -7L, 8L)).addAllInt32S(Arrays.asList(2, 3, -4, 5)).addAllInt64S(Arrays.asList(5L, -6L, 7L, 8L)).addAllUint32S(Arrays.asList(2, 300, 4, 5)).addAllUint64S(Arrays.asList(5L, 6L, 0x170000000000L, 8L)).build();
        return msg.toByteArray();
    }

    public static byte[] optionalEnums() {
        TestAllTypes msg = TestAllTypes.newBuilder().setOptionalNestedEnum(TestAllTypes.NestedEnum.FOO).setOptionalForeignEnum(ForeignEnum.FOREIGN_BAR).setOptionalImportEnum(ImportEnum.IMPORT_BAZ).build();
        return msg.toByteArray();
    }

    public static byte[] repeatedEnums() {
        return TestAllTypes.newBuilder().addRepeatedNestedEnum(TestAllTypes.NestedEnum.FOO).addRepeatedNestedEnum(TestAllTypes.NestedEnum.BAR).addRepeatedNestedEnum(TestAllTypes.NestedEnum.BAZ).addRepeatedNestedEnum(TestAllTypes.NestedEnum.BAZ).build().toByteArray();
    }

    public static byte[] optionalString() {
        TestAllTypes msg = TestAllTypes.newBuilder().setOptionalString("optionalString\ud83d\udca9").setOptionalCord("hello!").build();
        return msg.toByteArray();
    }

    public static byte[] optionalMessages() {
        TestAllTypes msg = TestAllTypes.newBuilder().setOptionalNestedMessage(TestAllTypes.NestedMessage.newBuilder().setBb(2).build()).setOptionalForeignMessage(ForeignMessage.newBuilder().setC(3).build()).setOptionalGroup(TestAllTypes.OptionalGroup.newBuilder().setA(4)).build();
        return msg.toByteArray();
    }

    public static byte[] repeatedMessages() {
        return TestAllTypes.newBuilder().addRepeatedForeignMessage(ForeignMessage.newBuilder().setC(0)).addRepeatedForeignMessage(ForeignMessage.newBuilder().setC(1)).addRepeatedForeignMessage(ForeignMessage.newBuilder().setC(2)).addRepeatedGroup(TestAllTypes.RepeatedGroup.newBuilder().setA(3)).addRepeatedGroup(TestAllTypes.RepeatedGroup.newBuilder().setA(4)).build().toByteArray();
    }

    public static byte[] repeatedStrings() {
        return TestAllTypes.newBuilder().addAllRepeatedString(Arrays.asList("hello", "world", "ascii", "utf8\ud83d\udca9")).build().toByteArray();
    }

    public static byte[] optionalBytes() {
        byte[] randomBytes = new byte[256];
        new Random(0L).nextBytes(randomBytes);
        return TestAllTypes.newBuilder().setOptionalBytes(ByteString.copyFromUtf8((String)"utf8\ud83d\udca9")).setDefaultBytes(ByteString.copyFrom((byte[])randomBytes)).build().toByteArray();
    }

    public static byte[] repeatedBytes() {
        return TestAllTypes.newBuilder().addRepeatedBytes(ByteString.copyFromUtf8((String)"ascii")).addRepeatedBytes(ByteString.copyFromUtf8((String)"utf8\ud83d\udca9")).build().toByteArray();
    }

    @Test
    public void testProtobufJavaJsonParser() {
        TestAllTypes msg = CompatibilityTest.parseJson(JSON_EMPTY);
        Assert.assertEquals((long)0L, (long)msg.getSerializedSize());
        msg = CompatibilityTest.parseJson(JSON_OBJECT_TYPES_NULL);
        Assert.assertEquals((long)3L, (long)msg.getSerializedSize());
        msg = CompatibilityTest.parseJson(JSON_ALL_TYPES_NULL);
        Assert.assertEquals((long)0L, (long)msg.getSerializedSize());
        msg = CompatibilityTest.parseJson(JSON_SPECIAL_NUMBERS);
        Assert.assertEquals((long)111L, (long)msg.getSerializedSize());
        this.testError(JSON_REPEATED_BYTES_NULL_VALUE, "Repeated field elements cannot be null in field: quickbuf_unittest.TestAllTypes.repeated_bytes");
        this.testError(JSON_REPEATED_MSG_NULL_VALUE, "Repeated field elements cannot be null in field: quickbuf_unittest.TestAllTypes.repeated_foreign_message");
        this.testError(JSON_NULL, "Expect message object but got: null");
        this.testError(JSON_LIST_EMPTY, "Expect message object but got: []");
        this.testError(JSON_BAD_BOOLEAN, "Invalid bool value: \"fals\"");
        this.testError(JSON_UNKNOWN_FIELD, "Cannot find field: unknownField in message quickbuf_unittest.TestAllTypes");
        this.testError(JSON_UNKNOWN_FIELD_NULL, "Cannot find field: unknownField in message quickbuf_unittest.TestAllTypes");
    }

    @Ignore
    @Test
    public void testProtobufJavaJsonParserManualInput() {
        Assert.assertEquals((long)591L, (long)CompatibilityTest.parseJson(JSON_MANUAL_INPUT).getSerializedSize());
    }

    @Test
    public void testEnumAlias() throws IOException {
        TestEnumsMessage.Builder msg = TestEnumsMessage.newBuilder();
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_RUNNING));
        Assert.assertEquals((long)1L, (long)1L);
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_UNSPECIFIED), (Object)((Object)msg.getField()));
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)msg.getDefaultStarted()));
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)msg.getDefaultRunning()));
        Assert.assertArrayEquals((byte[])msg.clear().setField(TestEnumsMessage.EnumAllowingAlias.EAA_STARTED).build().toByteArray(), (byte[])msg.clear().setField(TestEnumsMessage.EnumAllowingAlias.EAA_RUNNING).build().toByteArray());
        Assert.assertEquals((Object)msg.clear().setField(TestEnumsMessage.EnumAllowingAlias.EAA_STARTED).toString(), (Object)msg.clear().setField(TestEnumsMessage.EnumAllowingAlias.EAA_RUNNING).toString());
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)CompatibilityTest.mergeJson("{\"field\":\"EAA_STARTED\"}", TestEnumsMessage.newBuilder()).getField()));
        try {
            CompatibilityTest.mergeJson("{\"field\":\"EAA_PROCESSING\"}", TestEnumsMessage.newBuilder());
            Assert.fail((String)"EAA_PROCESSING");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static TestAllTypes parseJson(String input) {
        return CompatibilityTest.mergeJson(input, TestAllTypes.newBuilder()).build();
    }

    private static <B extends Message.Builder> B mergeJson(String input, B builder) {
        try {
            JsonFormat.parser().merge(input, builder);
            return builder;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(input, e);
        }
    }

    private void testError(String input, String error) {
        try {
            JsonFormat.parser().merge(input, (Message.Builder)TestAllTypes.newBuilder());
            Assert.fail((String)("expected error: " + error));
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)error, (Object)ioe.getMessage());
        }
    }
}

