/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.util.Base64;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import us.hebi.quickbuf.JsonDecoding;
import us.hebi.quickbuf.JsonEncoding;
import us.hebi.quickbuf.JsonSource;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;

public class JsonEncodingTest {
    final Random rnd = new Random(0L);
    final RepeatedByte bytes = RepeatedByte.newEmptyInstance();
    final JsonEncoding.FloatEncoder floatEncoder = JsonEncoding.getFloatEncoder();
    static final int n = 10000;

    @Before
    public void setUp() throws Exception {
        this.rnd.setSeed(0L);
    }

    @Test
    public void testBase64Encoding() throws Exception {
        for (int i = 0; i < 100; ++i) {
            byte[] expected = new byte[i];
            this.rnd.nextBytes(expected);
            JsonEncoding.Base64Encoding.writeQuotedBase64((byte[])expected, (int)expected.length, (RepeatedByte)this.bytes.setLength(0));
            String result = new String(this.bytes.array, 1, this.bytes.length - 2, ProtoUtil.Charsets.UTF_8);
            byte[] actual = Base64.getDecoder().decode(result);
            Assert.assertArrayEquals((String)result, (byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testStringEncoding() throws Exception {
        this.testString("ascii");
        this.testString("\"\\\b\f\n\r\t", "\\\"\\\\\\b\\f\\n\\r\\t");
        this.testString("\u0000\u0001\u007f", "\\u0000\\u0001\\u007f");
        this.testString("\u0080\ud800\udc00\udbd0\udc00");
        this.testString("\u07ff\uffff\udbbf\udfff");
        this.testString("\udbff\udfff");
        this.testString("\u0103\u0463\ud835\udd20\u056e\u1ec1\u017f\u0123\u021f\u13a5\ud835\udc8b\u01e9\u013e\u1e3f\ua791\u022f\ud835\ude31\ud835\udc5e\ud835\uddcb\ud835\ude34\u0236\ud835\udf84\ud835\udf08\u03c8\ud835\udc99\ud835\ude06\ud835\udea31234567890!@#$%^&*()-_=+[{]};:',<.>/?\ud835\ude08\u1e06\ud835\udda2\ud835\udd6f\u0664\u1e1e\u050d\u041d\u01cf\ud835\ude45\u0198\u0538\u2c98\ud835\ude49\u09e6\u03a1\ud835\udde4\u024c\ud835\udce2\u021a\u0426\ud835\udcb1\u0460\ud835\udce7\u01b3\u0224\u0467\u15af\u0107\ud835\uddf1\u1ec5\ud835\udc53\ud835\ude5c\u10b9\ud835\udfb2\ud835\udc57\ud835\udc8c\u013c\u1e43\u0149\u043e\ud835\udf8e\ud835\udc92\u1d72\ua731\ud835\ude69\u1eeb\ud835\uddcf\u0175\ud835\udc99\ud835\udc9a\u017a1234567890!@#$%^&*()-_=+[{]};:',<.>/?\u0410\u1e02\u2ca4\ud835\uddd7\ud835\udda4\ud835\uddd9\ua7a0\ua4e7\u020a\ud835\udc09\ud835\udf25\ua4e1\ud835\udc40\ud835\udc75\u01ec\ud835\ude7f\ud835\udc44\u0156\ud835\udc46\ud835\udcaf\ud835\uddb4\ud835\ude1d\ud835\ude1e\ua4eb\u0178\ud835\udf21\u1ea3\ud835\ude22\u0180\ud835\uddbc\u1e0b\u1ebf\u1d6e\u210a\ud835\ude5d\u13a5\ud835\udd5b\u043a\u03b9\u1e43\u0564\u2c7a\ud835\udcc5\ud835\ude32\ud835\udd63\ud835\udd98\u0167\ud835\udc62\u1e7d\u1e89\ud835\ude05\u10e7\u017e1234567890!@#$%^&*()-_=+[{]};:',<.>/?\u0466\ud835\ude71\u0187\u15de\u03a3\u2131\u050d\u04a4\u0661\ud835\udd0d\u041a\ud835\udcdb\ud835\udcdc\u019d\u020e\ud835\udeb8\ud835\udc44\u1e5a\ud835\udce2\u1e6e\u1e7a\u01b2\u13d4\ua4eb\ud835\ude88\ud835\udead\ud835\udf36\u13cf\u00e7\u10eb\ud835\udc52\ud835\uddbf\ud835\uddc0\u1e27\ud835\uddc2\ud835\udc23\u049d\u026d\u1e3f\ud835\udd5f\ud835\udc28\ud835\udf54\ud835\udd62\u1e5b\ud835\udcfc\u0442\u00fa\ud835\udd33\u1e83\u292c\ud835\udf72\ud835\uddd31234567890!@#$%^&*()-_=+[{]};:',<.>/?\ud835\udda0\u0392\ud835\udc9e\ud835\ude0b\ud835\ude74\ud835\udcd5\u0122\u021e\u1ec8\ud835\udd75\ua4d7\u029f\ud835\ude7c\u2115\u09e6\ud835\udeb8\ud835\udde4\u0540\ua4e2\u1e70\u01d3\u2164\ud835\udd1a\u2cac\ud835\udc4c\ud835\ude55\ud835\ude22\ud835\udd64");
    }

    @Test
    public void testIntEncoding() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            this.testInt(1 << i / 1000);
            this.testInt(i << i / 1000);
            this.testInt(this.rnd.nextInt());
        }
        this.testInt(Integer.MIN_VALUE);
        this.testInt(Integer.MAX_VALUE);
        this.testInt(0);
    }

    @Test
    public void testIntDigits() throws Exception {
        int value = 0;
        for (int i = 0; i <= 10; ++i) {
            value = value * 10 + i % 10;
            this.testInt(value);
            this.testInt(-value);
        }
    }

    @Test
    public void testLongEncoding() throws Exception {
        long testVal = 1L;
        for (long i = 0L; i < 10000L; ++i) {
            this.testLong(1L << (int)(i / 100L));
            this.testLong(i << (int)(i / 100L));
            this.testLong(this.rnd.nextLong());
        }
        this.testLong(Long.MIN_VALUE);
        this.testLong(Long.MAX_VALUE);
        this.testLong(0L);
    }

    @Test
    public void testLongDigits() throws Exception {
        long value = 0L;
        for (int i = 0; i <= 19; ++i) {
            value = value * 10L + (long)(i % 10);
            this.testLong(value);
            this.testLong(-value);
        }
    }

    @Test
    public void testDoubleEncoding() throws Exception {
        double multiplier = 1.0E-100;
        for (int i = 0; i < 10000; ++i) {
            this.testDouble(this.rnd.nextDouble());
            this.testDouble(this.rnd.nextDouble() * (double)this.rnd.nextLong());
            this.testDouble(Math.PI * multiplier + 0.1);
            this.testDouble(Math.PI * -multiplier + 0.1);
            multiplier *= 10.0;
        }
        this.testDouble(99.9);
        this.testDouble(99.99);
        this.testDouble(99.999);
        this.testDouble(99.9999);
        this.testDouble(99.99999);
        this.testDouble(99.999999);
        this.testDouble(99.9999999);
        this.testDouble(99.99999999);
        this.testDouble(99.999999999);
        this.testDouble(99.9999999999);
        this.testDouble(99.99999999999);
        this.testDouble(99.999999999999);
        this.testDouble(99.9999999999999);
        this.testDouble(99.99999999999999);
        this.testDouble(100.0);
        this.testDouble(Double.MIN_VALUE);
        this.testDouble(Double.MAX_VALUE);
        this.testDouble(0.0);
        Assert.assertEquals((Object)"\"Infinity\"", (Object)this.encodeDouble(Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"\"-Infinity\"", (Object)this.encodeDouble(Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"\"NaN\"", (Object)this.encodeDouble(Double.NaN));
    }

    @Test
    public void testFloatEncoding() throws Exception {
        double multiplier = 1.0E-100;
        for (int i = 0; i < 10000; ++i) {
            this.testFloat(this.rnd.nextFloat());
            this.testFloat(this.rnd.nextFloat() * (float)this.rnd.nextInt());
            this.testFloat((float)(Math.PI * multiplier + 0.1));
            this.testFloat((float)(Math.PI * -multiplier + 0.1));
            multiplier *= 10.0;
        }
        this.testFloat(99.9f);
        this.testFloat(99.99f);
        this.testFloat(99.999f);
        this.testFloat(99.9999f);
        this.testFloat(99.99999f);
        this.testFloat(100.0f);
        this.testFloat(100.0f);
        this.testFloat(100.0f);
        this.testFloat(100.0f);
        this.testFloat(100.0f);
        this.testFloat(100.0f);
        this.testFloat(100.0f);
        this.testFloat(Float.MIN_VALUE);
        this.testFloat(Float.MAX_VALUE);
        this.testFloat(0.0f);
        Assert.assertEquals((Object)"\"Infinity\"", (Object)this.encodeFloat(Float.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"\"-Infinity\"", (Object)this.encodeFloat(Float.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"\"NaN\"", (Object)this.encodeFloat(Float.NaN));
    }

    @Test
    public void testNumTrailingZeros() {
        Assert.assertEquals((long)2L, (long)JsonEncodingTest.getTrailingZeros("0.1200"));
        Assert.assertEquals((long)1L, (long)JsonEncodingTest.getTrailingZeros("0.0"));
        Assert.assertEquals((long)5L, (long)JsonEncodingTest.getTrailingZeros("0.12300000"));
        Assert.assertEquals((long)1L, (long)JsonEncodingTest.getTrailingZeros("12.0"));
        Assert.assertEquals((long)0L, (long)JsonEncodingTest.getTrailingZeros("1.2"));
        Assert.assertEquals((long)3L, (long)JsonEncodingTest.getTrailingZeros("123456000"));
        Assert.assertEquals((long)2L, (long)JsonEncodingTest.getTrailingZeros("000"));
        Assert.assertEquals((long)0L, (long)JsonEncodingTest.getTrailingZeros("0"));
        Assert.assertEquals((long)0L, (long)JsonEncodingTest.getTrailingZeros("012"));
        Assert.assertEquals((long)0L, (long)JsonEncodingTest.getTrailingZeros("500000064"));
        Assert.assertEquals((long)0L, (long)JsonEncodingTest.getTrailingZeros("500000064"));
        Assert.assertEquals((long)0L, (long)JsonEncodingTest.getTrailingZeros("10000000000000003"));
    }

    private static int getTrailingZeros(String chars) {
        byte[] bytes = chars.getBytes(ProtoUtil.Charsets.ASCII);
        return JsonEncoding.NoCommaFloatEncoder.getNumTrailingZeros((byte[])bytes, (int)0, (int)(bytes.length - 1));
    }

    @Test
    public void testBooleanEncoding() throws Exception {
        Assert.assertEquals((Object)"true", (Object)this.encodeBoolean(true));
        Assert.assertEquals((Object)"false", (Object)this.encodeBoolean(false));
    }

    private String encodeBoolean(boolean expected) {
        JsonEncoding.BooleanEncoding.writeBoolean((boolean)expected, (RepeatedByte)this.bytes);
        return this.getString();
    }

    private String encodeInt(int expected) {
        JsonEncoding.NumberEncoding.writeInt((int)expected, (RepeatedByte)this.bytes);
        return this.getString();
    }

    private String encodeLong(long expected) {
        JsonEncoding.NumberEncoding.writeLong((long)expected, (RepeatedByte)this.bytes);
        return this.getString();
    }

    private String encodeDouble(double expected) {
        this.floatEncoder.writeDouble(expected, this.bytes);
        return this.getString();
    }

    private String encodeFloat(float expected) {
        this.floatEncoder.writeFloat(expected, this.bytes);
        return this.getString();
    }

    private void testInt(int expected) {
        int actual = Integer.parseInt(this.encodeInt(expected));
        Assert.assertEquals((long)expected, (long)actual);
    }

    private void testLong(long expected) {
        long actual = Long.parseLong(this.encodeLong(expected));
        Assert.assertEquals((long)expected, (long)actual);
    }

    private void testDouble(double expected) {
        String encoded = this.encodeDouble(expected);
        if (expected == Double.POSITIVE_INFINITY) {
            Assert.assertEquals((Object)"\"Infinity\"", (Object)encoded);
        } else if (expected == Double.NEGATIVE_INFINITY) {
            Assert.assertEquals((Object)"\"-Infinity\"", (Object)encoded);
        } else if (Double.isNaN(expected)) {
            Assert.assertEquals((Object)"\"NaN\"", (Object)encoded);
        } else if (!JsonEncoding.ENCODE_FLOAT_FIXED) {
            if (!ProtoUtil.isEqual((double)expected, (double)Double.parseDouble(encoded))) {
                Assert.assertEquals((Object)Double.toString(expected), (Object)encoded);
            }
        } else {
            double p = Math.abs(expected);
            if (p > 4.503599627370496E12) {
                Assert.assertEquals((String)encoded, (double)expected, (double)Double.parseDouble(encoded), (double)1.0);
            } else if (p > 4.503599627370496E9) {
                Assert.assertEquals((String)encoded, (double)expected, (double)Double.parseDouble(encoded), (double)0.001);
            } else if (p > 4503599.627370496) {
                Assert.assertEquals((String)encoded, (double)expected, (double)Double.parseDouble(encoded), (double)1.0E-6);
            } else if (p > 4503.599627370496) {
                Assert.assertEquals((String)encoded, (double)expected, (double)Double.parseDouble(encoded), (double)1.0E-9);
            } else {
                Assert.assertEquals((String)encoded, (double)expected, (double)Double.parseDouble(encoded), (double)1.0E-12);
            }
        }
    }

    private void testFloat(float expected) {
        String encoded = this.encodeFloat(expected);
        if (expected == Float.POSITIVE_INFINITY) {
            Assert.assertEquals((Object)"\"Infinity\"", (Object)encoded);
        } else if (expected == Float.NEGATIVE_INFINITY) {
            Assert.assertEquals((Object)"\"-Infinity\"", (Object)encoded);
        } else if (Float.isNaN(expected)) {
            Assert.assertEquals((Object)"\"NaN\"", (Object)encoded);
        } else if (!JsonEncoding.ENCODE_FLOAT_FIXED) {
            if (!ProtoUtil.isEqual((float)expected, (float)Float.parseFloat(encoded))) {
                Assert.assertEquals((Object)Float.toString(expected), (Object)encoded);
            }
        } else {
            Assert.assertEquals((String)encoded, (double)expected, (double)Float.parseFloat(encoded), (double)1.0E-6);
        }
    }

    private void testString(String expected) throws IOException {
        this.testString(expected, expected);
    }

    private void testString(String input, String expected) throws IOException {
        JsonEncoding.StringEncoding.writeQuotedUtf8((CharSequence)input, (RepeatedByte)this.bytes.setLength(0));
        int length = this.bytes.length;
        String actual = this.getString();
        Assert.assertEquals((String)expected, (Object)expected, (Object)actual.substring(1, actual.length() - 1));
        RepeatedByte utf8 = RepeatedByte.newEmptyInstance();
        JsonSource.ArraySource lexer = new JsonSource.ArraySource(this.bytes.array, 1, length - 1);
        JsonDecoding.StringDecoding.readQuotedUtf8((JsonDecoding.JsonLexer)lexer, (RepeatedByte)utf8);
        Assert.assertEquals((Object)input, (Object)new String(utf8.array, 0, utf8.length, ProtoUtil.Charsets.UTF_8));
        StringBuilder builder = new StringBuilder(length);
        lexer = new JsonSource.ArraySource(this.bytes.array, 1, length - 1);
        JsonDecoding.StringDecoding.readQuotedUtf8((JsonDecoding.JsonLexer)lexer, (StringBuilder)builder);
        Assert.assertEquals((Object)input, (Object)builder.toString());
    }

    private String getString() {
        try {
            String string = new String(this.bytes.array, 0, this.bytes.length, ProtoUtil.Charsets.UTF_8);
            return string;
        }
        finally {
            this.bytes.setLength(0);
        }
    }
}

