/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.util.Base64;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import protos.test.quickbuf.ForeignEnum;
import protos.test.quickbuf.TestAllTypes;
import protos.test.quickbuf.external.ImportEnum;
import us.hebi.quickbuf.CompatibilityTest;
import us.hebi.quickbuf.FieldName;
import us.hebi.quickbuf.JsonSink;
import us.hebi.quickbuf.JsonSource;
import us.hebi.quickbuf.ProtoEnum;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.RepeatedFloat;
import us.hebi.quickbuf.RepeatedMessage;

public class JsonSinkTest {
    protected String miniOutputResult = "{\"optionalDouble\":100,\"optionalFixed64\":103,\"optionalSfixed64\":105,\"optionalInt64\":109,\"optionalUint64\":111,\"optionalSint64\":107,\"optionalFloat\":101,\"optionalFixed32\":102,\"optionalSfixed32\":104,\"optionalInt32\":108,\"optionalUint32\":110,\"optionalSint32\":106,\"optionalNestedEnum\":\"FOO\",\"optionalForeignEnum\":\"FOREIGN_BAR\",\"optionalImportEnum\":\"IMPORT_BAZ\",\"optionalBool\":true,\"optionalNestedMessage\":{\"bb\":2},\"optionalForeignMessage\":{\"c\":3},\"optionalImportMessage\":{},\"optionalgroup\":{\"a\":4},\"optionalBytes\":\"dXRmOPCfkqk=\",\"defaultBytes\":\"YLQguzhR2dR6y5M9vnA5m/bJLaM68B1Pt3DpjAMl9B0+uviYbacSyCvNTVVL8LVAI8KbYk3p75wvkx78WA+a+wgbEuEHsegF8rT18PHQDC0PYmNGcJIcUFhn/yD2qDNemK+HJThVhrQf7/IFtOBaAAgj94tfj1wCQ5zo9np4HZDL5r8a5/K8QKSXCaBsDjFJm/ApacpC0gPlZrzGlt4I+gECoP0uIzCwlkq7fEQwIN4crQm/1jgf+5Tar7uQxO2RoGE60dxLRwOvhMHWOxqHaSHG1YadYcy5jtE65sCaE/yR4Uki8wHPi8+TQxWmBJ0vB9mD+qkbj05yZey4FafLqw==\",\"optionalString\":\"optionalString\ud83d\udca9\",\"optionalCord\":\"hello!\",\"repeatedDouble\":[\"NaN\",\"-Infinity\",0,-28.3],\"repeatedFloat\":[],\"repeatedInt32\":[-2,-1,0,1,2,3,4,5],\"repeatedPackedInt32\":[-1,0,1,2,3,4,5],\"repeatedForeignMessage\":[{\"c\":0},{\"c\":1},{\"c\":2},{},{}],\"repeatedgroup\":[{\"a\":3},{\"a\":4}],\"repeatedBytes\":[\"YXNjaWk=\",\"dXRmOPCfkqk=\",\"YXNjaWk=\",\"dXRmOPCfkqk=\",\"\"],\"repeatedString\":[\"hello\",\"world\",\"ascii\",\"utf8\ud83d\udca9\"]}";
    protected String miniOutputProtoNamesResult = "{\"optional_double\":100,\"optional_fixed64\":103,\"optional_sfixed64\":105,\"optional_int64\":109,\"optional_uint64\":111,\"optional_sint64\":107,\"optional_float\":101,\"optional_fixed32\":102,\"optional_sfixed32\":104,\"optional_int32\":108,\"optional_uint32\":110,\"optional_sint32\":106,\"optional_nested_enum\":\"FOO\",\"optional_foreign_enum\":\"FOREIGN_BAR\",\"optional_import_enum\":\"IMPORT_BAZ\",\"optional_bool\":true,\"optional_nested_message\":{\"bb\":2},\"optional_foreign_message\":{\"c\":3},\"optional_import_message\":{},\"optionalgroup\":{\"a\":4},\"optional_bytes\":\"dXRmOPCfkqk=\",\"default_bytes\":\"YLQguzhR2dR6y5M9vnA5m/bJLaM68B1Pt3DpjAMl9B0+uviYbacSyCvNTVVL8LVAI8KbYk3p75wvkx78WA+a+wgbEuEHsegF8rT18PHQDC0PYmNGcJIcUFhn/yD2qDNemK+HJThVhrQf7/IFtOBaAAgj94tfj1wCQ5zo9np4HZDL5r8a5/K8QKSXCaBsDjFJm/ApacpC0gPlZrzGlt4I+gECoP0uIzCwlkq7fEQwIN4crQm/1jgf+5Tar7uQxO2RoGE60dxLRwOvhMHWOxqHaSHG1YadYcy5jtE65sCaE/yR4Uki8wHPi8+TQxWmBJ0vB9mD+qkbj05yZey4FafLqw==\",\"optional_string\":\"optionalString\ud83d\udca9\",\"optional_cord\":\"hello!\",\"repeated_double\":[\"NaN\",\"-Infinity\",0,-28.3],\"repeated_float\":[],\"repeated_int32\":[-2,-1,0,1,2,3,4,5],\"repeated_packed_int32\":[-1,0,1,2,3,4,5],\"repeated_foreign_message\":[{\"c\":0},{\"c\":1},{\"c\":2},{},{}],\"repeatedgroup\":[{\"a\":3},{\"a\":4}],\"repeated_bytes\":[\"YXNjaWk=\",\"dXRmOPCfkqk=\",\"YXNjaWk=\",\"dXRmOPCfkqk=\",\"\"],\"repeated_string\":[\"hello\",\"world\",\"ascii\",\"utf8\ud83d\udca9\"]}";
    protected String repeatedFloatResult = "{\"data\":[-2,-1.5,-1,-0.5,0,0.5,1,1.5]}";

    @Test
    public void testEnumNumbers() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.setOptionalNestedEnumValue(2);
        msg.setOptionalForeignEnum(ForeignEnum.FOREIGN_BAR);
        msg.setOptionalImportEnum(ImportEnum.IMPORT_BAZ);
        String desired = "{\"optionalNestedEnum\":2,\"optionalForeignEnum\":5,\"optionalImportEnum\":9}";
        String result = this.newJsonSink().setWriteEnumsAsInts(true).writeMessage((ProtoMessage)msg).toString();
        Assert.assertEquals((Object)desired, (Object)result);
    }

    @Test
    public void testEnumStrings() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.setOptionalNestedEnumValue(2);
        msg.setOptionalForeignEnum(ForeignEnum.FOREIGN_BAR);
        msg.setOptionalImportEnum(ImportEnum.IMPORT_BAZ);
        String desired = "{\"optionalNestedEnum\":\"BAR\",\"optionalForeignEnum\":\"FOREIGN_BAR\",\"optionalImportEnum\":\"IMPORT_BAZ\"}";
        String result = this.newJsonSink().setWriteEnumsAsInts(false).writeMessage((ProtoMessage)msg).toString();
        Assert.assertEquals((Object)desired, (Object)result);
    }

    @Test
    public void testRepeatedEnums() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableRepeatedNestedEnum().addAll((ProtoEnum[])new TestAllTypes.NestedEnum[]{TestAllTypes.NestedEnum.FOO, TestAllTypes.NestedEnum.BAR, TestAllTypes.NestedEnum.BAZ, TestAllTypes.NestedEnum.BAZ});
        Assert.assertEquals((Object)"{\"repeatedNestedEnum\":[\"FOO\",\"BAR\",\"BAZ\",\"BAZ\"]}", (Object)this.newJsonSink().setWriteEnumsAsInts(false).writeMessage((ProtoMessage)msg).toString());
        Assert.assertEquals((Object)"{\"repeatedNestedEnum\":[1,2,3,3]}", (Object)this.newJsonSink().setWriteEnumsAsInts(true).writeMessage((ProtoMessage)msg).toString());
    }

    @Test
    public void testBytes() throws IOException {
        byte[] randomBytes = new byte[31];
        new Random(0L).nextBytes(randomBytes);
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableOptionalBytes().addAll(randomBytes);
        msg.getMutableRepeatedBytes().add((Object)new byte[0]);
        msg.getMutableRepeatedBytes().add((Object)new byte[]{65});
        msg.getMutableRepeatedBytes().add((Object)new byte[]{65, 66});
        msg.getMutableRepeatedBytes().add((Object)new byte[]{65, 66, 67});
        msg.getMutableRepeatedBytes().add((Object)randomBytes);
        String javaBase64 = Base64.getEncoder().encodeToString(randomBytes);
        String desired = String.format("{\"optionalBytes\":\"%s\",\"repeatedBytes\":[\"\",\"QQ==\",\"QUI=\",\"QUJD\",\"%s\"]}", javaBase64, javaBase64);
        Assert.assertEquals((Object)desired, (Object)this.newJsonSink().writeMessage((ProtoMessage)msg).toString());
    }

    @Test
    public void testNestedMessage() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableOptionalNestedMessage().setBb(2);
        msg.getMutableOptionalForeignMessage();
        Assert.assertEquals((Object)"{\"optionalNestedMessage\":{\"bb\":2},\"optionalForeignMessage\":{}}", (Object)this.newJsonSink().writeMessage((ProtoMessage)msg).toString());
        Assert.assertEquals((Object)"{\n  \"optionalNestedMessage\": {\n    \"bb\": 2\n  },\n  \"optionalForeignMessage\": {\n  }\n}", (Object)msg.toString());
    }

    @Test
    public void testEmptyMessage() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        Assert.assertEquals((Object)"{}", (Object)this.newJsonSink().writeMessage((ProtoMessage)msg).toString());
        Assert.assertEquals((Object)"{\n}", (Object)this.newJsonSinkPretty().writeMessage((ProtoMessage)msg).toString());
    }

    @Test
    public void testPrettyOutput() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        msg.getMutableOptionalImportMessage();
        msg.getMutableRepeatedForeignMessage().next();
        msg.getMutableRepeatedForeignMessage().next();
        msg.getMutableRepeatedBytes().next();
        msg.getMutableRepeatedDouble().addAll(new double[]{Double.NaN, Double.NEGATIVE_INFINITY, 0.0, -28.3});
        msg.getMutableRepeatedFloat().clear();
        String desired = "{\n  \"optionalDouble\": 100,\n  \"optionalFixed64\": 103,\n  \"optionalSfixed64\": 105,\n  \"optionalInt64\": 109,\n  \"optionalUint64\": 111,\n  \"optionalSint64\": 107,\n  \"optionalFloat\": 101,\n  \"optionalFixed32\": 102,\n  \"optionalSfixed32\": 104,\n  \"optionalInt32\": 108,\n  \"optionalUint32\": 110,\n  \"optionalSint32\": 106,\n  \"optionalNestedEnum\": \"FOO\",\n  \"optionalForeignEnum\": \"FOREIGN_BAR\",\n  \"optionalImportEnum\": \"IMPORT_BAZ\",\n  \"optionalBool\": true,\n  \"optionalNestedMessage\": {\n    \"bb\": 2\n  },\n  \"optionalForeignMessage\": {\n    \"c\": 3\n  },\n  \"optionalImportMessage\": {\n  },\n  \"optionalgroup\": {\n    \"a\": 4\n  },\n  \"optionalBytes\": \"dXRmOPCfkqk=\",\n  \"defaultBytes\": \"YLQguzhR2dR6y5M9vnA5m/bJLaM68B1Pt3DpjAMl9B0+uviYbacSyCvNTVVL8LVAI8KbYk3p75wvkx78WA+a+wgbEuEHsegF8rT18PHQDC0PYmNGcJIcUFhn/yD2qDNemK+HJThVhrQf7/IFtOBaAAgj94tfj1wCQ5zo9np4HZDL5r8a5/K8QKSXCaBsDjFJm/ApacpC0gPlZrzGlt4I+gECoP0uIzCwlkq7fEQwIN4crQm/1jgf+5Tar7uQxO2RoGE60dxLRwOvhMHWOxqHaSHG1YadYcy5jtE65sCaE/yR4Uki8wHPi8+TQxWmBJ0vB9mD+qkbj05yZey4FafLqw==\",\n  \"optionalString\": \"optionalString\ud83d\udca9\",\n  \"optionalCord\": \"hello!\",\n  \"repeatedDouble\": [\"NaN\", \"-Infinity\", 0, -28.3],\n  \"repeatedFloat\": [],\n  \"repeatedInt32\": [-2, -1, 0, 1, 2, 3, 4, 5],\n  \"repeatedPackedInt32\": [-1, 0, 1, 2, 3, 4, 5],\n  \"repeatedForeignMessage\": [{\n    \"c\": 0\n  }, {\n    \"c\": 1\n  }, {\n    \"c\": 2\n  }, {\n  }, {\n  }],\n  \"repeatedgroup\": [{\n    \"a\": 3\n  }, {\n    \"a\": 4\n  }],\n  \"repeatedBytes\": [\"YXNjaWk=\", \"dXRmOPCfkqk=\", \"YXNjaWk=\", \"dXRmOPCfkqk=\", \"\"],\n  \"repeatedString\": [\"hello\", \"world\", \"ascii\", \"utf8\ud83d\udca9\"]\n}";
        Assert.assertEquals((Object)desired, (Object)msg.toString());
    }

    @Test
    public void testMiniOutput() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        msg.getMutableOptionalImportMessage();
        msg.getMutableRepeatedForeignMessage().next();
        msg.getMutableRepeatedForeignMessage().next();
        msg.getMutableRepeatedBytes().next();
        msg.getMutableRepeatedDouble().addAll(new double[]{Double.NaN, Double.NEGATIVE_INFINITY, 0.0, -28.3});
        msg.getMutableRepeatedFloat().clear();
        Assert.assertEquals((Object)this.miniOutputResult, (Object)this.newJsonSink().setPreserveProtoFieldNames(false).setWriteEnumsAsInts(false).writeMessage((ProtoMessage)msg).toString());
    }

    @Test
    public void testTopLevelArrayOutput() throws IOException {
        RepeatedMessage array = RepeatedMessage.newEmptyInstance(TestAllTypes.getFactory());
        for (int i = 0; i < 5; ++i) {
            ((TestAllTypes)array.next()).setOptionalInt32(i);
        }
        String desired = "[{\"optionalInt32\":0},{\"optionalInt32\":1},{\"optionalInt32\":2},{\"optionalInt32\":3},{\"optionalInt32\":4}]";
        Assert.assertEquals((Object)desired, (Object)this.newJsonSink().writeRepeatedMessage(array).toString());
        RepeatedMessage actual = RepeatedMessage.newEmptyInstance(TestAllTypes.getFactory());
        JsonSource.newInstance((String)desired).readRepeatedMessage(actual);
        Assert.assertEquals((Object)array, (Object)actual);
    }

    @Test
    public void testMiniOutputProtoNames() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        msg.getMutableOptionalImportMessage();
        msg.getMutableRepeatedForeignMessage().next();
        msg.getMutableRepeatedForeignMessage().next();
        msg.getMutableRepeatedBytes().next();
        msg.getMutableRepeatedDouble().addAll(new double[]{Double.NaN, Double.NEGATIVE_INFINITY, 0.0, -28.3});
        msg.getMutableRepeatedFloat().clear();
        Assert.assertEquals((Object)this.miniOutputProtoNamesResult, (Object)this.newJsonSink().setPreserveProtoFieldNames(true).setWriteEnumsAsInts(false).writeMessage((ProtoMessage)msg).toString());
    }

    @Test
    public void testRepeatedFloat() throws IOException {
        RepeatedFloat floats = RepeatedFloat.newEmptyInstance();
        for (int i = -4; i < 4; ++i) {
            floats.add((float)i / 2.0f);
        }
        FieldName field = FieldName.forField((String)"data");
        String result = this.newJsonSink().beginObject().writeRepeatedFloat(field, floats).endObject().toString();
        Assert.assertEquals((Object)this.repeatedFloatResult, (Object)result);
    }

    public JsonSink newJsonSink() {
        return JsonSink.newInstance();
    }

    public JsonSink newJsonSinkPretty() {
        return JsonSink.newPrettyInstance();
    }
}

