/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import protos.test.quickbuf.ForeignMessage;
import protos.test.quickbuf.TestAllTypes;
import us.hebi.quickbuf.CompatibilityTest;
import us.hebi.quickbuf.JsonSink;
import us.hebi.quickbuf.JsonSource;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.RepeatedMessage;

public class JsonSourceTest {
    private final JsonSink minimized = JsonSink.newInstance();
    private final JsonSink pretty = JsonSink.newPrettyInstance();

    @Test
    public void testReadJsonSink() throws IOException {
        TestAllTypes expected = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        TestAllTypes actual = TestAllTypes.newInstance();
        String json = JsonSink.newInstance().setWriteEnumsAsInts(false).writeMessage((ProtoMessage)expected).toString();
        actual.clear().mergeFrom(this.newJsonSource(json));
        Assert.assertEquals((Object)expected, (Object)actual);
        json = JsonSink.newInstance().setWriteEnumsAsInts(true).writeMessage((ProtoMessage)expected).toString();
        actual.clear().mergeFrom(this.newJsonSource(json));
        Assert.assertEquals((Object)expected, (Object)actual);
        json = JsonSink.newInstance().setPreserveProtoFieldNames(true).writeMessage((ProtoMessage)expected).toString();
        actual.clear().mergeFrom(this.newJsonSource(json));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSkipping() throws Exception {
        TestAllTypes expected = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        String json = JsonSink.newInstance().setWriteEnumsAsInts(false).writeMessage((ProtoMessage)expected).toString();
        ForeignMessage wrongMsg = ForeignMessage.newInstance();
        wrongMsg.clear().mergeFrom(this.newJsonSource(json).setIgnoreUnknownFields(true));
        try {
            wrongMsg.mergeFrom(this.newJsonSource(json).setIgnoreUnknownFields(false));
            Assert.fail((String)"expected to fail on unknown fields");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Encountered unknown field: 'optionalDouble'", (Object)e.getMessage());
        }
    }

    @Test
    public void testManualInput() throws Exception {
        TestAllTypes msg = this.parseJson(CompatibilityTest.JSON_MANUAL_INPUT);
        Assert.assertEquals((Object)CompatibilityTest.JSON_MANUAL_INPUT, (Object)msg.toString());
    }

    @Test
    public void testEmptyInput() throws Exception {
        TestAllTypes msg = this.parseJson(CompatibilityTest.JSON_EMPTY);
        Assert.assertEquals((Object)CompatibilityTest.JSON_EMPTY, (Object)msg.toString());
        Assert.assertTrue((boolean)msg.isEmpty());
    }

    @Test
    public void testObjectsNullInput() throws Exception {
        TestAllTypes msg = this.parseJson("{\"optionalNestedMessage\":null,\"repeatedString\":null,\"optionalForeignMessage\":{},\"repeatedBytes\":null}");
        Assert.assertTrue((boolean)msg.hasOptionalForeignMessage());
        Assert.assertTrue((boolean)msg.getOptionalNestedMessage().isEmpty());
        Assert.assertFalse((boolean)msg.hasRepeatedString());
        Assert.assertEquals((long)0L, (long)msg.getRepeatedString().length());
        Assert.assertEquals((long)0L, (long)msg.getRepeatedBytes().length());
    }

    @Test
    public void testAllTypesNullInput() throws Exception {
        TestAllTypes msg = this.parseJson("{\n  \"optionalDouble\": null,\n  \"optionalFixed64\": null,\n  \"optionalSfixed64\": null,\n  \"optionalInt64\": null,\n  \"optionalUint64\": null,\n  \"optionalSint64\": null,\n  \"optionalFloat\": null,\n  \"optionalFixed32\": null,\n  \"optionalSfixed32\": null,\n  \"optionalInt32\": null,\n  \"optionalUint32\": null,\n  \"optionalSint32\": null,\n  \"optionalNestedEnum\": null,\n  \"optionalForeignEnum\": null,\n  \"optionalImportEnum\": null,\n  \"optionalBool\": null,\n  \"optionalNestedMessage\": null,\n  \"optionalForeignMessage\": null,\n  \"optionalImportMessage\": null,\n  \"optionalBytes\": null,\n  \"defaultBytes\": null,\n  \"optionalString\": null,\n  \"optionalCord\": null,\n  \"repeatedDouble\": null,\n  \"repeatedFloat\": null,\n  \"repeatedInt32\": null,\n  \"repeatedPackedInt32\": null,\n  \"repeatedForeignMessage\": null,\n  \"repeatedBytes\": null,\n  \"repeatedString\": null\n}");
        Assert.assertTrue((boolean)msg.isEmpty());
    }

    @Test
    public void testSpecialNumbers() throws Exception {
        TestAllTypes msg = this.parseJson("{\n  \"repeated_double\": [\n    \"NaN\",\n    \"-Infinity\",\n    0,\n    -28.3,\n    3E6,\n    -0,\n    17E-3,\n    Infinity\n  ],\n  \"repeated_int32\": [\n    \"0\",\n    \"2147483647\",\n    -2147483648,\n    0,\n    1,\n    2\n  ]\n}");
        Assert.assertArrayEquals((double[])new double[]{Double.NaN, Double.NEGATIVE_INFINITY, 0.0, -28.3, 3000000.0, 0.0, 0.017, Double.POSITIVE_INFINITY}, (double[])msg.getRepeatedDouble().toArray(), (double)0.0);
        Assert.assertArrayEquals((int[])new int[]{0, Integer.MAX_VALUE, Integer.MIN_VALUE, 0, 1, 2}, (int[])msg.getRepeatedInt32().toArray());
    }

    @Test
    public void testBadInputs() {
        this.testError(CompatibilityTest.JSON_NULL, "Expected '{' but got 'n'");
        this.testError(CompatibilityTest.JSON_LIST_EMPTY, "Expected '{' but got '['");
        this.testError(CompatibilityTest.JSON_REPEATED_BYTES_NULL_VALUE, "Expected non-null value for field 'repeatedBytes'");
        this.testError(CompatibilityTest.JSON_REPEATED_MSG_NULL_VALUE, "Expected '{' but got 'n' for field 'repeatedForeignMessage'");
        this.testError(CompatibilityTest.JSON_BAD_BOOLEAN, "Expected 'false' but got 'fals}' for field 'optionalBool'");
        this.testError(CompatibilityTest.JSON_UNKNOWN_FIELD, "Encountered unknown field: 'unknownField'");
        this.testError(CompatibilityTest.JSON_UNKNOWN_FIELD_NULL, "Encountered unknown field: 'unknownField'");
    }

    @Test
    public void testParseRootList() throws Exception {
        RepeatedMessage list = this.newJsonSource(CompatibilityTest.JSON_ROOT_LIST).parseRepeatedMessage(TestAllTypes.getFactory());
        Assert.assertEquals((long)3L, (long)list.length());
    }

    @Test
    public void testAllMessages() throws Exception {
        for (byte[] bytes : CompatibilityTest.getAllMessages()) {
            this.testRoundTrip(TestAllTypes.parseFrom(bytes));
        }
    }

    @Test
    public void testCombinedMessage() throws Exception {
        this.testRoundTrip(TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage()));
    }

    @Test
    public void testEnums() throws Exception {
        this.testRoundTrip(TestAllTypes.parseFrom(CompatibilityTest.optionalEnums()));
        this.testRoundTrip(TestAllTypes.parseFrom(CompatibilityTest.repeatedEnums()));
    }

    private void testRoundTrip(ProtoMessage<?> msg) throws Exception {
        this.testRoundTrip(msg, this.minimized);
        this.testRoundTrip(msg, this.pretty);
    }

    private void testRoundTrip(ProtoMessage<?> msg, JsonSink sink) throws Exception {
        msg.writeTo(sink.clear());
        ProtoMessage msg2 = msg.clone().clear().mergeFrom(this.newJsonSource(sink));
        Assert.assertEquals(msg, (Object)msg2);
    }

    protected TestAllTypes parseJson(String json) throws IOException {
        return TestAllTypes.parseFrom(this.newJsonSource(json));
    }

    protected JsonSource newJsonSource(String json) throws IOException {
        return JsonSource.newInstance((String)json);
    }

    protected JsonSource newJsonSource(JsonSink sink) throws IOException {
        return JsonSource.newInstance((RepeatedByte)sink.getBytes());
    }

    protected void testError(String input, String error) {
        block2: {
            try {
                this.parseJson(input);
                Assert.fail((String)("expected error: " + error));
            }
            catch (IOException ioe) {
                if (error == null) break block2;
                Assert.assertEquals((Object)error, (Object)ioe.getMessage());
            }
        }
    }
}

