/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import protos.test.quickbuf.TestAllTypes;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.RepeatedByte;

public class NumericTypesTest {
    private final Random rnd = new Random(0L);
    private static final int n = 2000;
    private final TestAllTypes msg = TestAllTypes.newInstance();
    private final RepeatedByte bytes = RepeatedByte.newEmptyInstance();
    private final ProtoSource source = ProtoSource.newInstance((RepeatedByte)this.bytes);
    private final ProtoSink sink = ProtoSink.newInstance((RepeatedByte)this.bytes);

    @Before
    public void reset() {
        this.rnd.setSeed(0L);
    }

    @Test
    public void testVarint32() throws IOException {
        this.testVarint32(0);
        this.testVarint32(1);
        this.testVarint32(-1);
        this.testVarint32(-128);
        this.testVarint32(Integer.MIN_VALUE);
        this.testVarint32(Integer.MAX_VALUE);
        this.testVarint32(128);
        this.testVarint32(16384);
        this.testVarint32(0x200000);
        this.testVarint32(0x10000000);
        this.testVarint32(-128);
        this.testVarint32(-16384);
        this.testVarint32(-2097152);
        this.testVarint32(-268435456);
        for (int i = 1; i < 2000; ++i) {
            this.testVarint32(this.rnd.nextInt() % (int)Math.pow(2000.0, 3.0));
        }
    }

    private void testVarint32(int value) throws IOException {
        NumericTypesTest.assertEquals(value, this.encodeAndDecode(this.msg.setOptionalInt32(value)).getOptionalInt32());
    }

    @Test
    public void testVarint64() throws IOException {
        this.testVarint64(0L);
        this.testVarint64(1L);
        this.testVarint64(-1L);
        this.testVarint64(-128L);
        this.testVarint64(Long.MIN_VALUE);
        this.testVarint64(Long.MAX_VALUE);
        this.testVarint64(128L);
        this.testVarint64(16384L);
        this.testVarint64(0x200000L);
        this.testVarint64(0x10000000L);
        this.testVarint64(0x800000000L);
        this.testVarint64(0x40000000000L);
        this.testVarint64(0x2000000000000L);
        this.testVarint64(-128L);
        this.testVarint64(-16384L);
        this.testVarint64(-2097152L);
        this.testVarint64(-268435456L);
        this.testVarint64(-34359738368L);
        this.testVarint64(-4398046511104L);
        this.testVarint64(-562949953421312L);
        this.testVarint64(-72057594037927936L);
        this.testVarint64(Long.MIN_VALUE);
        for (int i = 1; i < 2000; ++i) {
            this.testVarint64(this.rnd.nextLong() % (long)Math.pow(2000.0, 6.0));
        }
    }

    private void testVarint64(long value) throws IOException {
        NumericTypesTest.assertEquals(value, this.encodeAndDecode(this.msg.setOptionalInt64(value)).getOptionalInt64());
    }

    @Test
    public void testInt32() throws IOException {
        for (int i = 0; i < 32; ++i) {
            this.testInt32(1 << i);
            this.testInt32(~(1 << i));
            this.testInt32(-1 << i);
            this.testInt32(1 << i | Integer.MIN_VALUE);
            this.testInt32(-1 << i | Integer.MIN_VALUE);
            this.testInt32(-(1 << i));
        }
    }

    private void testInt32(int value) throws IOException {
        this.sink.reset().writeInt32NoTag(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readInt32());
    }

    @Test
    public void testInt64() throws IOException {
        for (int i = 0; i < 64; ++i) {
            this.testInt64(1L << i);
            this.testInt64(1L << i ^ 0xFFFFFFFFFFFFFFFFL);
            this.testInt64(-1L << i);
            this.testInt64(1L << i | Long.MIN_VALUE);
            this.testInt64(-1L << i | Long.MIN_VALUE);
            this.testInt64(-(1L << i));
        }
    }

    private void testInt64(long value) throws IOException {
        this.sink.reset().writeInt64NoTag(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readInt64());
    }

    @Test
    public void testExtendedInt32() throws IOException {
        for (int i = 0; i < 32; ++i) {
            this.testExtendedInt32(1 << i);
            this.testExtendedInt32(~(1 << i));
            this.testExtendedInt32(-1 << i);
            this.testExtendedInt32(1 << i | Integer.MIN_VALUE);
            this.testExtendedInt32(-1 << i | Integer.MIN_VALUE);
            this.testExtendedInt32(-(1 << i));
        }
    }

    private void testExtendedInt32(int value) throws IOException {
        this.sink.reset().writeNegativeVarint32(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readRawVarint32());
        NumericTypesTest.assertEquals(value, (int)this.source.setInput(this.bytes).readRawVarint64SlowPath());
    }

    @Test
    public void testExtendedInt64() throws IOException {
        for (int i = 0; i < 64; ++i) {
            this.testExtendedInt64(1L << i);
            this.testExtendedInt64(1L << i ^ 0xFFFFFFFFFFFFFFFFL);
            this.testExtendedInt64(-1L << i);
            this.testExtendedInt64(1L << i | Long.MIN_VALUE);
            this.testExtendedInt64(-1L << i | Long.MIN_VALUE);
            this.testExtendedInt64(-(1L << i));
        }
    }

    private void testExtendedInt64(long value) throws IOException {
        this.sink.reset().writeNegativeVarint64(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readRawVarint64SlowPath());
    }

    @Test
    public void testExtendedInt64Error() throws IOException {
        for (int i = 0; i < 63; ++i) {
            this.testExtendedInt64Error(1L << i);
            this.testExtendedInt64Error(-(1L << i) ^ Long.MIN_VALUE);
        }
        int value = 17;
        this.sink.reset().writeRawLittleEndian32(0x808080 | value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readRawVarint64SlowPath());
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readRawVarint64());
    }

    private void testExtendedInt64Error(long value) throws IOException {
        this.sink.reset().writeNegativeVarint64(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readRawVarint64SlowPath());
        Assert.assertNotEquals((long)value, (long)this.source.setInput(this.bytes).readRawVarint64());
    }

    @Test
    public void testUInt32() throws IOException {
        for (int i = 0; i < 32; ++i) {
            this.testUInt32(1 << i);
            this.testUInt32(~(1 << i));
            this.testUInt32(-1 << i);
            this.testUInt32(1 << i | Integer.MIN_VALUE);
            this.testUInt32(-1 << i | Integer.MIN_VALUE);
            this.testUInt32(-(1 << i));
        }
    }

    private void testUInt32(int value) throws IOException {
        this.sink.reset().writeUInt32NoTag(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readUInt32());
    }

    @Test
    public void testUInt64() throws IOException {
        for (int i = 0; i < 64; ++i) {
            this.testUInt64(1L << i);
            this.testUInt64(1L << i ^ 0xFFFFFFFFFFFFFFFFL);
            this.testUInt64(-1L << i);
            this.testUInt64(1L << i | Long.MIN_VALUE);
            this.testUInt64(-1L << i | Long.MIN_VALUE);
            this.testUInt64(-(1L << i));
        }
    }

    private void testUInt64(long value) throws IOException {
        this.sink.reset().writeUInt64NoTag(value);
        NumericTypesTest.assertEquals(value, this.source.setInput(this.bytes).readUInt64());
    }

    @Test
    public void testFixed32() throws IOException {
        this.testFixed32(0);
        this.testFixed32(1);
        this.testFixed32(-1);
        this.testFixed32(-128);
        this.testFixed32(Integer.MIN_VALUE);
        this.testFixed32(Integer.MAX_VALUE);
        for (int i = 1; i < 2000; ++i) {
            this.testFixed32(this.rnd.nextInt() % (int)Math.pow(2000.0, 3.0));
        }
    }

    private void testFixed32(int value) throws IOException {
        NumericTypesTest.assertEquals(value, this.encodeAndDecode(this.msg.setOptionalFixed32(value)).getOptionalFixed32());
    }

    @Test
    public void testFixed64() throws IOException {
        this.testFixed64(0L);
        this.testFixed64(1L);
        this.testFixed64(-1L);
        this.testFixed64(-128L);
        this.testFixed64(Long.MIN_VALUE);
        this.testFixed64(Long.MAX_VALUE);
        for (int i = 1; i < 2000; ++i) {
            this.testFixed64(this.rnd.nextLong() % (long)Math.pow(2000.0, 6.0));
        }
    }

    private void testFixed64(long value) throws IOException {
        NumericTypesTest.assertEquals(value, this.encodeAndDecode(this.msg.setOptionalFixed64(value)).getOptionalFixed64());
    }

    @Test
    public void testFloat() throws IOException {
        this.testFloat(Float.POSITIVE_INFINITY);
        this.testFloat(Float.NEGATIVE_INFINITY);
        this.testFloat(Float.MAX_VALUE);
        this.testFloat(Float.MIN_VALUE);
        this.testFloat(Float.NaN);
        for (int i = 1; i < 2000; ++i) {
            this.testFloat(this.rnd.nextFloat());
        }
    }

    private void testFloat(float value) throws IOException {
        NumericTypesTest.assertEquals(Float.floatToIntBits(value), Float.floatToIntBits(this.encodeAndDecode(this.msg.setOptionalFloat(value)).getOptionalFloat()));
    }

    @Test
    public void testDouble() throws IOException {
        this.testDouble(Double.POSITIVE_INFINITY);
        this.testDouble(Double.NEGATIVE_INFINITY);
        this.testDouble(Double.MAX_VALUE);
        this.testDouble(Double.MIN_VALUE);
        this.testDouble(Double.NaN);
        for (int i = 1; i < 2000; ++i) {
            this.testDouble(this.rnd.nextDouble());
        }
    }

    private void testDouble(double value) throws IOException {
        NumericTypesTest.assertEquals(Double.doubleToLongBits(value), Double.doubleToLongBits(this.encodeAndDecode(this.msg.setOptionalDouble(value)).getOptionalDouble()));
    }

    private static void assertEqual(int expected, int actual) {
        if (expected != actual) {
            Assert.fail((String)("Values are not equal:\nExpected: " + Integer.toBinaryString(expected) + "\nActual:   " + Integer.toBinaryString(actual)));
        }
    }

    private static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            Assert.fail((String)("Values are not equal:\nExpected: " + Long.toBinaryString(expected) + "\nActual:   " + Long.toBinaryString(actual)));
        }
    }

    private TestAllTypes encodeAndDecode(TestAllTypes msg) throws IOException {
        this.bytes.clear();
        msg.writeTo(this.sink.reset());
        msg.clear().mergeFrom(this.source.setInput(this.bytes));
        return msg;
    }
}

