/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import protos.test.quickbuf.RepeatedPackables;
import protos.test.quickbuf.TestAllTypes;
import protos.test.quickbuf.UnittestRequired;
import us.hebi.quickbuf.CompatibilityTest;
import us.hebi.quickbuf.InvalidProtocolBufferException;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.UninitializedMessageException;

public class ProtoFailTests {
    static final int n = 10;

    @Test(expected=UninitializedMessageException.class)
    public void testMissingRequiredField() {
        try {
            UnittestRequired.SimpleMessage.newInstance().toByteArray();
        }
        catch (UninitializedMessageException ex) {
            Assert.assertEquals((long)1L, (long)ex.getMissingFields().size());
            throw ex;
        }
    }

    @Test(expected=UninitializedMessageException.class)
    public void testMissingRequiredFieldAll() {
        try {
            UnittestRequired.TestAllTypesRequired.newInstance().setRequiredNestedMessage(UnittestRequired.SimpleMessage.newInstance()).toByteArray();
        }
        catch (UninitializedMessageException ex) {
            List missing = ex.getMissingFields();
            Assert.assertEquals((long)17L, (long)missing.size());
            Assert.assertEquals((Object)missing, Arrays.asList("required_double", "required_fixed64", "required_sfixed64", "required_int64", "required_uint64", "required_sint64", "required_float", "required_fixed32", "required_sfixed32", "required_int32", "required_uint32", "required_sint32", "required_nested_enum", "required_bool", "required_nested_message.required_field", "required_bytes", "required_string"));
            Assert.assertTrue((boolean)ex.getMessage().contains("required_float"));
            Assert.assertTrue((boolean)ex.getMessage().contains("required_nested_message.required_field"));
            throw ex;
        }
    }

    @Test(expected=UninitializedMessageException.class)
    public void testMissingRequiredNestedField() {
        try {
            UnittestRequired.NestedRequiredMessage.newInstance().toByteArray();
        }
        catch (UninitializedMessageException ex) {
            Assert.fail((String)"root message has no required fields");
        }
        try {
            UnittestRequired.NestedRequiredMessage.newInstance().setOptionalSimpleMessage(UnittestRequired.SimpleMessage.newInstance()).toByteArray();
        }
        catch (UninitializedMessageException ex) {
            List missing = ex.getMissingFields();
            Assert.assertEquals((long)1L, (long)missing.size());
            Assert.assertEquals((Object)missing, Collections.singletonList("optional_simple_message.required_field"));
            Assert.assertTrue((boolean)ex.getMessage().contains("optional_simple_message.required_field"));
            throw ex;
        }
    }

    @Test(expected=InvalidProtocolBufferException.class)
    public void testCheckInitializedRequired() throws InvalidProtocolBufferException {
        UnittestRequired.TestAllTypesRequired.newInstance().checkInitialized();
    }

    @Test
    public void testCheckInitializedOptional() throws InvalidProtocolBufferException {
        TestAllTypes.newInstance().checkInitialized();
    }

    @Test(expected=UninitializedMessageException.class)
    public void testParseFromUninitialized() throws Throwable {
        try {
            UnittestRequired.SimpleMessage.parseFrom(new byte[0]);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.getCause();
        }
    }

    @Test
    public void testOutOfSpaceVarint32() throws IOException {
        this.writeToTruncated(TestAllTypes.newInstance().setId(Integer.MIN_VALUE));
    }

    @Test
    public void testOutOfSpaceVarint64() throws IOException {
        this.writeToTruncated(TestAllTypes.newInstance().setDefaultInt64(Long.MIN_VALUE));
    }

    @Test
    public void testOutOfSpaceFixed32() throws IOException {
        this.writeToTruncated(TestAllTypes.newInstance().setDefaultFixed32(Integer.MAX_VALUE));
    }

    @Test
    public void testOutOfSpaceFixed64() throws IOException {
        this.writeToTruncated(TestAllTypes.newInstance().setDefaultFixed64(Long.MAX_VALUE));
    }

    @Test
    public void testOutOfSpaceString() throws IOException {
        this.writeToTruncated(TestAllTypes.newInstance().setOptionalString("this should fail"));
    }

    @Test
    public void testOutOfSpaceBytes() throws IOException {
        this.writeToTruncated(TestAllTypes.newInstance().addAllDefaultBytes(new byte[213]));
    }

    @Test
    public void testOutOfSpacePackedBoolean() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllBools(new boolean[213]));
    }

    @Test
    public void testOutOfSpacePackedDouble() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllDoubles(new double[213]));
    }

    @Test
    public void testOutOfSpacePackedFloat() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllFloats(new float[213]));
    }

    @Test
    public void testOutOfSpacePackedVarint32() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllInt32S(new int[213]));
    }

    @Test
    public void testOutOfSpacePackedFixed32() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllFixed32S(new int[213]));
    }

    @Test
    public void testOutOfSpacePackedVarint64() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllInt64S(new long[213]));
    }

    @Test
    public void testOutOfSpacePackedFixed64() throws IOException {
        this.writeToTruncated(RepeatedPackables.Packed.newInstance().addAllFixed64S(new long[213]));
    }

    @Test
    public void testOutOfSpaceMessage() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableOptionalNestedMessage().setBb(1);
        this.writeToTruncated(msg);
    }

    @Test
    public void testOutOfSpaceGroup() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableOptionalGroup().setA(2);
        this.writeToTruncated(msg);
    }

    private void writeToTruncated(ProtoMessage<?> msg) throws IOException {
        byte[] buffer = new byte[msg.getSerializedSize() - 1];
        try {
            msg.writeTo(ProtoSink.newArraySink().setOutput(buffer));
            Assert.fail((String)"ArraySink");
        }
        catch (ProtoSink.OutOfSpaceException outOfSpaceException) {
            // empty catch block
        }
        try {
            msg.writeTo(ProtoSink.newDirectSink().setOutput(buffer));
            Assert.fail((String)"DirectSink");
        }
        catch (ProtoSink.OutOfSpaceException outOfSpaceException) {
            // empty catch block
        }
        try {
            msg.writeTo(ProtoSink.newBufferSink().setOutput(ByteBuffer.wrap(buffer)));
            Assert.fail((String)"BufferSink");
        }
        catch (ProtoSink.OutOfSpaceException outOfSpaceException) {
            // empty catch block
        }
    }

    @Test
    public void testMalformedVarint32() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        RepeatedByte bytes = msg.getUnknownBytes();
        Arrays.fill(bytes.setLength(12).array(), (byte)-5);
        byte[] array = ((RepeatedByte)msg.getUnknownBytes().reserve(20)).array();
        array[0] = 8;
        try {
            bytes.setLength((int)13).array[12] = 0;
            TestAllTypes.parseFrom(msg.toByteArray());
            Assert.fail();
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("malformed"));
        }
        try {
            bytes.setLength((int)12).array[11] = 0;
            TestAllTypes.parseFrom(msg.toByteArray());
            Assert.fail();
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("malformed"));
        }
        bytes.setLength((int)11).array[10] = 0;
        TestAllTypes.parseFrom(msg.toByteArray());
    }

    @Test
    public void testMalformedVarint64() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        RepeatedByte bytes = msg.getUnknownBytes();
        Arrays.fill(bytes.setLength(12).array(), (byte)-5);
        byte[] array = ((RepeatedByte)msg.getUnknownBytes().reserve(20)).array();
        array[0] = 16;
        try {
            bytes.setLength((int)13).array[12] = 0;
            TestAllTypes.parseFrom(msg.toByteArray());
            Assert.fail();
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("malformed"));
        }
        try {
            bytes.setLength((int)12).array[11] = 0;
            TestAllTypes.parseFrom(msg.toByteArray());
            Assert.fail();
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("malformed"));
        }
        bytes.setLength((int)11).array[10] = 0;
        TestAllTypes.parseFrom(msg.toByteArray());
    }

    @Test
    public void testTruncatedVarint32() throws IOException {
        this.readFromTruncated(TestAllTypes.newInstance().setId(Integer.MIN_VALUE));
    }

    @Test
    public void testTruncatedVarint64() throws IOException {
        this.readFromTruncated(TestAllTypes.newInstance().setDefaultInt64(Long.MIN_VALUE));
    }

    @Test
    public void testTruncatedFixed32() throws IOException {
        this.readFromTruncated(TestAllTypes.newInstance().setDefaultFixed32(Integer.MAX_VALUE));
    }

    @Test
    public void testTruncatedFixed64() throws IOException {
        this.readFromTruncated(TestAllTypes.newInstance().setDefaultFixed64(Long.MAX_VALUE));
    }

    @Test
    public void testTruncatedString() throws IOException {
        this.readFromTruncated(TestAllTypes.newInstance().setOptionalString("this should fail"));
    }

    @Test
    public void testTruncatedBytes() throws IOException {
        this.readFromTruncated(TestAllTypes.newInstance().addAllDefaultBytes(new byte[213]));
    }

    @Test
    public void testTruncatedPackedBoolean() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllBools(new boolean[213]));
    }

    @Test
    public void testTruncatedPackedDouble() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllDoubles(new double[213]));
    }

    @Test
    public void testTruncatedPackedFloat() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllFloats(new float[213]));
    }

    @Test
    public void testTruncatedPackedVarint32() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllInt32S(new int[213]));
    }

    @Test
    public void testTruncatedPackedFixed32() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllFixed32S(new int[213]));
    }

    @Test
    public void testTruncatedPackedVarint64() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllInt64S(new long[213]));
    }

    @Test
    public void testTruncatedPackedFixed64() throws IOException {
        this.readFromTruncated(RepeatedPackables.Packed.newInstance().addAllFixed64S(new long[213]));
    }

    @Test
    public void testTruncatedMessage() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableOptionalNestedMessage().setBb(1);
        this.readFromTruncated(msg);
    }

    @Test
    public void testTruncatedGroup() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        msg.getMutableOptionalGroup().setA(2);
        this.readFromTruncated(msg);
    }

    private void readFromTruncated(ProtoMessage<?> msg) throws IOException {
        byte[] data = msg.toByteArray();
        try {
            msg.clear().mergeFrom(ProtoSource.newArraySource().setInput(data, 0L, data.length - 1));
            Assert.fail((String)"ArraySource");
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        try {
            msg.clear().mergeFrom(ProtoSource.newDirectSource().setInput(data, 0L, data.length - 1));
            Assert.fail((String)"DirectSource");
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        try {
            msg.clear().mergeFrom(ProtoSource.newStreamSource().setInput((InputStream)new ByteArrayInputStream(data, 0, data.length - 1)));
            Assert.fail((String)"StreamSource");
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        try {
            msg.clear().mergeFrom(ProtoSource.newBufferSource().setInput(ByteBuffer.wrap(data, 0, data.length - 1)));
            Assert.fail((String)"BufferSource");
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadIntoTruncatedDestinationArray() throws IOException {
        ProtoSource.newArraySource().setInput(new byte[10]).readRawBytes(new byte[0], 0, 10);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadIntoTruncatedDestinationDirect() throws IOException {
        ProtoSource.newDirectSource().setInput(new byte[10]).readRawBytes(new byte[0], 0, 10);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadIntoTruncatedDestinationStream() throws IOException {
        ProtoSource.newInstance((InputStream)new ByteArrayInputStream(new byte[10])).readRawBytes(new byte[0], 0, 10);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadIntoTruncatedDestinationBuffer() throws IOException {
        ProtoSource.newInstance((ByteBuffer)ByteBuffer.wrap(new byte[10])).readRawBytes(new byte[0], 0, 10);
    }

    @Test(expected=NullPointerException.class)
    public void testReadIntoNullDestination() throws IOException {
        ProtoSource.newArraySource().setInput(new byte[10]).readRawBytes(null, 0, 10);
    }

    @Test(expected=NullPointerException.class)
    public void testReadIntoNullDestinationDirect() throws IOException {
        ProtoSource.newDirectSource().setInput(new byte[10]).readRawBytes(null, 0, 10);
    }

    @Test(expected=NullPointerException.class)
    public void testReadIntoNullDestinationStream() throws IOException {
        ProtoSource.newInstance((InputStream)new ByteArrayInputStream(new byte[10])).readRawBytes(null, 0, 10);
    }

    @Test(expected=NullPointerException.class)
    public void testReadIntoNullDestinationBuffer() throws IOException {
        ProtoSource.newInstance((ByteBuffer)ByteBuffer.wrap(new byte[10])).readRawBytes(null, 0, 10);
    }

    @Test
    public void testStreamLimitsExceeded() throws IOException {
        byte[] bytes = CompatibilityTest.optionalPrimitives();
        ProtoSource source = ProtoSource.newInstance((InputStream)new ByteArrayInputStream(bytes));
        try {
            source.setSizeLimit(bytes.length - 1);
            TestAllTypes.parseFrom(source);
            Assert.fail();
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("size limit"));
        }
        Assert.assertEquals((long)(bytes.length - 1), (long)source.getTotalBytesRead());
        source.resetSizeCounter();
        Assert.assertEquals((long)0L, (long)source.getTotalBytesRead());
        try {
            source.setSizeLimit(bytes.length);
            source.setInput((InputStream)new ByteArrayInputStream(bytes));
            source.pushLimit(bytes.length - 20);
            TestAllTypes.parseFrom(source);
            Assert.fail();
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("input ended unexpectedly"));
        }
    }
}

