/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import com.google.quickbuf.Struct;
import com.google.quickbuf.Value;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import protos.test.quickbuf.ForeignEnum;
import protos.test.quickbuf.ForeignMessage;
import protos.test.quickbuf.LazyTypes;
import protos.test.quickbuf.RepeatedPackables;
import protos.test.quickbuf.TestAllTypes;
import protos.test.quickbuf.TestEnumsMessage;
import protos.test.quickbuf.TestExtremeDefaultValues;
import protos.test.quickbuf.UnittestFieldOrder;
import protos.test.quickbuf.UnittestRequired;
import protos.test.quickbuf.external.ImportEnum;
import us.hebi.quickbuf.CompatibilityTest;
import us.hebi.quickbuf.JsonSource;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.RepeatedObject;
import us.hebi.quickbuf.UninitializedMessageException;
import us.hebi.quickbuf.Utf8Decoder;

public class ProtoTests {
    @Test
    public void testOutputStreamSink() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo(ProtoSink.newInstance((OutputStream)baos));
        byte[] expected = msg.toByteArray();
        byte[] actual = baos.toByteArray();
        Assert.assertEquals((Object)msg, (Object)TestAllTypes.parseFrom(actual));
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        Assert.assertArrayEquals((byte[])msg.toByteArray(), (byte[])baos.toByteArray());
    }

    @Test
    public void testInputStreamSource() throws IOException {
        byte[] bytes = CompatibilityTest.getCombinedMessage();
        TestAllTypes actual = TestAllTypes.parseFrom(ProtoSource.newInstance((InputStream)new ByteArrayInputStream(bytes)));
        Assert.assertEquals((Object)TestAllTypes.parseFrom(bytes), (Object)actual);
    }

    @Test
    public void testByteBufferSource() throws IOException {
        byte[] bytes = CompatibilityTest.getCombinedMessage();
        TestAllTypes actual = TestAllTypes.parseFrom(ProtoSource.newInstance((ByteBuffer)ByteBuffer.wrap(bytes)));
        Assert.assertEquals((Object)TestAllTypes.parseFrom(bytes), (Object)actual);
    }

    @Test
    public void testByteBufferSink() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        ByteBuffer buffer = ByteBuffer.allocate(msg.getSerializedSize());
        msg.writeTo(ProtoSink.newInstance((ByteBuffer)buffer));
        byte[] expected = msg.toByteArray();
        byte[] actual = buffer.array();
        Assert.assertEquals((Object)msg, (Object)TestAllTypes.parseFrom(actual));
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testRepeatedByteSerialization() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        RepeatedByte bytes = RepeatedByte.newEmptyInstance();
        msg.writeTo(ProtoSink.newInstance((RepeatedByte)bytes));
        Assert.assertEquals((long)msg.getSerializedSize(), (long)bytes.length);
        Assert.assertEquals((Object)msg, (Object)TestAllTypes.parseFrom(ProtoSource.newInstance((RepeatedByte)bytes)));
    }

    @Test
    public void testSourceWithOffset() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        int offset = 31;
        int size = msg.getSerializedSize();
        byte[] bytes = new byte[offset + size];
        msg.writeTo(ProtoSink.newInstance((byte[])bytes, (int)offset, (int)size));
        Assert.assertEquals((Object)msg, (Object)TestAllTypes.newInstance().mergeFrom(ProtoSource.newInstance((byte[])bytes, (int)offset, (int)size)));
    }

    @Test
    public void testDefaults() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)msg.getDefaultBool());
            Assert.assertEquals((long)41L, (long)msg.getDefaultInt32());
            Assert.assertEquals((long)42L, (long)msg.getDefaultInt64());
            Assert.assertEquals((long)43L, (long)msg.getDefaultUint32());
            Assert.assertEquals((long)44L, (long)msg.getDefaultUint64());
            Assert.assertEquals((long)-45L, (long)msg.getDefaultSint32());
            Assert.assertEquals((long)46L, (long)msg.getDefaultSint64());
            Assert.assertEquals((long)47L, (long)msg.getDefaultFixed32());
            Assert.assertEquals((long)48L, (long)msg.getDefaultFixed64());
            Assert.assertEquals((long)49L, (long)msg.getDefaultSfixed32());
            Assert.assertEquals((long)-50L, (long)msg.getDefaultSfixed64());
            Assert.assertEquals((float)51.5f, (float)msg.getDefaultFloat(), (float)0.0f);
            Assert.assertEquals((double)52000.0, (double)msg.getDefaultDouble(), (double)0.0);
            Assert.assertEquals((Object)"hello", (Object)msg.getDefaultString());
            Assert.assertEquals((Object)"world", (Object)new String(msg.getDefaultBytes().toArray(), ProtoUtil.Charsets.UTF_8));
            Assert.assertEquals((Object)"d\u00fcnya", (Object)msg.getDefaultStringNonascii());
            Assert.assertEquals((Object)"d\u00fcnyab", (Object)new String(msg.getDefaultBytesNonascii().toArray(), ProtoUtil.Charsets.UTF_8));
            Assert.assertEquals((Object)((Object)TestAllTypes.NestedEnum.BAR), (Object)((Object)msg.getDefaultNestedEnum()));
            Assert.assertEquals((Object)((Object)ForeignEnum.FOREIGN_BAR), (Object)((Object)msg.getDefaultForeignEnum()));
            Assert.assertEquals((Object)((Object)ImportEnum.IMPORT_BAR), (Object)((Object)msg.getDefaultImportEnum()));
            Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)msg.getDefaultFloatInf(), (float)0.0f);
            Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)msg.getDefaultFloatNegInf(), (float)0.0f);
            Assert.assertEquals((float)Float.NaN, (float)msg.getDefaultFloatNan(), (float)0.0f);
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)msg.getDefaultDoubleInf(), (double)0.0);
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)msg.getDefaultDoubleNegInf(), (double)0.0);
            Assert.assertEquals((double)Double.NaN, (double)msg.getDefaultDoubleNan(), (double)0.0);
            byte[] result = msg.toByteArray();
            int msgSerializedSize = msg.getSerializedSize();
            Assert.assertEquals((long)0L, (long)msgSerializedSize);
            Assert.assertEquals((long)result.length, (long)msgSerializedSize);
            msg.clear();
        }
    }

    @Test
    public void testExtremeDefaults() {
        TestExtremeDefaultValues msg = TestExtremeDefaultValues.newInstance();
        Assert.assertEquals((Object)"[0, 1, 7, 8, 12, 10, 13, 9, 11, 92, 39, 34, -2]", (Object)msg.getEscapedBytes().toString());
        Assert.assertEquals((long)-1L, (long)msg.getLargeUint32());
        Assert.assertEquals((long)-1L, (long)msg.getLargeUint64());
        Assert.assertEquals((long)2123456789L, (long)msg.getLargeFixed32());
        Assert.assertEquals((long)-8323287284586094827L, (long)msg.getLargeFixed64());
        Assert.assertEquals((long)-2147483647L, (long)msg.getSmallInt32());
        Assert.assertEquals((long)-9223372036854775807L, (long)msg.getSmallInt64());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)msg.getReallySmallInt32());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)msg.getReallySmallInt64());
        Assert.assertEquals((Object)new String("\u00e1\u0088\u00b4".getBytes(ProtoUtil.Charsets.ISO_8859_1), ProtoUtil.Charsets.UTF_8), (Object)msg.getUtf8String());
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)0.0f, (float)msg.getZeroFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)1.0f, (float)msg.getOneFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)1.5f, (float)msg.getSmallFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)-1.0f, (float)msg.getNegativeOneFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)-1.5f, (float)msg.getNegativeFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)2.0E8f, (float)msg.getLargeFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)-8.0E-28f, (float)msg.getSmallNegativeFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((double)Double.POSITIVE_INFINITY, (double)msg.getInfDouble()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((double)Double.NEGATIVE_INFINITY, (double)msg.getNegInfDouble()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((double)Double.NaN, (double)msg.getNanDouble()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)Float.POSITIVE_INFINITY, (float)msg.getInfFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)Float.NEGATIVE_INFINITY, (float)msg.getNegInfFloat()));
        Assert.assertTrue((boolean)ProtoUtil.isEqual((float)Float.NaN, (float)msg.getNanFloat()));
        Assert.assertEquals((Object)"? ? ?? ?? ??? ??/ ??-", (Object)msg.getCppTrigraph());
        Assert.assertEquals((Object)"hel\u0000lo", (Object)msg.getStringWithZero());
        Assert.assertEquals((Object)"[119, 111, 114, 0, 108, 100]", (Object)msg.getBytesWithZero().toString());
        Assert.assertEquals((Object)"ab\u0000c", (Object)msg.getStringPieceWithZero());
        Assert.assertEquals((Object)"12\u00003", (Object)msg.getCordWithZero());
        Assert.assertEquals((Object)"${unknown}", (Object)msg.getReplacementString());
    }

    @Test
    public void testOptionalPrimitives() throws IOException {
        TestAllTypes emptyMsg = TestAllTypes.newInstance();
        Assert.assertFalse((boolean)emptyMsg.hasOptionalBool());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalDouble());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalFloat());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalFixed32());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalFixed64());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalSfixed32());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalSfixed64());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalSint32());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalSint64());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalInt32());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalInt64());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalUint32());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalUint64());
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.optionalPrimitives());
        Assert.assertNotEquals((Object)msg, (Object)emptyMsg);
        Assert.assertTrue((boolean)msg.hasOptionalBool());
        Assert.assertTrue((boolean)msg.hasOptionalDouble());
        Assert.assertTrue((boolean)msg.hasOptionalFloat());
        Assert.assertTrue((boolean)msg.hasOptionalFixed32());
        Assert.assertTrue((boolean)msg.hasOptionalFixed64());
        Assert.assertTrue((boolean)msg.hasOptionalSfixed32());
        Assert.assertTrue((boolean)msg.hasOptionalSfixed64());
        Assert.assertTrue((boolean)msg.hasOptionalSint32());
        Assert.assertTrue((boolean)msg.hasOptionalSint64());
        Assert.assertTrue((boolean)msg.hasOptionalInt32());
        Assert.assertTrue((boolean)msg.hasOptionalInt64());
        Assert.assertTrue((boolean)msg.hasOptionalUint32());
        Assert.assertTrue((boolean)msg.hasOptionalUint64());
        Assert.assertTrue((boolean)msg.getOptionalBool());
        Assert.assertEquals((double)100.0, (double)msg.getOptionalDouble(), (double)0.0);
        Assert.assertEquals((float)101.0f, (float)msg.getOptionalFloat(), (float)0.0f);
        Assert.assertEquals((long)102L, (long)msg.getOptionalFixed32());
        Assert.assertEquals((long)103L, (long)msg.getOptionalFixed64());
        Assert.assertEquals((long)104L, (long)msg.getOptionalSfixed32());
        Assert.assertEquals((long)105L, (long)msg.getOptionalSfixed64());
        Assert.assertEquals((long)106L, (long)msg.getOptionalSint32());
        Assert.assertEquals((long)107L, (long)msg.getOptionalSint64());
        Assert.assertEquals((long)108L, (long)msg.getOptionalInt32());
        Assert.assertEquals((long)109L, (long)msg.getOptionalInt64());
        Assert.assertEquals((long)110L, (long)msg.getOptionalUint32());
        Assert.assertEquals((long)111L, (long)msg.getOptionalUint64());
        TestAllTypes manualMsg = TestAllTypes.newInstance().setOptionalBool(true).setOptionalDouble(100.0).setOptionalFloat(101.0f).setOptionalFixed32(102).setOptionalFixed64(103L).setOptionalSfixed32(104).setOptionalSfixed64(105L).setOptionalSint32(106).setOptionalSint64(107L).setOptionalInt32(108).setOptionalInt64(109L).setOptionalUint32(110).setOptionalUint64(111L);
        Assert.assertEquals((Object)msg, (Object)manualMsg);
        TestAllTypes msg3 = TestAllTypes.parseFrom(manualMsg.toByteArray());
        Assert.assertEquals((Object)msg, (Object)msg3);
        TestAllTypes msg4 = msg3.clone();
        Assert.assertEquals((Object)msg3.clear(), (Object)msg4.clearQuick());
        Assert.assertArrayEquals((byte[])msg3.toByteArray(), (byte[])msg4.toByteArray());
    }

    @Test
    public void testUnsignedRangeOverflow() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance().setOptionalUint32(-1).setOptionalUint64(-1L).addAllRepeatedUint32(0, 12345, 12345, 12345, -1, 0, 1, -1, -1, 1).addAllRepeatedUint64(0L, 12345L, 12345L, 12345L, -1L, 0L, 1L, -1L, -1L, 1L);
        TestAllTypes result = TestAllTypes.parseFrom(msg.toByteArray());
        Assert.assertEquals((Object)msg, (Object)result);
    }

    @Test
    public void testRepeatedPrimitives() throws IOException {
        RepeatedPackables.Packed emptyMsg = RepeatedPackables.Packed.newInstance();
        Assert.assertFalse((boolean)emptyMsg.hasBools());
        Assert.assertFalse((boolean)emptyMsg.hasDoubles());
        Assert.assertFalse((boolean)emptyMsg.hasFloats());
        Assert.assertFalse((boolean)emptyMsg.hasFixed32S());
        Assert.assertFalse((boolean)emptyMsg.hasFixed64S());
        Assert.assertFalse((boolean)emptyMsg.hasSfixed32S());
        Assert.assertFalse((boolean)emptyMsg.hasSfixed64S());
        Assert.assertFalse((boolean)emptyMsg.hasSint32S());
        Assert.assertFalse((boolean)emptyMsg.hasSint64S());
        Assert.assertFalse((boolean)emptyMsg.hasInt32S());
        Assert.assertFalse((boolean)emptyMsg.hasInt64S());
        Assert.assertFalse((boolean)emptyMsg.hasUint32S());
        Assert.assertFalse((boolean)emptyMsg.hasUint64S());
        RepeatedPackables.Packed msg = RepeatedPackables.Packed.parseFrom(CompatibilityTest.repeatedPackablesNonPacked());
        Assert.assertNotEquals((Object)msg, (Object)emptyMsg);
        Assert.assertTrue((boolean)msg.hasBools());
        Assert.assertTrue((boolean)msg.hasDoubles());
        Assert.assertTrue((boolean)msg.hasFloats());
        Assert.assertTrue((boolean)msg.hasFixed32S());
        Assert.assertTrue((boolean)msg.hasFixed64S());
        Assert.assertTrue((boolean)msg.hasSfixed32S());
        Assert.assertTrue((boolean)msg.hasSfixed64S());
        Assert.assertTrue((boolean)msg.hasSint32S());
        Assert.assertTrue((boolean)msg.hasSint64S());
        Assert.assertTrue((boolean)msg.hasInt32S());
        Assert.assertTrue((boolean)msg.hasInt64S());
        Assert.assertTrue((boolean)msg.hasUint32S());
        Assert.assertTrue((boolean)msg.hasUint64S());
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false, true, true}, (boolean[])msg.getBools().toArray());
        Assert.assertArrayEquals((double[])new double[]{Double.POSITIVE_INFINITY, -2.0, 3.0, 4.0}, (double[])msg.getDoubles().toArray(), (double)0.0);
        Assert.assertArrayEquals((float[])new float[]{10.0f, 20.0f, -30.0f, Float.NaN}, (float[])msg.getFloats().toArray(), (float)0.0f);
        Assert.assertArrayEquals((int[])new int[]{2, -2, 4, 67423}, (int[])msg.getFixed32S().toArray());
        Assert.assertArrayEquals((long[])new long[]{3231313L, 6L, -7L, 8L}, (long[])msg.getFixed64S().toArray());
        Assert.assertArrayEquals((int[])new int[]{2, -3, 4, 5}, (int[])msg.getSfixed32S().toArray());
        Assert.assertArrayEquals((long[])new long[]{5L, -6L, 7L, -8L}, (long[])msg.getSfixed64S().toArray());
        Assert.assertArrayEquals((int[])new int[]{2, -3, 4, 5}, (int[])msg.getSint32S().toArray());
        Assert.assertArrayEquals((long[])new long[]{5L, 6L, -7L, 8L}, (long[])msg.getSint64S().toArray());
        Assert.assertArrayEquals((int[])new int[]{2, 3, -4, 5}, (int[])msg.getInt32S().toArray());
        Assert.assertArrayEquals((long[])new long[]{5L, -6L, 7L, 8L}, (long[])msg.getInt64S().toArray());
        Assert.assertArrayEquals((int[])new int[]{2, 300, 4, 5}, (int[])msg.getUint32S().toArray());
        Assert.assertArrayEquals((long[])new long[]{5L, 6L, 0x170000000000L, 8L}, (long[])msg.getUint64S().toArray());
        RepeatedPackables.Packed manualMsg = RepeatedPackables.Packed.newInstance().addAllBools(true, false, true, true).addAllDoubles(Double.POSITIVE_INFINITY, -2.0, 3.0, 4.0).addAllFloats(10.0f, 20.0f, -30.0f, Float.NaN).addAllFixed32S(2, -2, 4, 67423).addAllFixed64S(3231313L, 6L, -7L, 8L).addAllSfixed32S(2, -3, 4, 5).addAllSfixed64S(5L, -6L, 7L, -8L).addAllSint32S(2, -3, 4, 5).addAllSint64S(5L, 6L, -7L, 8L).addAllInt32S(2, 3, -4, 5).addAllInt64S(5L, -6L, 7L, 8L).addAllUint32S(2, 300, 4, 5).addAllUint64S(5L, 6L, 0x170000000000L, 8L);
        Assert.assertEquals((Object)msg, (Object)manualMsg);
        byte[] packed = RepeatedPackables.Packed.parseFrom(CompatibilityTest.repeatedPackablesPacked()).toByteArray();
        byte[] nonPacked = RepeatedPackables.NonPacked.parseFrom(CompatibilityTest.repeatedPackablesNonPacked()).toByteArray();
        Assert.assertEquals((Object)msg, (Object)RepeatedPackables.Packed.parseFrom(packed));
        Assert.assertEquals((Object)RepeatedPackables.Packed.parseFrom(packed), (Object)RepeatedPackables.Packed.parseFrom(nonPacked));
        Assert.assertEquals((Object)RepeatedPackables.NonPacked.parseFrom(packed), (Object)RepeatedPackables.NonPacked.parseFrom(nonPacked));
    }

    @Test
    public void testOptionalEnums() throws IOException {
        TestAllTypes emptyMsg = TestAllTypes.newInstance();
        Assert.assertFalse((boolean)emptyMsg.hasOptionalNestedEnum());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalForeignEnum());
        Assert.assertFalse((boolean)emptyMsg.hasOptionalImportEnum());
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.optionalEnums());
        Assert.assertNotEquals((Object)msg, (Object)emptyMsg);
        Assert.assertTrue((boolean)msg.hasOptionalNestedEnum());
        Assert.assertTrue((boolean)msg.hasOptionalForeignEnum());
        Assert.assertTrue((boolean)msg.hasOptionalImportEnum());
        Assert.assertEquals((Object)((Object)TestAllTypes.NestedEnum.FOO), (Object)((Object)msg.getOptionalNestedEnum()));
        Assert.assertEquals((Object)((Object)ForeignEnum.FOREIGN_BAR), (Object)((Object)msg.getOptionalForeignEnum()));
        Assert.assertEquals((Object)((Object)ImportEnum.IMPORT_BAZ), (Object)((Object)msg.getOptionalImportEnum()));
        TestAllTypes manualMsg = TestAllTypes.newInstance().setOptionalNestedEnum(TestAllTypes.NestedEnum.FOO).setOptionalForeignEnum(ForeignEnum.FOREIGN_BAR).setOptionalImportEnum(ImportEnum.IMPORT_BAZ);
        Assert.assertEquals((Object)msg, (Object)manualMsg);
        try {
            manualMsg.setOptionalNestedEnum(null);
            Assert.fail();
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)manualMsg.hasOptionalNestedEnum());
            Assert.assertEquals((Object)((Object)ForeignEnum.FOREIGN_BAR), (Object)((Object)msg.getOptionalForeignEnum()));
        }
        TestAllTypes msg3 = TestAllTypes.parseFrom(manualMsg.toByteArray());
        Assert.assertEquals((Object)msg, (Object)msg3);
    }

    @Test
    public void testUnknownEnumValue() throws IOException {
        int value = 4;
        TestAllTypes msg = TestAllTypes.parseFrom(TestAllTypes.newInstance().setOptionalNestedEnumValue(value).toByteArray());
        Assert.assertEquals((long)0L, (long)msg.getOptionalNestedEnumValue());
        Assert.assertNull((Object)((Object)msg.getOptionalNestedEnum()));
    }

    @Test
    public void testRepeatedEnums() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.repeatedEnums());
        Assert.assertEquals((long)4L, (long)msg.getRepeatedNestedEnum().length());
        Assert.assertEquals((Object)((Object)TestAllTypes.NestedEnum.FOO), (Object)msg.getRepeatedNestedEnum().get(0));
        Assert.assertEquals((Object)((Object)TestAllTypes.NestedEnum.BAR), (Object)msg.getRepeatedNestedEnum().get(1));
        Assert.assertEquals((Object)((Object)TestAllTypes.NestedEnum.BAZ), (Object)msg.getRepeatedNestedEnum().get(2));
        Assert.assertEquals((Object)((Object)TestAllTypes.NestedEnum.BAZ), (Object)msg.getRepeatedNestedEnum().get(3));
        TestAllTypes actual = TestAllTypes.parseFrom(TestAllTypes.newInstance().copyFrom(msg).toByteArray());
        Assert.assertEquals((Object)msg, (Object)actual);
    }

    @Test
    public void testStrings() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        Assert.assertFalse((boolean)msg.hasOptionalString());
        msg.setOptionalString("optionalString\ud83d\udca9");
        Assert.assertTrue((boolean)msg.hasOptionalString());
        Assert.assertFalse((boolean)msg.hasOptionalCord());
        StringBuilder builder = new StringBuilder().append("he").append("llo!");
        msg.setOptionalCord(builder);
        Assert.assertTrue((boolean)msg.hasOptionalCord());
        TestAllTypes actual = TestAllTypes.parseFrom(msg.toByteArray());
        Assert.assertEquals((Object)msg, (Object)actual);
        Assert.assertEquals((Object)"optionalString\ud83d\udca9", (Object)actual.getOptionalString());
        Assert.assertEquals((Object)"hello!", (Object)actual.getOptionalCord());
        String testString = "decoder-test\ud83d\udca9";
        msg.clearQuick().setDecoder("decoder-test\ud83d\udca9");
        actual = TestAllTypes.parseFrom(msg.toByteArray());
        Assert.assertEquals((Object)"customString", (Object)actual.getDecoderBytes().getString(new Utf8Decoder(){

            public String decode(byte[] bytes, int offset, int length) {
                Assert.assertEquals((long)0L, (long)offset);
                Assert.assertEquals((long)"decoder-test\ud83d\udca9".getBytes(ProtoUtil.Charsets.UTF_8).length, (long)length);
                return "customString";
            }
        }));
        Assert.assertEquals((Object)"customString", (Object)actual.getDecoder());
    }

    @Test
    public void testRepeatedStrings() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.repeatedStrings());
        Assert.assertEquals((long)4L, (long)msg.getRepeatedString().length());
        Assert.assertEquals((Object)"hello", (Object)msg.getRepeatedString().get(0));
        Assert.assertEquals((Object)"world", (Object)msg.getRepeatedString().get(1));
        Assert.assertEquals((Object)"ascii", (Object)msg.getRepeatedString().get(2));
        Assert.assertEquals((Object)"utf8\ud83d\udca9", (Object)msg.getRepeatedString().get(3));
        TestAllTypes msg2 = TestAllTypes.newInstance();
        msg2.getMutableRepeatedString().copyFrom((RepeatedObject)msg.getRepeatedString());
        TestAllTypes actual = TestAllTypes.parseFrom(msg2.toByteArray());
        Assert.assertEquals((Object)msg, (Object)actual);
    }

    @Test
    public void testBytes() throws IOException {
        byte[] utf8Bytes = "optionalByteString\ud83d\udca9".getBytes(ProtoUtil.Charsets.UTF_8);
        byte[] randomBytes = new byte[256];
        new Random(0L).nextBytes(randomBytes);
        TestAllTypes msg = TestAllTypes.newInstance();
        Assert.assertFalse((boolean)msg.hasOptionalBytes());
        msg.addAllOptionalBytes(utf8Bytes);
        Assert.assertTrue((boolean)msg.hasOptionalBytes());
        Assert.assertArrayEquals((byte[])utf8Bytes, (byte[])msg.getOptionalBytes().toArray());
        Assert.assertFalse((boolean)msg.hasDefaultBytes());
        msg.getMutableDefaultBytes().copyFrom(randomBytes);
        Assert.assertTrue((boolean)msg.hasDefaultBytes());
        Assert.assertArrayEquals((byte[])randomBytes, (byte[])msg.getDefaultBytes().toArray());
        TestAllTypes parsedMsg = TestAllTypes.parseFrom(msg.toByteArray());
        Assert.assertEquals((Object)msg, (Object)parsedMsg);
        Assert.assertArrayEquals((byte[])utf8Bytes, (byte[])parsedMsg.getOptionalBytes().toArray());
        Assert.assertArrayEquals((byte[])randomBytes, (byte[])parsedMsg.getDefaultBytes().toArray());
    }

    @Test
    public void testRepeatedBytes() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.repeatedBytes());
        Assert.assertEquals((long)2L, (long)msg.getRepeatedBytes().length());
        Assert.assertArrayEquals((byte[])"ascii".getBytes(ProtoUtil.Charsets.UTF_8), (byte[])((RepeatedByte)msg.getRepeatedBytes().get(0)).toArray());
        Assert.assertArrayEquals((byte[])"utf8\ud83d\udca9".getBytes(ProtoUtil.Charsets.UTF_8), (byte[])((RepeatedByte)msg.getRepeatedBytes().get(1)).toArray());
        TestAllTypes actual = TestAllTypes.parseFrom(TestAllTypes.newInstance().copyFrom(msg).toByteArray());
        Assert.assertEquals((Object)msg, (Object)actual);
    }

    @Test
    public void testOptionalMessages() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        Assert.assertFalse((boolean)msg.hasOptionalNestedMessage());
        msg.getMutableOptionalNestedMessage().setBb(2);
        Assert.assertTrue((boolean)msg.hasOptionalNestedMessage());
        Assert.assertFalse((boolean)msg.hasOptionalForeignMessage());
        msg.setOptionalForeignMessage(ForeignMessage.newInstance().setC(3));
        Assert.assertTrue((boolean)msg.hasOptionalForeignMessage());
        Assert.assertFalse((boolean)msg.hasOptionalGroup());
        msg.getMutableOptionalGroup().copyFrom(TestAllTypes.OptionalGroup.newInstance().setA(4));
        Assert.assertTrue((boolean)msg.hasOptionalGroup());
        Assert.assertEquals((Object)msg, (Object)TestAllTypes.parseFrom(CompatibilityTest.optionalMessages()));
        Assert.assertEquals((Object)msg, (Object)TestAllTypes.parseFrom(msg.toByteArray()));
    }

    @Test
    public void testRepeatedMessages() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.repeatedMessages());
        Assert.assertEquals((long)3L, (long)msg.getRepeatedForeignMessage().length());
        Assert.assertEquals((Object)ForeignMessage.newInstance().setC(0), (Object)msg.getRepeatedForeignMessage().get(0));
        Assert.assertEquals((Object)ForeignMessage.newInstance().setC(1), (Object)msg.getRepeatedForeignMessage().get(1));
        Assert.assertEquals((Object)ForeignMessage.newInstance().setC(2), (Object)msg.getRepeatedForeignMessage().get(2));
        TestAllTypes msg2 = TestAllTypes.newInstance().addRepeatedForeignMessage(ForeignMessage.newInstance().setC(0)).addRepeatedForeignMessage(ForeignMessage.newInstance().setC(1)).addRepeatedForeignMessage(ForeignMessage.newInstance().setC(2)).addRepeatedGroup(TestAllTypes.RepeatedGroup.newInstance().setA(3)).addRepeatedGroup(TestAllTypes.RepeatedGroup.newInstance().setA(4));
        Assert.assertEquals((Object)msg, (Object)msg2);
        TestAllTypes actual = TestAllTypes.parseFrom(TestAllTypes.newInstance().copyFrom(msg2).toByteArray());
        Assert.assertEquals((Object)msg, (Object)actual);
    }

    @Test
    public void testHighFieldNumbers() throws IOException {
        UnittestFieldOrder.MessageWithMultibyteNumbers expected = UnittestFieldOrder.MessageWithMultibyteNumbers.newInstance().setTagSize1(1).setTagSize2(2).setTagSize3(3).setTagSize4(4).setTagSize5(5).setTagSizeMax(6);
        UnittestFieldOrder.MessageWithMultibyteNumbers actual = UnittestFieldOrder.MessageWithMultibyteNumbers.parseFrom(expected.toByteArray());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAllTypesRequired() throws IOException {
        UnittestRequired.TestAllTypesRequired expected = UnittestRequired.TestAllTypesRequired.newInstance().setRequiredBool(true).setRequiredDouble(100.0).setRequiredFloat(101.0f).setRequiredFixed32(102).setRequiredFixed64(103L).setRequiredSfixed32(104).setRequiredSfixed64(105L).setRequiredSint32(106).setRequiredSint64(107L).setRequiredInt32(108).setRequiredInt64(109L).setRequiredUint32(110).setRequiredUint64(111L).setRequiredString("test").addRequiredBytes((byte)0).setRequiredNestedEnum(UnittestRequired.TestAllTypesRequired.NestedEnum.BAR).setRequiredNestedMessage(UnittestRequired.SimpleMessage.newInstance().setRequiredField(0));
        byte[] output = expected.toByteArray();
        UnittestRequired.TestAllTypesRequired actual = UnittestRequired.TestAllTypesRequired.parseFrom(expected.toByteArray());
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertArrayEquals((byte[])output, (byte[])actual.toByteArray());
        try {
            expected.clearRequiredBool().toByteArray();
            Assert.fail((String)"should not serialize with missing required field");
        }
        catch (UninitializedMessageException uninitializedMessageException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)expected.isInitialized());
        expected.setRequiredBool(false);
        Assert.assertTrue((boolean)expected.isInitialized());
        expected.clearRequiredInt32();
        Assert.assertFalse((boolean)expected.isInitialized());
        expected.setRequiredInt32(108);
        Assert.assertTrue((boolean)expected.isInitialized());
        expected.getMutableRequiredNestedMessage().clear();
        Assert.assertFalse((boolean)expected.isInitialized());
        expected.getMutableRequiredNestedMessage().setRequiredField(0);
        Assert.assertTrue((boolean)expected.isInitialized());
    }

    @Test
    public void testMergeFromMessage() throws IOException {
        TestAllTypes binaryMerged = TestAllTypes.newInstance();
        TestAllTypes messageMerged = TestAllTypes.newInstance();
        RepeatedByte combined = RepeatedByte.newEmptyInstance();
        for (byte[] input : CompatibilityTest.getAllMessages()) {
            combined.addAll(input);
            binaryMerged.mergeFrom(ProtoSource.newInstance((byte[])input));
            messageMerged.mergeFrom(TestAllTypes.parseFrom(input));
            Assert.assertEquals((Object)binaryMerged, (Object)messageMerged);
        }
        byte[] array = combined.toArray();
        Assert.assertEquals((Object)TestAllTypes.parseFrom(array), (Object)messageMerged);
        Assert.assertEquals((Object)TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage()), (Object)messageMerged.addAllRepeatedPackedInt32(-1, 0, 1, 2, 3, 4, 5).addAllRepeatedInt32(-2, -1, 0, 1, 2, 3, 4, 5));
    }

    @Test
    public void testSkipUnknownFields() throws IOException {
        ProtoSource source = ProtoSource.newInstance((byte[])CompatibilityTest.getCombinedMessage());
        TestAllTypes.NestedMessage.newInstance().mergeFrom(source);
        Assert.assertTrue((boolean)source.isAtEnd());
    }

    @Test
    public void testStoreUnknownFields() throws IOException {
        byte[] bytes = CompatibilityTest.getCombinedMessage();
        TestAllTypes expected = TestAllTypes.parseFrom(bytes);
        TestAllTypes.NestedMessage wrongMessage = TestAllTypes.NestedMessage.newInstance();
        wrongMessage.mergeFrom(ProtoSource.newInstance((byte[])bytes));
        byte[] unknowns = wrongMessage.toByteArray();
        Assert.assertEquals((long)bytes.length, (long)unknowns.length);
        Assert.assertEquals((Object)TestAllTypes.parseFrom(bytes), (Object)TestAllTypes.parseFrom(unknowns));
        Assert.assertEquals((long)2L, (long)TestAllTypes.NestedMessage.parseFrom(ProtoSource.newInstance((byte[])bytes).discardUnknownFields()).getSerializedSize());
    }

    @Test
    public void clearFirstBit() throws IOException {
        TestAllTypes.NestedMessage msg = TestAllTypes.NestedMessage.newInstance();
        msg.setBb(1);
        Assert.assertTrue((boolean)msg.hasBb());
        msg.clearBb();
        Assert.assertFalse((boolean)msg.hasBb());
    }

    @Test
    public void testRepeatableMessageIterator() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.repeatedMessages());
        int sum = 0;
        for (ForeignMessage foreignMessage : msg.getRepeatedForeignMessage()) {
            sum += foreignMessage.getC();
        }
        Assert.assertEquals((long)3L, (long)sum);
    }

    @Test
    public void testOneofFields() throws IOException {
        TestAllTypes msg = TestAllTypes.newInstance();
        Assert.assertFalse((boolean)msg.hasOneofField());
        msg.setOneofFixed64(10L);
        Assert.assertTrue((boolean)msg.hasOneofField());
        Assert.assertTrue((boolean)msg.hasOneofFixed64());
        byte[] fixed64 = msg.toByteArray();
        msg.getMutableOneofNestedMessage().setBb(2);
        Assert.assertTrue((boolean)msg.hasOneofField());
        Assert.assertTrue((boolean)msg.hasOneofNestedMessage());
        Assert.assertFalse((boolean)msg.hasOneofFixed64());
        Assert.assertEquals((long)0L, (long)msg.getOneofFixed64());
        byte[] nestedMsg = msg.toByteArray();
        msg.setOneofString("oneOfString");
        Assert.assertTrue((boolean)msg.hasOneofField());
        Assert.assertTrue((boolean)msg.hasOneofString());
        Assert.assertFalse((boolean)msg.hasOneofNestedMessage());
        Assert.assertEquals((long)0L, (long)msg.getOneofNestedMessage().getBb());
        byte[] string = msg.toByteArray();
        msg.clearOneofField();
        Assert.assertFalse((boolean)msg.hasOneofField());
        Assert.assertFalse((boolean)msg.hasOneofString());
        Assert.assertFalse((boolean)msg.hasOneofNestedMessage());
        Assert.assertEquals((Object)"", (Object)msg.getOneofString());
        msg.setOneofString("test");
        Assert.assertTrue((boolean)msg.hasOneofString());
        msg.mergeFrom(ProtoSource.newInstance((byte[])fixed64));
        Assert.assertTrue((boolean)msg.hasOneofFixed64());
        Assert.assertFalse((boolean)msg.hasOneofString());
        msg.mergeFrom(ProtoSource.newInstance((byte[])nestedMsg));
        Assert.assertTrue((boolean)msg.hasOneofNestedMessage());
        Assert.assertFalse((boolean)msg.hasOneofFixed64());
        msg.mergeFrom(ProtoSource.newInstance((byte[])string));
        Assert.assertTrue((boolean)msg.hasOneofString());
        Assert.assertFalse((boolean)msg.hasOneofNestedMessage());
    }

    @Test
    public void testToString() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        msg.setOptionalDouble(103.0);
        Assert.assertNotNull((Object)msg.toString());
        int unknownFieldNumber = 12313;
        int numBytes = ProtoSink.computeDoubleSize((int)12313, (double)Double.NaN);
        byte[] unknownBytes = msg.getUnknownBytes().setLength(numBytes).array();
        ProtoSink.newInstance((byte[])unknownBytes, (int)0, (int)numBytes).writeDouble(12313, Double.NaN);
        Assert.assertNotNull((Object)msg.toString());
    }

    @Test
    public void testUnknownFields() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        byte[] expected = msg.clearOptionalInt32().toByteArray();
        byte[] actual = TestAllTypes.NestedMessage.parseFrom(expected).toByteArray();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testDelimitedStream() throws IOException {
        TestAllTypes msg = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        byte[] outData = msg.toByteArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ProtoSink.writeUInt32((OutputStream)outputStream, (int)outData.length);
        outputStream.write(outData);
        byte[] result = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(result);
        int length = ProtoSource.readRawVarint32((InputStream)inputStream);
        Assert.assertEquals((long)outData.length, (long)length);
        byte[] inData = new byte[length];
        if (inputStream.read(inData) != length) {
            Assert.fail();
        }
        Assert.assertArrayEquals((byte[])outData, (byte[])inData);
    }

    @Test
    public void testCollidingFieldNames() throws IOException {
        TestAllTypes expected = TestAllTypes.newInstance().setSerializedSize300(0.0).setCachedSize301(1.0).setMissingFields302(2.0).setUnknownBytes303(3.0).setQuick304(4.0);
        String json = expected.toString();
        Assert.assertEquals((Object)"{\n  \"serializedSize\": 0,\n  \"cachedSize\": 1,\n  \"missingFields\": 2,\n  \"unknownBytes\": 3,\n  \"quick\": 4\n}", (Object)json);
        TestAllTypes actual = TestAllTypes.parseFrom(JsonSource.newInstance((String)json));
        Assert.assertEquals((Object)expected, (Object)actual);
        actual.clearSerializedSize300().clearCachedSize301().clearMissingFields302().clearUnknownBytes303().clearQuick304();
        Assert.assertTrue((boolean)actual.isEmpty());
        actual.mergeFrom(ProtoSource.newInstance((byte[])expected.toByteArray()));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testLazyInitialization() throws IOException {
        Assert.assertNotNull((Object)Value.newInstance().getMutableListValue());
        Assert.assertNotNull((Object)Value.newInstance().getMutableStringValueBytes());
        Assert.assertNotNull((Object)Value.newInstance().getMutableStructValue());
        Assert.assertNotNull((Object)Value.newInstance().getMutableListValue());
        Struct struct = Struct.newInstance();
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableOptionalStringBytes());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableOptionalBytes());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableOptionalGroup());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableOptionalNestedMessage());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedInt32());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedInt64());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedUint32());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedUint64());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedSint32());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedSint64());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedFixed32());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedFixed64());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedFloat());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedDouble());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedBool());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedString());
        Assert.assertNotNull((Object)LazyTypes.LazyMessage.newInstance().getMutableRepeatedBytes());
        LazyTypes.LazyMessage msg = LazyTypes.LazyMessage.newInstance();
        msg.setOptionalString("test");
        msg.addAllOptionalBytes(new byte[20]);
        msg.setOptionalGroup(LazyTypes.LazyMessage.OptionalGroup.newInstance().setA(2));
        msg.setOptionalNestedMessage(LazyTypes.LazyMessage.NestedMessage.newInstance().setRecursiveMessage(LazyTypes.LazyMessage.newInstance()));
        msg.getMutableRepeatedInt32().add(1);
        msg.getMutableRepeatedInt64().add(2L);
        msg.getMutableRepeatedUint32().add(3);
        msg.getMutableRepeatedUint64().add(4L);
        msg.getMutableRepeatedSint32().add(5);
        msg.getMutableRepeatedSint64().add(6L);
        msg.getMutableRepeatedFixed32().add(7);
        msg.getMutableRepeatedFixed64().add(8L);
        msg.getMutableRepeatedFloat().add(9.0f);
        msg.getMutableRepeatedDouble().add(10.0);
        msg.getMutableRepeatedBool().add(true);
        msg.getMutableRepeatedString().add((Object)"string");
        msg.getMutableRepeatedBytes().add((Object)new byte[20]);
        Assert.assertTrue((boolean)msg.isInitialized());
        msg.getMutableRepeatedNestedMessage().next();
        Assert.assertFalse((boolean)msg.isInitialized());
        ((LazyTypes.LazyMessage.NestedMessage)msg.getRepeatedNestedMessage().get(0)).getMutableRecursiveMessage();
        Assert.assertTrue((boolean)msg.isInitialized());
        LazyTypes.LazyMessage copy = msg.clone();
        copy.copyFrom(LazyTypes.LazyMessage.newInstance());
        LazyTypes.LazyMessage.newInstance().copyFrom(copy);
        LazyTypes.LazyMessage.newInstance().copyFrom(msg);
        msg.clone().clear().clear();
        copy.clear().clone().clear();
        msg.clone().clearQuick();
        copy.clearQuick().clone().clearQuick();
        LazyTypes.LazyMessage empty = LazyTypes.LazyMessage.newInstance();
        Assert.assertTrue((boolean)empty.isEmpty());
        empty.clearOptionalString();
        empty.clearOptionalBytes();
        empty.clearOptionalGroup();
        empty.clearOptionalNestedMessage();
        empty.clearRepeatedInt32();
        empty.clearRepeatedInt64();
        empty.clearRepeatedUint32();
        empty.clearRepeatedUint64();
        empty.clearRepeatedSint32();
        empty.clearRepeatedSint64();
        empty.clearRepeatedFixed32();
        empty.clearRepeatedFixed64();
        empty.clearRepeatedFloat();
        empty.clearRepeatedDouble();
        empty.clearRepeatedBool();
        empty.clearRepeatedString();
        empty.clearRepeatedBytes();
        Assert.assertTrue((boolean)empty.isEmpty());
        empty.copyFrom(msg);
        Assert.assertFalse((boolean)empty.isEmpty());
        empty.clearOptionalString();
        empty.clearOptionalBytes();
        empty.clearOptionalGroup();
        empty.clearOptionalNestedMessage();
        empty.clearRepeatedInt32();
        empty.clearRepeatedInt64();
        empty.clearRepeatedUint32();
        empty.clearRepeatedUint64();
        empty.clearRepeatedSint32();
        empty.clearRepeatedSint64();
        empty.clearRepeatedFixed32();
        empty.clearRepeatedFixed64();
        empty.clearRepeatedFloat();
        empty.clearRepeatedDouble();
        empty.clearRepeatedBool();
        empty.clearRepeatedString();
        empty.clearRepeatedBytes();
        empty.clearRepeatedNestedMessage();
        Assert.assertTrue((boolean)empty.isEmpty());
        copy.mergeFrom(msg).mergeFrom(msg);
        empty = LazyTypes.LazyMessage.newInstance().mergeFrom(copy);
        Assert.assertFalse((boolean)empty.isEmpty());
    }

    @Test
    public void testRepeatedInternalArray() throws IOException {
        LazyTypes.LazyMessage msg = LazyTypes.LazyMessage.newInstance();
        msg.getMutableRepeatedFixed32().setInternalArray(new int[]{1, 2, 3, 4});
        msg.getMutableRepeatedFloat().setInternalArray(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, 3);
        Assert.assertEquals((long)42L, (long)msg.getSerializedSize());
        Assert.assertEquals((Object)msg, (Object)LazyTypes.LazyMessage.parseFrom(msg.toByteArray()));
    }

    @Test
    public void testRecursionLimit() throws IOException {
        ProtoSource source;
        LazyTypes.LazyMessage msg;
        LazyTypes.LazyMessage nested = msg = LazyTypes.LazyMessage.newInstance();
        for (int i = 0; i < 33; ++i) {
            nested = nested.getMutableOptionalNestedMessage().getMutableRecursiveMessage();
        }
        byte[] lotsOfNestedMessages = msg.toByteArray();
        try {
            source = ProtoSource.newInstance((byte[])lotsOfNestedMessages);
            LazyTypes.LazyMessage.parseFrom(source);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("limit"));
        }
        source = ProtoSource.newInstance((byte[])lotsOfNestedMessages);
        Assert.assertEquals((long)64L, (long)source.setRecursionLimit(66));
        Assert.assertEquals((Object)msg, (Object)LazyTypes.LazyMessage.parseFrom(source));
    }

    @Test
    public void testDescriptorContent() throws IOException {
        byte[] bytes = LazyTypes.LazyMessage.NestedMessage.getDescriptorProtoBytes();
        String content = CompatibilityTest.printDescriptor(bytes);
        Assert.assertEquals((Object)"name: \"NestedMessage\"\nfield {\n  name: \"bb\"\n  number: 1\n  label: LABEL_OPTIONAL\n  type: TYPE_INT32\n  json_name: \"bb\"\n}\nfield {\n  name: \"recursive_message\"\n  number: 2\n  label: LABEL_REQUIRED\n  type: TYPE_MESSAGE\n  type_name: \".quickbuf_unittest.LazyMessage\"\n  json_name: \"recursiveMessage\"\n}\n", (Object)content);
    }

    @Ignore
    @Test
    public void testDescriptorBinaryForm() throws IOException {
        byte[] expected = CompatibilityTest.getDescriptorBytes();
        byte[] actual = TestAllTypes.getDescriptorProtoBytes();
        Assert.assertEquals((String)"Descriptor content", (Object)CompatibilityTest.printDescriptor(expected), (Object)CompatibilityTest.printDescriptor(actual));
        Assert.assertArrayEquals((String)"Descriptor bytes", (byte[])expected, (byte[])actual);
    }

    @Test
    public void testEnumAlias() throws IOException {
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_RUNNING));
        Assert.assertEquals((long)1L, (long)1L);
        TestEnumsMessage msg = TestEnumsMessage.newInstance();
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_UNSPECIFIED), (Object)((Object)msg.getField()));
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)msg.getDefaultStarted()));
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)msg.getDefaultRunning()));
        Assert.assertArrayEquals((byte[])msg.clearQuick().setField(TestEnumsMessage.EnumAllowingAlias.EAA_STARTED).toByteArray(), (byte[])msg.clearQuick().setField(TestEnumsMessage.EnumAllowingAlias.EAA_RUNNING).toByteArray());
        Assert.assertEquals((Object)msg.clearQuick().setField(TestEnumsMessage.EnumAllowingAlias.EAA_STARTED).toString(), (Object)msg.clearQuick().setField(TestEnumsMessage.EnumAllowingAlias.EAA_RUNNING).toString());
        Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)TestEnumsMessage.parseFrom(JsonSource.newInstance((String)"{\"field\":\"EAA_STARTED\"}")).getField()));
        try {
            Assert.assertEquals((Object)((Object)TestEnumsMessage.EnumAllowingAlias.EAA_STARTED), (Object)((Object)TestEnumsMessage.parseFrom(JsonSource.newInstance((String)"{\"field\":\"EAA_PROCESSING\"}")).getField()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

