/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import protos.test.quickbuf.RepeatedPackables;
import protos.test.quickbuf.TestAllTypes;
import protos.test.quickbuf.UnittestRequired;
import us.hebi.quickbuf.CompatibilityTest;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.UnsafeAccess;

public class UnsafeTest {
    TestAllTypes message;
    byte[] array;
    ByteBuffer directBuffer;
    static final int offset = 10;
    static final int bbSize = 1024;

    @Before
    public void setupData() throws IOException {
        this.message = TestAllTypes.parseFrom(CompatibilityTest.getCombinedMessage());
        this.array = this.message.toByteArray();
        this.directBuffer = ByteBuffer.allocateDirect(this.array.length);
        this.directBuffer.put(this.array);
        this.directBuffer.rewind();
    }

    @Test
    public void testUnsafeArray() throws IOException {
        int offset = 11;
        byte[] target = new byte[this.array.length + offset];
        ProtoSink sink = ProtoSink.newDirectSink().setOutput(target, (long)offset, target.length - offset);
        this.message.writeTo(sink);
        sink.checkNoSpaceLeft();
        byte[] actual = Arrays.copyOfRange(target, offset, target.length);
        Assert.assertArrayEquals((byte[])this.array, (byte[])actual);
        ProtoSource source = ProtoSource.newDirectSource().setInput(target, (long)offset, target.length - offset);
        Assert.assertEquals((Object)this.message, (Object)TestAllTypes.newInstance().mergeFrom(source));
    }

    @Test
    public void testUnsafeDirectMemory() throws IOException {
        ProtoSink sink = ProtoSink.newDirectSink().setOutput(null, UnsafeAccess.BufferAccess.address((ByteBuffer)this.directBuffer), this.array.length);
        this.message.writeTo(sink);
        byte[] actual = new byte[sink.getTotalBytesWritten()];
        sink.checkNoSpaceLeft();
        this.directBuffer.get(actual);
        Assert.assertArrayEquals((byte[])this.array, (byte[])actual);
        ProtoSource source = ProtoSource.newDirectSource().setInput(null, UnsafeAccess.BufferAccess.address((ByteBuffer)this.directBuffer), this.array.length);
        Assert.assertEquals((Object)this.message, (Object)TestAllTypes.newInstance().mergeFrom(source));
    }

    @Test
    public void testRepeatedPacked() throws IOException {
        RepeatedPackables.Packed msg = RepeatedPackables.Packed.parseFrom(CompatibilityTest.repeatedPackablesPacked());
        int size = msg.getSerializedSize();
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        ProtoSink sink = ProtoSink.newDirectSink().setOutput(null, UnsafeAccess.BufferAccess.address((ByteBuffer)buffer), size);
        msg.writeTo(sink);
        sink.checkNoSpaceLeft();
        ProtoSource source = ProtoSource.newDirectSource().setInput(null, UnsafeAccess.BufferAccess.address((ByteBuffer)buffer), size);
        Assert.assertEquals((Object)msg, (Object)RepeatedPackables.Packed.newInstance().mergeFrom(source));
    }

    @Test
    public void testRepeatedNonPacked() throws IOException {
        RepeatedPackables.NonPacked msg = RepeatedPackables.NonPacked.parseFrom(CompatibilityTest.repeatedPackablesNonPacked());
        int size = msg.getSerializedSize();
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        ProtoSink sink = ProtoSink.newDirectSink().setOutput(null, UnsafeAccess.BufferAccess.address((ByteBuffer)buffer), size);
        msg.writeTo(sink);
        sink.checkNoSpaceLeft();
        ProtoSource source = ProtoSource.newDirectSource().setInput(null, UnsafeAccess.BufferAccess.address((ByteBuffer)buffer), size);
        Assert.assertEquals((Object)msg, (Object)RepeatedPackables.NonPacked.newInstance().mergeFrom(source));
    }

    @Test
    public void testDirectBuffer() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        this.testWriteByteBuffer(ProtoSink.newDirectSink(), buffer);
        this.testReadByteBuffer(ProtoSource.newDirectSource(), buffer);
        this.testReadByteBuffer(ProtoSource.newDirectSource(), buffer.asReadOnlyBuffer());
    }

    @Test
    public void testHeapBuffer() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        this.testWriteByteBuffer(ProtoSink.newDirectSink(), buffer);
        this.testReadByteBuffer(ProtoSource.newDirectSource(), buffer);
        this.testReadByteBuffer(ProtoSource.newDirectSource(), buffer.asReadOnlyBuffer());
        this.testWriteByteBuffer(ProtoSink.newArraySink(), buffer);
        this.testReadByteBuffer(ProtoSource.newArraySource(), buffer);
        this.testReadByteBuffer(ProtoSource.newArraySource(), buffer.asReadOnlyBuffer());
    }

    @Test
    public void testDirectExample() throws IOException {
        UnittestRequired.SimpleMessage msg = UnittestRequired.SimpleMessage.newInstance();
        msg.setRequiredField(1);
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(msg.getSerializedSize());
        ProtoSink directSink = ProtoSink.newDirectSink();
        directSink.setOutput(directBuffer);
        msg.writeTo(directSink);
        directBuffer.limit(directSink.getTotalBytesWritten());
        ProtoSource directSource = ProtoSource.newDirectSource();
        directSource.setInput(directBuffer);
        UnittestRequired.SimpleMessage msg2 = UnittestRequired.SimpleMessage.parseFrom(directSource);
        Assert.assertEquals((Object)msg, (Object)msg2);
    }

    @Test
    public void testDirectBufferFailures() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        try {
            this.testWriteByteBuffer(ProtoSink.newDirectSink(), buffer.asReadOnlyBuffer());
            Assert.fail((String)"write to read-only");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.testWriteByteBuffer(ProtoSink.newArraySink(), buffer);
            Assert.fail((String)"heap sink with direct buffer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.testReadByteBuffer(ProtoSource.newArraySource(), buffer);
            Assert.fail((String)"heap source with direct buffer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHeapBufferFailures() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        try {
            this.testWriteByteBuffer(ProtoSink.newDirectSink(), buffer.asReadOnlyBuffer());
            Assert.fail((String)"write to read-only");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.testWriteByteBuffer(ProtoSink.newArraySink(), buffer.asReadOnlyBuffer());
            Assert.fail((String)"heap with direct buffer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private ByteBuffer prepare(ByteBuffer buffer) throws IOException {
        int length = this.array.length;
        buffer.position(10);
        buffer.limit(10 + length);
        return buffer;
    }

    private void testWriteByteBuffer(ProtoSink sink, ByteBuffer buffer) throws IOException {
        sink.setOutput(this.prepare(buffer));
        Assert.assertEquals((long)0L, (long)sink.getTotalBytesWritten());
        Assert.assertEquals((long)buffer.remaining(), (long)sink.spaceLeft());
        this.message.writeTo(sink);
        Assert.assertEquals((long)(buffer.limit() - buffer.position()), (long)sink.getTotalBytesWritten());
        sink.checkNoSpaceLeft();
    }

    private void testReadByteBuffer(ProtoSource source, ByteBuffer buffer) throws IOException {
        source.setInput(this.prepare(buffer));
        Assert.assertEquals((long)0L, (long)source.getTotalBytesRead());
        Assert.assertEquals((long)-1L, (long)source.getBytesUntilLimit());
        Assert.assertFalse((boolean)source.isAtEnd());
        TestAllTypes actual = TestAllTypes.parseFrom(source);
        Assert.assertEquals((long)buffer.remaining(), (long)source.getTotalBytesRead());
        Assert.assertEquals((long)-1L, (long)source.getBytesUntilLimit());
        Assert.assertTrue((boolean)source.isAtEnd());
        Assert.assertEquals((Object)this.message, (Object)actual);
    }
}

