/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.DurationType;
import java.io.Serializable;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import us.ihmc.pubsub.common.Time;

public class DDSConversionTools {
    public static DurationType timeToDurationType(Time time) {
        DurationType dt = new DurationType();
        dt.getContent().add((Serializable)new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "nanosec"), Long.class, (Object)time.getNanoseconds()));
        dt.getContent().add((Serializable)new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "sec"), Integer.class, (Object)time.getSeconds()));
        return dt;
    }

    public static Time durationTypeToTime(DurationType duration) {
        if (duration == null) {
            return null;
        }
        Time time = new Time();
        for (Serializable s : duration.getContent()) {
            JAXBElement e = (JAXBElement)s;
            switch (e.getName().getLocalPart()) {
                case "nanosec": {
                    time.setNanoseconds((Long)e.getValue());
                    break;
                }
                case "sec": {
                    time.setSeconds((Integer)e.getValue());
                }
            }
        }
        return time;
    }

    public static Time createTime(double timeInSeconds) {
        Time time = new Time();
        int seconds = (int)timeInSeconds;
        double remainder = timeInSeconds - (double)seconds;
        time.setSeconds((int)timeInSeconds);
        time.setNanoseconds((long)(remainder * 1.0E9));
        return time;
    }
}

