/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.fourBar.CrossFourBarTest;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarVertex;

public class ConvexFourBarTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-7;
    private static final boolean PRINT = false;

    @Test
    public void testSquare() {
        FourBar fourBar = new FourBar();
        fourBar.setup(1.0, 1.0, 1.0, 1.0);
        fourBar.update(FourBarAngle.DAB, 1.5707963267948966);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleDAB(), (double)1.0E-7);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleABC(), (double)1.0E-7);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleBCD(), (double)1.0E-7);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleCDA(), (double)1.0E-7);
    }

    @Test
    public void testConstruction() {
        Random random = new Random(1738L);
        double DA = random.nextDouble();
        double AB = random.nextDouble();
        double BC = random.nextDouble();
        double CD = random.nextDouble();
        FourBar fourBar = new FourBar();
        fourBar.setup(AB, BC, CD, DA);
        Assertions.assertEquals((double)AB, (double)fourBar.getAB(), (double)1.0E-7);
        Assertions.assertEquals((double)BC, (double)fourBar.getBC(), (double)1.0E-7);
        Assertions.assertEquals((double)CD, (double)fourBar.getCD(), (double)1.0E-7);
        Assertions.assertEquals((double)DA, (double)fourBar.getDA(), (double)1.0E-7);
    }

    @Test
    public void testSquareDerivatives() {
        FourBar fourBar = new FourBar();
        fourBar.setup(1.0, 1.0, 1.0, 1.0);
        fourBar.update(FourBarAngle.DAB, 1.5707963267948966, 1.0);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleDAB(), (double)1.0E-7);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleABC(), (double)1.0E-7);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleBCD(), (double)1.0E-7);
        Assertions.assertEquals((double)1.5707963267948966, (double)fourBar.getAngleCDA(), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)fourBar.getAngleDtDAB(), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)fourBar.getAngleDtBCD(), (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)fourBar.getAngleDtABC(), (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)fourBar.getAngleDtCDA(), (double)1.0E-7);
    }

    @Test
    public void testParallelogram() {
        FourBar fourBar = new FourBar();
        fourBar.setup(1.0, 1.0, 1.0, 1.0);
        fourBar.update(FourBarAngle.DAB, 1.0471975511965976, 1.0);
        Assertions.assertEquals((double)1.0471975511965976, (double)fourBar.getAngleDAB(), (double)1.0E-7);
        Assertions.assertEquals((double)2.0943951023931953, (double)fourBar.getAngleABC(), (double)1.0E-7);
        Assertions.assertEquals((double)1.0471975511965976, (double)fourBar.getAngleBCD(), (double)1.0E-7);
        Assertions.assertEquals((double)2.0943951023931953, (double)fourBar.getAngleCDA(), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)fourBar.getAngleDtDAB(), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)fourBar.getAngleDtBCD(), (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)fourBar.getAngleDtABC(), (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)fourBar.getAngleDtCDA(), (double)1.0E-7);
    }

    @Test
    public void testRandomQuadrilateral() {
        Random rand = new Random(1986L);
        for (int i = 0; i < 10000; ++i) {
            double e = 100.0 * (rand.nextDouble() + 0.001);
            double k1 = rand.nextDouble();
            double k2 = rand.nextDouble();
            double d1 = e * Math.abs(rand.nextGaussian());
            double d2 = e * Math.abs(rand.nextGaussian());
            double DE = e * k1;
            double DF = e * k2;
            double BE = e * (1.0 - k1);
            double BF = e * (1.0 - k2);
            double AE = d1;
            double CF = d2;
            double AD = Math.sqrt(DE * DE + AE * AE);
            double DAE = Math.atan2(DE, AE);
            double ADE = Math.atan2(AE, DE);
            double AB = Math.sqrt(AE * AE + BE * BE);
            double BAE = Math.atan2(BE, AE);
            double ABE = Math.atan2(AE, BE);
            double CD = Math.sqrt(CF * CF + DF * DF);
            double CDF = Math.atan2(CF, DF);
            double DCF = Math.atan2(DF, CF);
            double BC = Math.sqrt(BF * BF + CF * CF);
            double CBF = Math.atan2(CF, BF);
            double BCF = Math.atan2(BF, CF);
            double BAD = DAE + BAE;
            double ABC = ABE + CBF;
            double BCD = BCF + DCF;
            double ADC = ADE + CDF;
            this.solveFourBar(AD, AB, BC, CD, BAD, ABC, BCD, ADC);
        }
    }

    private void solveFourBar(double a, double b, double c, double d, double A, double B, double C, double D) {
        FourBar fourBar = new FourBar();
        fourBar.setup(b, c, d, a);
        fourBar.update(FourBarAngle.DAB, A, 0.0);
        Assertions.assertEquals((double)A, (double)fourBar.getAngleDAB(), (double)1.0E-7);
        Assertions.assertEquals((double)B, (double)fourBar.getAngleABC(), (double)1.0E-7);
        Assertions.assertEquals((double)C, (double)fourBar.getAngleBCD(), (double)1.0E-7);
        Assertions.assertEquals((double)D, (double)fourBar.getAngleCDA(), (double)1.0E-7);
    }

    @Test
    public void testRandomConvenientLinkageDerivatives() {
        Random rand = new Random(1986L);
        for (int i = 0; i < 10000; ++i) {
            double s = 100.0 * (rand.nextDouble() + 0.001);
            double l = s * (rand.nextDouble() + 0.001);
            double k = s * (5.0 * rand.nextDouble() + 0.1);
            double AB = l;
            double BC = k;
            double CD = Math.sqrt(l * l + (k - s) * (k - s));
            double AD = s;
            double BAD = 1.5707963267948966;
            double ABC = 1.5707963267948966;
            double BCD = Math.atan2(l, k - s);
            double ADC = Math.PI - BCD;
            double dBAD = 1.0;
            double dABC = -dBAD * s / k;
            double dADC = -dBAD;
            double dBCD = -dABC;
            FourBar fourBar = new FourBar();
            fourBar.setup(AB, BC, CD, AD);
            fourBar.update(FourBarAngle.DAB, BAD, dBAD);
            Assertions.assertEquals((double)BAD, (double)fourBar.getAngleDAB(), (double)1.0E-7);
            Assertions.assertEquals((double)ABC, (double)fourBar.getAngleABC(), (double)1.0E-7);
            Assertions.assertEquals((double)BCD, (double)fourBar.getAngleBCD(), (double)1.0E-7);
            Assertions.assertEquals((double)ADC, (double)fourBar.getAngleCDA(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)(dBAD + dABC + dBCD + dADC), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)(fourBar.getAngleDtDAB() + fourBar.getAngleDtABC() + fourBar.getAngleDtBCD() + fourBar.getAngleDtCDA()), (double)1.0E-7);
            Assertions.assertEquals((double)dBAD, (double)fourBar.getAngleDtDAB(), (double)1.0E-7);
            Assertions.assertEquals((double)dABC, (double)fourBar.getAngleDtABC(), (double)1.0E-7);
            Assertions.assertEquals((double)dBCD, (double)fourBar.getAngleDtBCD(), (double)1.0E-7);
            Assertions.assertEquals((double)dADC, (double)fourBar.getAngleDtCDA(), (double)1.0E-7);
        }
    }

    @Test
    public void testVelocitiesWithRandomQuadrilateral() {
        double eps = 1.0E-6;
        Random rand = new Random(1976L);
        double DAB_t0 = 0.0;
        double DAB_tf = 0.0;
        double DAB_tj = 0.0;
        double dDAB = 0.0;
        double ABC_t0 = 0.0;
        double CDA_t0 = 0.0;
        double BCD_t0 = 0.0;
        double ABC_next_tj = 0.0;
        double CDA_next_tj = 0.0;
        double BCD_next_tj = 0.0;
        double ABC_numerical_tf = 0.0;
        double CDA_numerical_tf = 0.0;
        double BCD_numerical_tf = 0.0;
        double ABC_fourbar_tf = 0.0;
        double CDA_fourbar_tf = 0.0;
        double BCD_fourbar_tf = 0.0;
        int nSteps = 20000;
        double T = 0.001;
        double deltaT = T / ((double)nSteps - 1.0);
        boolean isDABOutOfRange = true;
        for (int i = 0; i < 100000; ++i) {
            double AB = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
            double BC = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
            double CD = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
            double DA = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
            FourBar fourBar = new FourBar();
            fourBar.setup(AB, BC, CD, DA);
            boolean isQuadrilateralOK = fourBar.getMaxDAB() - fourBar.getMinDAB() > 1.0E-5;
            int k = 0;
            while (!isQuadrilateralOK) {
                AB = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
                BC = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
                CD = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
                DA = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)2.0);
                fourBar = new FourBar();
                fourBar.setup(AB, BC, CD, DA);
                boolean bl = isQuadrilateralOK = fourBar.getMaxDAB() - fourBar.getMinDAB() > 1.0E-5;
                if (++k <= 10) continue;
                throw new RuntimeException("Could not make a convex quadrilateral");
            }
            boolean goToNextIteration = false;
            k = 0;
            while (isDABOutOfRange) {
                dDAB = EuclidCoreRandomTools.nextDouble((Random)rand, (double)-30.0, (double)30.0);
                DAB_t0 = EuclidCoreRandomTools.nextDouble((Random)rand, (double)0.1, (double)3.041592653589793);
                DAB_tf = DAB_t0 + dDAB * T;
                boolean DAB_t0_outOfRange = fourBar.update(FourBarAngle.DAB, DAB_t0) != null;
                ABC_t0 = fourBar.getAngleABC();
                CDA_t0 = fourBar.getAngleCDA();
                BCD_t0 = fourBar.getAngleBCD();
                boolean DAB_tf_outOfRange = fourBar.update(FourBarAngle.DAB, DAB_tf) != null;
                ABC_fourbar_tf = fourBar.getAngleABC();
                CDA_fourbar_tf = fourBar.getAngleCDA();
                BCD_fourbar_tf = fourBar.getAngleBCD();
                if (++k > 10) {
                    goToNextIteration = true;
                    break;
                }
                boolean bl = isDABOutOfRange = DAB_t0_outOfRange || DAB_tf_outOfRange;
                if (isDABOutOfRange) continue;
                ABC_next_tj = ABC_t0;
                CDA_next_tj = CDA_t0;
                BCD_next_tj = BCD_t0;
                DAB_tj = DAB_t0;
                for (int j = 0; j < nSteps - 1; ++j) {
                    DAB_tj = DAB_t0 + dDAB * (double)j * deltaT;
                    fourBar.update(FourBarAngle.DAB, DAB_tj, dDAB);
                    ABC_next_tj += fourBar.getAngleDtABC() * deltaT;
                    CDA_next_tj += fourBar.getAngleDtCDA() * deltaT;
                    BCD_next_tj += fourBar.getAngleDtBCD() * deltaT;
                }
            }
            if (goToNextIteration) break;
            ABC_numerical_tf = ABC_next_tj;
            CDA_numerical_tf = CDA_next_tj;
            BCD_numerical_tf = BCD_next_tj;
            Assertions.assertEquals((double)ABC_numerical_tf, (double)ABC_fourbar_tf, (double)eps);
            Assertions.assertEquals((double)CDA_numerical_tf, (double)CDA_fourbar_tf, (double)eps);
            Assertions.assertEquals((double)BCD_numerical_tf, (double)BCD_fourbar_tf, (double)eps);
        }
    }

    @Test
    public void testAccelerationsWithRandomQuadrilateral() {
        double eps = 1.0E-5;
        Random random = new Random(1984L);
        double DAB_t0 = 0.0;
        double DAB_tf = 0.0;
        double DAB_tj = 0.0;
        double dDAB_t0 = 0.0;
        double dDAB_tf = 0.0;
        double dDAB_tj = 0.0;
        double ddDAB = 0.0;
        double ABC_t0 = 0.0;
        double CDA_t0 = 0.0;
        double BCD_t0 = 0.0;
        double ABC_next_tj = 0.0;
        double CDA_next_tj = 0.0;
        double BCD_next_tj = 0.0;
        double ABC_numerical_tf = 0.0;
        double CDA_numerical_tf = 0.0;
        double BCD_numerical_tf = 0.0;
        double ABC_fourbar_tf = 0.0;
        double CDA_fourbar_tf = 0.0;
        double BCD_fourbar_tf = 0.0;
        int nSteps = 10000;
        double T = 0.001;
        double deltaT = T / ((double)nSteps - 1.0);
        for (int i = 0; i < 50; ++i) {
            double BA = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
            double CB = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
            double DC = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
            double AD = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
            FourBar fourBar = new FourBar();
            fourBar.setup(BA, CB, DC, AD);
            boolean isQuadrilateralOK = fourBar.getMaxDAB() - fourBar.getMinDAB() > 1.0E-5;
            int k = 0;
            while (!isQuadrilateralOK) {
                BA = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
                CB = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
                DC = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
                AD = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)2.0);
                fourBar = new FourBar();
                fourBar.setup(BA, CB, DC, AD);
                boolean bl = isQuadrilateralOK = fourBar.getMaxDAB() - fourBar.getMinDAB() > 1.0E-5;
                if (++k <= 10) continue;
                throw new RuntimeException("Could not make a convex quadrilateral");
            }
            DAB_t0 = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getMinDAB(), (double)fourBar.getMaxDAB());
            DAB_tf = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getMinDAB(), (double)fourBar.getMaxDAB());
            dDAB_t0 = 0.0;
            ddDAB = 2.0 * (DAB_tf - DAB_t0 - dDAB_t0 * T) / EuclidCoreTools.square((double)T);
            dDAB_tf = dDAB_t0 + ddDAB * T;
            fourBar.update(FourBarAngle.DAB, DAB_t0, dDAB_t0);
            ABC_t0 = fourBar.getAngleABC();
            CDA_t0 = fourBar.getAngleCDA();
            BCD_t0 = fourBar.getAngleBCD();
            fourBar.update(FourBarAngle.DAB, DAB_tf, dDAB_tf);
            ABC_fourbar_tf = fourBar.getAngleABC();
            CDA_fourbar_tf = fourBar.getAngleCDA();
            BCD_fourbar_tf = fourBar.getAngleBCD();
            ABC_next_tj = ABC_t0;
            CDA_next_tj = CDA_t0;
            BCD_next_tj = BCD_t0;
            for (int j = 0; j < nSteps - 1; ++j) {
                DAB_tj = ddDAB * EuclidCoreTools.square((double)((double)j * deltaT)) / 2.0 + dDAB_t0 * (double)j * deltaT + DAB_t0;
                dDAB_tj = ddDAB * (double)j * deltaT + dDAB_t0;
                fourBar.update(FourBarAngle.DAB, DAB_tj, dDAB_tj, ddDAB);
                ABC_next_tj += fourBar.getAngleDtABC() * deltaT + fourBar.getAngleDt2ABC() * EuclidCoreTools.square((double)deltaT) / 2.0;
                CDA_next_tj += fourBar.getAngleDtCDA() * deltaT + fourBar.getAngleDt2CDA() * EuclidCoreTools.square((double)deltaT) / 2.0;
                BCD_next_tj += fourBar.getAngleDtBCD() * deltaT + fourBar.getAngleDt2BCD() * EuclidCoreTools.square((double)deltaT) / 2.0;
            }
            ABC_numerical_tf = ABC_next_tj;
            CDA_numerical_tf = CDA_next_tj;
            BCD_numerical_tf = BCD_next_tj;
            Assertions.assertEquals((double)ABC_numerical_tf, (double)ABC_fourbar_tf, (double)eps);
            Assertions.assertEquals((double)CDA_numerical_tf, (double)CDA_fourbar_tf, (double)eps);
            Assertions.assertEquals((double)BCD_numerical_tf, (double)BCD_fourbar_tf, (double)eps);
        }
    }

    @Test
    public void testActuatedAngleComputations() {
        Random rand = new Random(1986L);
        for (int i = 0; i < 10000; ++i) {
            double e = 100.0 * (rand.nextDouble() + 0.001);
            double k1 = rand.nextDouble();
            double k2 = rand.nextDouble();
            double d1 = e * Math.abs(rand.nextGaussian());
            double d2 = e * Math.abs(rand.nextGaussian());
            double DE = e * k1;
            double DF = e * k2;
            double BE = e * (1.0 - k1);
            double BF = e * (1.0 - k2);
            double AE = d1;
            double CF = d2;
            double AD = Math.sqrt(DE * DE + AE * AE);
            double DAE = Math.atan2(DE, AE);
            double ADE = Math.atan2(AE, DE);
            double AB = Math.sqrt(AE * AE + BE * BE);
            double BAE = Math.atan2(BE, AE);
            double ABE = Math.atan2(AE, BE);
            double CD = Math.sqrt(CF * CF + DF * DF);
            double CDF = Math.atan2(CF, DF);
            double DCF = Math.atan2(DF, CF);
            double BC = Math.sqrt(BF * BF + CF * CF);
            double CBF = Math.atan2(CF, BF);
            double BCF = Math.atan2(BF, CF);
            double DAB = DAE + BAE;
            double ABC = ABE + CBF;
            double BCD = BCF + DCF;
            double CDA = ADE + CDF;
            FourBar calculator = new FourBar();
            calculator.setup(AB, BC, CD, AD);
            calculator.update(FourBarAngle.ABC, ABC);
            Assertions.assertEquals((double)DAB, (double)calculator.getAngleDAB(), (double)1.0E-7);
            Assertions.assertEquals((double)ABC, (double)calculator.getAngleABC(), (double)1.0E-7);
            Assertions.assertEquals((double)BCD, (double)calculator.getAngleBCD(), (double)1.0E-7);
            Assertions.assertEquals((double)CDA, (double)calculator.getAngleCDA(), (double)1.0E-7);
            calculator.update(FourBarAngle.BCD, BCD);
            Assertions.assertEquals((double)DAB, (double)calculator.getAngleDAB(), (double)1.0E-7);
            Assertions.assertEquals((double)ABC, (double)calculator.getAngleABC(), (double)1.0E-7);
            Assertions.assertEquals((double)BCD, (double)calculator.getAngleBCD(), (double)1.0E-7);
            Assertions.assertEquals((double)CDA, (double)calculator.getAngleCDA(), (double)1.0E-7);
            calculator.update(FourBarAngle.CDA, CDA);
            Assertions.assertEquals((double)DAB, (double)calculator.getAngleDAB(), (double)1.0E-7);
            Assertions.assertEquals((double)ABC, (double)calculator.getAngleABC(), (double)1.0E-7);
            Assertions.assertEquals((double)BCD, (double)calculator.getAngleBCD(), (double)1.0E-7);
            Assertions.assertEquals((double)CDA, (double)calculator.getAngleCDA(), (double)1.0E-7);
        }
    }

    @Test
    public void testGetMinMaxAngles() {
        Random random = new Random(45647L);
        FourBar calculator = new FourBar();
        for (int i = 0; i < 1000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            double ABLength = A.distance((Point2DReadOnly)B);
            double BCLength = B.distance((Point2DReadOnly)C);
            double CDLength = C.distance((Point2DReadOnly)D);
            double DALength = D.distance((Point2DReadOnly)A);
            calculator.setup(ABLength, BCLength, CDLength, DALength);
            double minDAB = calculator.getMinDAB();
            double maxABC = calculator.getMaxABC();
            double minBCD = calculator.getMinBCD();
            double maxCDA = calculator.getMaxCDA();
            Assertions.assertEquals((double)(Math.PI * 2), (double)(minDAB + maxABC + minBCD + maxCDA), (double)1.0E-7, (String)("Iteration " + i));
            double maxDAB = calculator.getMaxDAB();
            double minABC = calculator.getMinABC();
            double maxBCD = calculator.getMaxBCD();
            double minCDA = calculator.getMinCDA();
            Assertions.assertEquals((double)(Math.PI * 2), (double)(maxDAB + minABC + maxBCD + minCDA), (double)1.0E-7, (String)("Iteration " + i));
        }
    }

    @Disabled
    @Test
    public void testBenchmark() throws Throwable {
        Random random = new Random(345L);
        FourBar fourBar = new FourBar();
        List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
        if (random.nextBoolean()) {
            Collections.reverse(vertices);
        }
        Point2D A = (Point2D)vertices.get(0);
        Point2D B = (Point2D)vertices.get(1);
        Point2D C = (Point2D)vertices.get(2);
        Point2D D = (Point2D)vertices.get(3);
        fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
        for (int i = 0; i < 100000; ++i) {
            double nextAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getVertexA().getMinAngle(), (double)fourBar.getVertexA().getMaxAngle());
            double nextAngleDot = random.nextDouble();
            double nextAngleDDot = Double.NaN;
            fourBar.update(FourBarAngle.DAB, nextAngle, nextAngleDot, nextAngleDDot);
        }
        long total = 0L;
        int iter = 1000000;
        for (int i = 0; i < iter; ++i) {
            double nextAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getVertexA().getMinAngle(), (double)fourBar.getVertexA().getMaxAngle());
            double nextAngleDot = random.nextDouble();
            double nextAngleDDot = random.nextDouble();
            long start = System.nanoTime();
            fourBar.update(FourBarAngle.DAB, nextAngle, nextAngleDot, nextAngleDDot);
            total += System.nanoTime() - start;
        }
        LogTools.info((String)("Average time in millisec: " + (double)total / 1000.0 / (double)iter));
    }

    @Test
    public void testGeometry() throws Throwable {
        Random random = new Random(345L);
        FourBar fourBar = new FourBar();
        for (int i = 0; i < 1000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            if (random.nextBoolean()) {
                Collections.reverse(vertices);
            }
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            ConvexFourBarTest.performBasicGeometricAssertions(random, fourBar, i, A, B, C, D);
        }
    }

    @Test
    public void testAtLimits() {
        Random random = new Random(3465764L);
        FourBar fourBar = new FourBar();
        for (int i = 0; i < 1000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            double angleLimitVariation = 1.0E-10;
            double tolerance = 0.001;
            for (FourBarAngle fourBarAngle : FourBarAngle.values) {
                double minAngle = fourBar.getVertex(fourBarAngle).getMinAngle();
                double maxAngle = fourBar.getVertex(fourBarAngle).getMaxAngle();
                Assertions.assertNull((Object)fourBar.update(fourBarAngle, minAngle + angleLimitVariation));
                double expectedDAB = fourBar.getAngleDAB();
                double expectedABC = fourBar.getAngleABC();
                double expectedBCD = fourBar.getAngleBCD();
                double expectedCDA = fourBar.getAngleCDA();
                fourBar.setToMin(fourBarAngle);
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
                Assertions.assertEquals((Object)Bound.MIN, (Object)fourBar.update(fourBarAngle, minAngle));
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
                Assertions.assertNull((Object)fourBar.update(fourBarAngle, maxAngle - angleLimitVariation));
                expectedDAB = fourBar.getAngleDAB();
                expectedABC = fourBar.getAngleABC();
                expectedBCD = fourBar.getAngleBCD();
                expectedCDA = fourBar.getAngleCDA();
                fourBar.setToMax(fourBarAngle);
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
                Assertions.assertEquals((Object)Bound.MAX, (Object)fourBar.update(fourBarAngle, maxAngle));
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
            }
        }
    }

    public static void performBasicGeometricAssertions(Random random, FourBar fourBar, int iteration, Point2D A, Point2D B, Point2D C, Point2D D) throws InterruptedException, Throwable {
        boolean clockwise = ConvexFourBarTest.isClockwiseOrdered((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
        fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
        Vector2D AB = new Vector2D();
        Vector2D BC = new Vector2D();
        Vector2D CD = new Vector2D();
        Vector2D DA = new Vector2D();
        AB.sub((Tuple2DReadOnly)B, (Tuple2DReadOnly)A);
        BC.sub((Tuple2DReadOnly)C, (Tuple2DReadOnly)B);
        CD.sub((Tuple2DReadOnly)D, (Tuple2DReadOnly)C);
        DA.sub((Tuple2DReadOnly)A, (Tuple2DReadOnly)D);
        Vector2D BA = new Vector2D((Tuple2DReadOnly)AB);
        Vector2D CB = new Vector2D((Tuple2DReadOnly)BC);
        Vector2D DC = new Vector2D((Tuple2DReadOnly)CD);
        Vector2D AD = new Vector2D((Tuple2DReadOnly)DA);
        BA.negate();
        CB.negate();
        DC.negate();
        AD.negate();
        FourBarVertex vertexA = fourBar.getVertexA();
        FourBarVertex vertexB = fourBar.getVertexB();
        FourBarVertex vertexC = fourBar.getVertexC();
        FourBarVertex vertexD = fourBar.getVertexD();
        Assertions.assertEquals((Object)(clockwise ? DA.cross((Tuple2DReadOnly)AB) <= 0.0 : DA.cross((Tuple2DReadOnly)AB) >= 0.0), (Object)vertexA.isConvex());
        Assertions.assertEquals((Object)(clockwise ? AB.cross((Tuple2DReadOnly)BC) <= 0.0 : AB.cross((Tuple2DReadOnly)BC) >= 0.0), (Object)vertexB.isConvex());
        Assertions.assertEquals((Object)(clockwise ? BC.cross((Tuple2DReadOnly)CD) <= 0.0 : BC.cross((Tuple2DReadOnly)CD) >= 0.0), (Object)vertexC.isConvex());
        Assertions.assertEquals((Object)(clockwise ? CD.cross((Tuple2DReadOnly)DA) <= 0.0 : CD.cross((Tuple2DReadOnly)DA) >= 0.0), (Object)vertexD.isConvex());
        double expectedAB = AB.length();
        double expectedBC = BC.length();
        double expectedCD = CD.length();
        double expectedDA = DA.length();
        double expectedDAB = AD.angle((Vector2DReadOnly)AB);
        double expectedABC = BA.angle((Vector2DReadOnly)BC);
        double expectedBCD = CB.angle((Vector2DReadOnly)CD);
        double expectedCDA = DC.angle((Vector2DReadOnly)DA);
        double expectedAC = A.distance((Point2DReadOnly)C);
        double expectedBD = B.distance((Point2DReadOnly)D);
        if (!clockwise) {
            expectedDAB = -expectedDAB;
            expectedABC = -expectedABC;
            expectedBCD = -expectedBCD;
            expectedCDA = -expectedCDA;
        }
        try {
            Assertions.assertTrue((vertexA.getMinAngle() <= expectedDAB ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate minDAB: valid angle: " + expectedDAB + ", computed min: " + vertexA.getMinAngle()));
            Assertions.assertTrue((vertexB.getMinAngle() <= expectedABC ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate minABC: valid angle: " + expectedABC + ", computed min: " + vertexB.getMinAngle()));
            Assertions.assertTrue((vertexC.getMinAngle() <= expectedBCD ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate minBCD: valid angle: " + expectedBCD + ", computed min: " + vertexC.getMinAngle()));
            Assertions.assertTrue((vertexD.getMinAngle() <= expectedCDA ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate minCDA: valid angle: " + expectedCDA + ", computed min: " + vertexD.getMinAngle()));
            Assertions.assertTrue((expectedDAB <= vertexA.getMaxAngle() ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate maxDAB: valid angle: " + expectedDAB + ", computed max: " + vertexA.getMaxAngle()));
            Assertions.assertTrue((expectedABC <= vertexB.getMaxAngle() ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate maxABC: valid angle: " + expectedABC + ", computed max: " + vertexB.getMaxAngle()));
            Assertions.assertTrue((expectedBCD <= vertexC.getMaxAngle() ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate maxBCD: valid angle: " + expectedBCD + ", computed max: " + vertexC.getMaxAngle()));
            Assertions.assertTrue((expectedCDA <= vertexD.getMaxAngle() ? 1 : 0) != 0, (String)("Itertation " + iteration + ", inaccurate maxCDA: valid angle: " + expectedCDA + ", computed max: " + vertexD.getMaxAngle()));
            switch ((FourBarAngle)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])FourBarAngle.values)) {
                case DAB: {
                    fourBar.update(FourBarAngle.DAB, expectedDAB);
                    break;
                }
                case ABC: {
                    fourBar.update(FourBarAngle.ABC, expectedABC);
                    break;
                }
                case BCD: {
                    fourBar.update(FourBarAngle.BCD, expectedBCD);
                    break;
                }
                case CDA: {
                    fourBar.update(FourBarAngle.CDA, expectedCDA);
                }
            }
            Assertions.assertEquals((double)expectedAC, (double)fourBar.getDiagonalAC().getLength(), (double)1.0E-9, (String)("Iteration " + iteration));
            Assertions.assertEquals((double)expectedBD, (double)fourBar.getDiagonalBD().getLength(), (double)1.0E-9, (String)("Iteration " + iteration));
            Assertions.assertEquals((double)expectedDAB, (double)vertexA.getAngle(), (double)1.0E-9, (String)("Iteration " + iteration + ", error: " + Math.abs(expectedDAB - vertexA.getAngle())));
            Assertions.assertEquals((double)expectedABC, (double)vertexB.getAngle(), (double)1.0E-9, (String)("Iteration " + iteration + ", error: " + Math.abs(expectedABC - vertexB.getAngle())));
            Assertions.assertEquals((double)expectedBCD, (double)vertexC.getAngle(), (double)1.0E-9, (String)("Iteration " + iteration + ", error: " + Math.abs(expectedBCD - vertexC.getAngle())));
            Assertions.assertEquals((double)expectedCDA, (double)vertexD.getAngle(), (double)1.0E-9, (String)("Iteration " + iteration + ", error: " + Math.abs(expectedCDA - vertexD.getAngle())));
        }
        catch (Throwable e) {
            LogTools.error((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
            CrossFourBarTest.Viewer viewer = CrossFourBarTest.startupViewer();
            viewer.updateFOV(new Point2DReadOnly[]{A, B, C, D});
            CrossFourBarTest.draw(viewer, (Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            viewer.waitUntilClosed();
            throw e;
        }
    }

    public static boolean isClockwiseOrdered(Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DReadOnly D) {
        boolean isAConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)A, (Point2DReadOnly)D, (Point2DReadOnly)B);
        boolean isBConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)B, (Point2DReadOnly)A, (Point2DReadOnly)C);
        boolean isCConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)C, (Point2DReadOnly)B, (Point2DReadOnly)D);
        boolean isDConvex = !EuclidGeometryTools.isPoint2DOnRightSideOfLine2D((Point2DReadOnly)D, (Point2DReadOnly)C, (Point2DReadOnly)A);
        int convexCount = isAConvex ? 1 : 0;
        convexCount += isBConvex ? 1 : 0;
        convexCount += isCConvex ? 1 : 0;
        return (convexCount += isDConvex ? 1 : 0) >= 2;
    }
}

