/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;

public class WrenchTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;
    private ReferenceFrame frameA;
    private ReferenceFrame frameB;
    private ReferenceFrame frameC;

    @BeforeEach
    public void setUp() throws Exception {
        this.frameA = ReferenceFrameTools.constructARootFrame((String)"A");
        this.frameB = new ReferenceFrame("B", this.frameA){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.setRotationEulerAndZeroTranslation(1.0, 2.0, 3.0);
                RigidBodyTransform translation = new RigidBodyTransform();
                translation.getTranslation().set((Tuple3DReadOnly)new Vector3D(3.0, 4.0, 5.0));
                transformToParent.multiply((RigidBodyTransformReadOnly)translation);
            }
        };
        this.frameC = new ReferenceFrame("C", this.frameB){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.setRotationEulerAndZeroTranslation(1.0, 2.0, 3.0);
                RigidBodyTransform translation = new RigidBodyTransform();
                translation.getTranslation().set((Tuple3DReadOnly)new Vector3D(3.0, 4.0, 5.0));
                transformToParent.multiply((RigidBodyTransformReadOnly)translation);
            }
        };
        this.frameB.update();
        this.frameC.update();
    }

    @Test
    public void testApplyInverseTransform() {
        Random random = new Random(325456L);
        for (int i = 0; i < 1000; ++i) {
            Wrench expected = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)this.frameA, (ReferenceFrame)this.frameA);
            RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Wrench actual = new Wrench((WrenchReadOnly)expected);
            actual.applyTransform((RigidBodyTransformReadOnly)randomTransform);
            actual.applyInverseTransform((RigidBodyTransformReadOnly)randomTransform);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)expected, (WrenchReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testChangeExpressedInWhatReferenceFrame() {
        double epsilon = 1.0E-10;
        Random random = new Random(102L);
        int nTests = 10;
        for (int i = 0; i < nTests; ++i) {
            Vector3D angularVelocity = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            Vector3D linearVelocity = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            Twist twist = new Twist(this.frameC, this.frameA, this.frameA, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
            Vector3D torque = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            Vector3D force = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            Wrench wrench = new Wrench(this.frameC, this.frameA, (Vector3DReadOnly)force, (Vector3DReadOnly)torque);
            double power1 = twist.dot((WrenchReadOnly)wrench);
            twist.changeFrame(this.frameB);
            wrench.changeFrame(this.frameB);
            double power2 = twist.dot((WrenchReadOnly)wrench);
            Assertions.assertEquals((double)power1, (double)power2, (double)epsilon);
        }
    }

    @Test
    public void testDefaultConstructor() {
        Wrench wrench = new Wrench();
        Assertions.assertNull((Object)wrench.getBodyFrame());
        Assertions.assertNull((Object)wrench.getReferenceFrame());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(), (Tuple3DReadOnly)wrench.getAngularPart(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(), (Tuple3DReadOnly)wrench.getLinearPart(), (double)0.0);
    }

    @Test
    public void testConstructUsingMatrix() {
        Random random = new Random(167L);
        DMatrixRMaj matrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random);
        Wrench wrench = new Wrench(this.frameA, this.frameB, (DMatrix)matrix);
        DMatrixRMaj matrixBack = new DMatrixRMaj(6, 1);
        wrench.get((DMatrix)matrixBack);
        EjmlUnitTests.assertEquals((DMatrix)matrix, (DMatrix)matrixBack, (double)0.0);
        Vector3D torque = new Vector3D();
        Vector3D force = new Vector3D();
        torque.set((DMatrix)matrix);
        force.set(3, (DMatrix)matrix);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)torque, (Tuple3DReadOnly)wrench.getAngularPart(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)force, (Tuple3DReadOnly)wrench.getLinearPart(), (double)0.0);
    }

    @Test
    public void testConstructUsingMatrixTooSmall() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Random random = new Random(12342L);
            DMatrixRMaj matrix = RandomMatrices_DDRM.rectangle((int)5, (int)1, (Random)random);
            new Wrench(this.frameA, this.frameB, (DMatrix)matrix);
        });
    }

    @Test
    public void testConstructUsingDoubleArray() {
        Random random = new Random(1234L);
        int vectorDimension = 3;
        double[] angularArray = new double[vectorDimension];
        double[] linearArray = new double[vectorDimension];
        double[] spatialArray = new double[2 * vectorDimension];
        for (int i = 0; i < vectorDimension; ++i) {
            angularArray[i] = random.nextDouble();
            linearArray[i] = random.nextDouble();
            spatialArray[i] = angularArray[i];
            spatialArray[i + vectorDimension] = linearArray[i];
        }
        Wrench wrench = new Wrench(this.frameC, this.frameA, spatialArray);
        Assertions.assertEquals((Object)wrench.getBodyFrame(), (Object)this.frameC);
        Assertions.assertEquals((Object)wrench.getReferenceFrame(), (Object)this.frameA);
        double epsilon = 0.0;
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(angularArray), (Tuple3DReadOnly)wrench.getAngularPart(), (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(linearArray), (Tuple3DReadOnly)wrench.getLinearPart(), (double)epsilon);
    }

    @Test
    public void testConstructUsingDoubleArrayTooSmall() {
        Assertions.assertThrows(RuntimeException.class, () -> new Wrench(this.frameA, this.frameB, new double[5]));
    }

    @Test
    public void testAddNotAllowed() {
        Wrench wrench1 = new Wrench(this.frameB, this.frameA);
        Wrench wrench2 = new Wrench(this.frameC, this.frameA);
        Assertions.assertThrows(RuntimeException.class, () -> wrench1.add((WrenchReadOnly)wrench2));
    }

    @Test
    public void testAddNotAllowed2() {
        Wrench wrench1 = new Wrench(this.frameB, this.frameA);
        Wrench wrench2 = new Wrench(this.frameB, this.frameB);
        Assertions.assertThrows(RuntimeException.class, () -> wrench1.add((WrenchReadOnly)wrench2));
    }

    @Test
    public void testAdd() {
        Random random = new Random(187L);
        Wrench wrench1 = new Wrench(this.frameA, this.frameB, (DMatrix)RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random));
        Wrench wrench2 = new Wrench(this.frameA, this.frameB, (DMatrix)RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random));
        Wrench wrench3 = new Wrench((WrenchReadOnly)wrench1);
        wrench3.add((WrenchReadOnly)wrench2);
        FixedFrameVector3DBasics linearPart = wrench1.getLinearPart();
        linearPart.add((Tuple3DReadOnly)wrench2.getLinearPart());
        FixedFrameVector3DBasics angularPart = wrench1.getAngularPart();
        angularPart.add((Tuple3DReadOnly)wrench2.getAngularPart());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)wrench3.getLinearPart(), (Tuple3DReadOnly)linearPart, (double)1.0E-24);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)wrench3.getAngularPart(), (Tuple3DReadOnly)angularPart, (double)1.0E-24);
    }

    @Test
    public void testSubNotAllowed() {
        Wrench wrench1 = new Wrench(this.frameB, this.frameA);
        Wrench wrench2 = new Wrench(this.frameC, this.frameA);
        Assertions.assertThrows(RuntimeException.class, () -> wrench1.sub((WrenchReadOnly)wrench2));
    }

    @Test
    public void testSubNotAllowed2() {
        Wrench wrench1 = new Wrench(this.frameB, this.frameA);
        Wrench wrench2 = new Wrench(this.frameB, this.frameB);
        Assertions.assertThrows(RuntimeException.class, () -> wrench1.sub((WrenchReadOnly)wrench2));
    }

    @Test
    public void testSub() {
        Random random = new Random(187L);
        Wrench wrench1 = new Wrench(this.frameA, this.frameB, (DMatrix)RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random));
        Wrench wrench2 = new Wrench(this.frameA, this.frameB, (DMatrix)RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random));
        Wrench wrench3 = new Wrench((WrenchReadOnly)wrench1);
        wrench3.sub((WrenchReadOnly)wrench2);
        FixedFrameVector3DBasics linearPart = wrench1.getLinearPart();
        linearPart.sub((Tuple3DReadOnly)wrench2.getLinearPart());
        FixedFrameVector3DBasics angularPart = wrench1.getAngularPart();
        angularPart.sub((Tuple3DReadOnly)wrench2.getAngularPart());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)wrench3.getLinearPart(), (Tuple3DReadOnly)linearPart, (double)1.0E-24);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)wrench3.getAngularPart(), (Tuple3DReadOnly)angularPart, (double)1.0E-24);
    }

    @Test
    public void testCheckAndSetNotAllowed1() {
        Wrench wrench1 = new Wrench(this.frameA, this.frameB);
        Wrench wrench2 = new Wrench(this.frameA, this.frameC);
        Assertions.assertThrows(RuntimeException.class, () -> wrench2.set(wrench1));
    }

    @Test
    public void testCheckAndSetNotAllowed2() {
        Wrench wrench1 = new Wrench(this.frameA, this.frameB);
        Wrench wrench2 = new Wrench(this.frameC, this.frameB);
        Assertions.assertThrows(RuntimeException.class, () -> wrench2.set(wrench1));
    }

    @Test
    public void testDotProduct() {
        WrenchTest.testDotProduct(this.frameA, this.frameB, this.frameC);
    }

    @Test
    public void testDotProductNotAllowed1() {
        Assertions.assertThrows(RuntimeException.class, () -> WrenchTest.testDotProductNotAllowed1(this.frameA, this.frameB, this.frameC));
    }

    @Test
    public void testDotProductNotAllowed2() {
        Assertions.assertThrows(RuntimeException.class, () -> WrenchTest.testDotProductNotAllowed2(this.frameA, this.frameB, this.frameC));
    }

    public static void testDotProduct(ReferenceFrame frameA, ReferenceFrame frameB, ReferenceFrame frameC) {
        Random random = new Random(187L);
        DMatrixRMaj twistMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random);
        DMatrixRMaj wrenchMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random);
        Twist twist = new Twist(frameA, frameB, frameC, (DMatrix)twistMatrix);
        Wrench wrench = new Wrench(frameA, frameC, (DMatrix)wrenchMatrix);
        DMatrixRMaj c = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)twistMatrix, (DMatrix1Row)wrenchMatrix, (DMatrix1Row)c);
        Assertions.assertEquals((double)c.get(0, 0), (double)wrench.dot((TwistReadOnly)twist), (double)1.0E-12);
    }

    public static void testDotProductNotAllowed1(ReferenceFrame frameA, ReferenceFrame frameB, ReferenceFrame frameC) {
        Wrench wrench = null;
        Twist twist = null;
        try {
            wrench = new Wrench(frameA, frameB);
            twist = new Twist(frameA, frameB, frameC);
        }
        catch (RuntimeException e) {
            Assertions.fail();
        }
        wrench.dot(twist);
    }

    public static void testDotProductNotAllowed2(ReferenceFrame frameA, ReferenceFrame frameB, ReferenceFrame frameC) {
        Wrench wrench = null;
        Twist twist = null;
        try {
            wrench = new Wrench(frameB, frameB);
            twist = new Twist(frameA, frameB, frameB);
        }
        catch (RuntimeException e) {
            Assertions.fail();
        }
        wrench.dot(twist);
    }

    @Test
    public void testSetToZero() {
        Random random = new Random(71243L);
        Wrench wrench = new Wrench(this.frameA, this.frameB, (DMatrix)RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random));
        wrench.setToZero(this.frameC, this.frameA);
        Assertions.assertEquals((Object)this.frameC, (Object)wrench.getBodyFrame());
        Assertions.assertEquals((Object)this.frameA, (Object)wrench.getReferenceFrame());
        DMatrixRMaj matrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)random);
        double epsilon = 1.0E-12;
        Assertions.assertTrue((NormOps_DDRM.normP2((DMatrixRMaj)matrix) > epsilon ? 1 : 0) != 0);
        wrench.get((DMatrix)matrix);
        Assertions.assertTrue((NormOps_DDRM.normP2((DMatrixRMaj)matrix) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAngularPartAt() {
        Random random = new Random(4788L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame frameAtObserverPosition = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Wrench wrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            FramePoint3D observerPosition = new FramePoint3D(frameAtObserverPosition);
            observerPosition.changeFrame(expressedInFrame);
            FrameVector3D actualAngularPart = new FrameVector3D();
            wrench.getAngularPartAt((FramePoint3DReadOnly)observerPosition, (FrameVector3DBasics)actualAngularPart);
            FrameVector3D expectedAngularPart = new FrameVector3D();
            wrench.changeFrame(frameAtObserverPosition);
            expectedAngularPart.setIncludingFrame((FrameTuple3DReadOnly)wrench.getAngularPart());
            expectedAngularPart.changeFrame(expressedInFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expectedAngularPart, (FrameTuple3DReadOnly)actualAngularPart, (double)1.0E-12);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> wrench.getAngularPartAt((FramePoint3DReadOnly)new FramePoint3D(EuclidFrameRandomTools.nextReferenceFrame((Random)random)), (FrameVector3DBasics)new FrameVector3D()));
        }
    }
}

