/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.controller;

import java.util.ArrayList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.robotEnvironmentAwareness.communication.LidarImageFusionAPI;
import us.ihmc.robotEnvironmentAwareness.fusion.objectDetection.ObjectType;

public class ObjectDetectionAnchorPaneController {
    private JavaFXMessager messager;
    private static final String defaultHostAddress = "10.100.3.157";
    @FXML
    private TextField serverADD;
    @FXML
    private Button btnConnect;
    @FXML
    private Button btnObjectDetection;
    @FXML
    private Button btnClear;
    @FXML
    private CheckBox cboxDoor;
    @FXML
    private CheckBox cboxDoorHandle;
    @FXML
    private CheckBox cboxCup;
    @FXML
    private CheckBox cboxhuman;

    public void initialize(SharedMemoryJavaFXMessager messager) {
        this.messager = messager;
        this.serverADD.setText(defaultHostAddress);
        this.cboxDoor.setSelected(true);
        this.cboxDoorHandle.setSelected(true);
    }

    @FXML
    public void connect() {
        this.messager.submitMessage(LidarImageFusionAPI.ObjectDetectionModuleAddress, (Object)this.serverADD.getText());
        this.messager.submitMessage(LidarImageFusionAPI.RequestSocketConnection, (Object)true);
    }

    @FXML
    public void clear() {
        this.messager.submitMessage(LidarImageFusionAPI.ClearObjects, (Object)true);
    }

    @FXML
    public void requestObjectDetection() {
        ArrayList<ObjectType> selectedTypes = new ArrayList<ObjectType>();
        if (this.cboxDoor.isSelected()) {
            selectedTypes.add(ObjectType.Door);
        }
        if (this.cboxDoorHandle.isSelected()) {
            selectedTypes.add(ObjectType.DoorHandle);
        }
        if (this.cboxCup.isSelected()) {
            selectedTypes.add(ObjectType.Cup);
        }
        if (this.cboxhuman.isSelected()) {
            selectedTypes.add(ObjectType.Human);
        }
        this.messager.submitMessage(LidarImageFusionAPI.SelectedObjecTypes, selectedTypes);
        this.messager.submitMessage(LidarImageFusionAPI.RequestObjectDetection, (Object)true);
    }
}

