/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.data;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;

public class SegmentationRawData {
    public static final int DEFAULT_SEGMENT_ID = -1;
    private int id = -1;
    private final int imageSegmentLabel;
    private final TIntArrayList adjacentSegmentLabels = new TIntArrayList();
    private final List<Point3D> points = new ArrayList<Point3D>();
    private final Point2D segmentCenterInImage = new Point2D();
    private final Point3D center = new Point3D();
    private final Vector3D normal = new Vector3D();
    private final Vector3D standardDeviation = new Vector3D();
    private final PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
    private boolean isSparse = true;
    private static final boolean useAdjacentScore = true;
    private static final int numberOfAdjacentPixels = 10;
    private final TIntArrayList adjacentScore = new TIntArrayList();

    public SegmentationRawData(int labelID) {
        this.imageSegmentLabel = labelID;
    }

    public boolean contains(int otherLabel) {
        for (int i = 0; i < this.adjacentSegmentLabels.size(); ++i) {
            if (this.adjacentSegmentLabels.get(i) != otherLabel) continue;
            this.adjacentScore.replace(i, this.adjacentScore.get(i) + 1);
            return true;
        }
        return false;
    }

    public void addAdjacentSegmentLabel(int otherLabel) {
        this.adjacentSegmentLabels.add(otherLabel);
        this.adjacentScore.add(1);
    }

    public void addPoint(Point3D point) {
        this.points.add(point);
    }

    public void filteringFlyingPoints(double threshold, int neighborsThreshold) {
        ArrayList<Point3D> filteredPoints = new ArrayList<Point3D>();
        for (Point3D point : this.points) {
            double closestDistance = Double.POSITIVE_INFINITY;
            int numberOfNeighbors = 0;
            for (Point3D otherPoint : this.points) {
                double distance = point.distance((Point3DReadOnly)otherPoint);
                if (distance < closestDistance && point != otherPoint) {
                    closestDistance = distance;
                }
                if (!(distance < threshold)) continue;
                ++numberOfNeighbors;
            }
            if (!(closestDistance < threshold) || numberOfNeighbors <= neighborsThreshold) continue;
            filteredPoints.add(point);
        }
        this.points.clear();
        this.points.addAll(filteredPoints);
    }

    public void update() {
        TIntArrayList newAdjacentSegmentLabels = new TIntArrayList();
        TIntArrayList newAdjacentScore = new TIntArrayList();
        for (int i = 0; i < this.adjacentSegmentLabels.size(); ++i) {
            if (this.adjacentScore.get(i) <= 10) continue;
            newAdjacentSegmentLabels.add(this.adjacentSegmentLabels.get(i));
            newAdjacentScore.add(this.adjacentScore.get(i));
        }
        this.adjacentSegmentLabels.clear();
        this.adjacentSegmentLabels.addAll((TIntCollection)newAdjacentSegmentLabels);
        this.adjacentScore.clear();
        this.adjacentScore.addAll((TIntCollection)newAdjacentScore);
        this.pca.clear();
        this.points.stream().forEach(point -> this.pca.addPoint(point.getX(), point.getY(), point.getZ()));
        this.pca.compute();
        this.pca.getMean(this.center);
        this.pca.getThirdVector(this.normal);
        if (this.normal.getZ() < 0.0) {
            this.normal.negate();
        }
        this.pca.getStandardDeviation(this.standardDeviation);
    }

    public void updateSparsity(double threshold) {
        this.isSparse = this.standardDeviation.getZ() > threshold;
    }

    public void filteringCentrality(double radius, double threshold) {
        if (!this.isSparse) {
            int numberOfInliers = 0;
            for (Point3D point : this.points) {
                double distance = this.center.distance((Point3DReadOnly)point);
                if (!(distance < radius)) continue;
                ++numberOfInliers;
            }
            if ((double)numberOfInliers < threshold * this.getWeight()) {
                this.isSparse = true;
            }
        }
    }

    public void filteringEllipticity(double minLength, double threshold) {
        if (!this.isSparse) {
            double lengthPrimary = this.standardDeviation.getX();
            double lengthSecondary = this.standardDeviation.getY();
            if (lengthSecondary < minLength || lengthSecondary > lengthPrimary * threshold) {
                this.isSparse = true;
            }
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSegmentCenter(int u, int v) {
        this.segmentCenterInImage.set((double)u, (double)v);
    }

    public Point2DReadOnly getSegmentCenter() {
        return this.segmentCenterInImage;
    }

    public boolean isSparse() {
        return this.isSparse;
    }

    public int[] getAdjacentSegmentLabels() {
        return this.adjacentSegmentLabels.toArray();
    }

    public double getWeight() {
        return this.points.size();
    }

    public Point3D getCenter() {
        return this.center;
    }

    public Vector3D getNormal() {
        return this.normal;
    }

    public int getId() {
        return this.id;
    }

    public int getImageSegmentLabel() {
        return this.imageSegmentLabel;
    }

    public List<Point3D> getPoints() {
        return this.points;
    }
}

