/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import perception_msgs.msg.dds.Image32;
import sensor_msgs.msg.dds.RegionOfInterest;

public class ImageVisualizationHelper {
    private static final float fontSize = 30.0f;
    private static final int defaultThickness = 5;

    public static BufferedImage convertImageMessageToBufferedImage(Image32 imageMessage) {
        int width = imageMessage.getWidth();
        int height = imageMessage.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        int pixelIndex = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                bufferedImage.setRGB(j, i, imageMessage.getRgbdata().get(pixelIndex));
                ++pixelIndex;
            }
        }
        return bufferedImage;
    }

    public static void drawROIOnImage(BufferedImage image, RegionOfInterest roiToDraw, Color color) {
        ImageVisualizationHelper.drawROIOnImage(image, roiToDraw, color, 5, null);
    }

    public static void drawROIOnImage(BufferedImage image, RegionOfInterest roiToDraw, Color color, int thickness) {
        ImageVisualizationHelper.drawROIOnImage(image, roiToDraw, color, thickness, null);
    }

    public static void drawROIOnImage(BufferedImage image, RegionOfInterest roiToDraw, Color color, String text) {
        ImageVisualizationHelper.drawROIOnImage(image, roiToDraw, color, 5, text);
    }

    public static void drawROIOnImage(BufferedImage image, RegionOfInterest roiToDraw, Color color, int thickness, String text) {
        int j;
        int i;
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int topLimit = (int)Math.max(roiToDraw.getYOffset() - (long)thickness, 0L);
        int bottomLimit = (int)Math.min(roiToDraw.getYOffset() + roiToDraw.getHeight() + (long)thickness, (long)height);
        int leftLimit = (int)Math.max(roiToDraw.getXOffset() - (long)thickness, 0L);
        int rightLimit = (int)Math.min(roiToDraw.getXOffset() + roiToDraw.getWidth() + (long)thickness, (long)width);
        for (i = leftLimit; i < rightLimit; ++i) {
            for (j = topLimit; j < topLimit + thickness; ++j) {
                image.setRGB(i, j, color.getRGB());
            }
            for (j = bottomLimit; j > bottomLimit - thickness; --j) {
                image.setRGB(i, j, color.getRGB());
            }
        }
        for (i = topLimit; i < bottomLimit; ++i) {
            for (j = leftLimit; j < leftLimit + thickness; ++j) {
                image.setRGB(j, i, color.getRGB());
            }
            for (j = rightLimit; j > rightLimit - thickness; --j) {
                image.setRGB(j, i, color.getRGB());
            }
        }
        if (text != null) {
            Graphics graphics = image.getGraphics();
            graphics.setFont(graphics.getFont().deriveFont(30.0f));
            graphics.setColor(color);
            if (rightLimit != width) {
                graphics.drawString(text, rightLimit, bottomLimit);
            } else {
                graphics.drawString(text, leftLimit, bottomLimit);
            }
            graphics.dispose();
        }
    }
}

