/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.fusion.tools;

import boofcv.struct.calib.CameraPinholeBrown;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.robotEnvironmentAwareness.fusion.MultisenseInformation;

public class PointCloudProjectionHelper {
    private static final int defaultOffsetU = 11;
    private static final int defaultOffsetV = 0;
    public static final CameraPinholeBrown multisenseOnCartIntrinsicParameters = MultisenseInformation.CART.getIntrinsicParameters();

    public static void projectMultisensePointCloudOnImage(Point3DBasics point, Point2DBasics pixel, CameraPinholeBrown param) {
        int[] pixelArray = new int[2];
        pixelArray = PointCloudProjectionHelper.projectMultisensePointCloudOnImage(point, param);
        pixel.set((double)pixelArray[0], (double)pixelArray[1]);
    }

    public static void projectMultisensePointCloudOnImage(Point3DBasics point, Point2DBasics pixel) {
        PointCloudProjectionHelper.projectMultisensePointCloudOnImage(point, pixel, multisenseOnCartIntrinsicParameters, 11, 0);
    }

    public static void projectMultisensePointCloudOnImage(Point3DBasics point, Point2DBasics pixel, int offsetU, int offsetV) {
        PointCloudProjectionHelper.projectMultisensePointCloudOnImage(point, pixel, multisenseOnCartIntrinsicParameters, offsetU, offsetV);
    }

    public static void projectMultisensePointCloudOnImage(Point3DBasics point, Point2DBasics pixel, CameraPinholeBrown param, int offsetU, int offsetV) {
        PointCloudProjectionHelper.projectMultisensePointCloudOnImage(point, pixel, param);
        pixel.add((double)offsetU, (double)offsetV);
    }

    public static int[] projectMultisensePointCloudOnImage(Point3DBasics point, CameraPinholeBrown param, Point3DBasics cameraPosition, QuaternionBasics cameraOrientation) {
        Point3D pointToCamera = new Point3D((Tuple3DReadOnly)point);
        RigidBodyTransform transformWorldToCamera = new RigidBodyTransform((Orientation3DReadOnly)cameraOrientation, (Tuple3DReadOnly)cameraPosition);
        pointToCamera.applyInverseTransform((Transform)transformWorldToCamera);
        return PointCloudProjectionHelper.projectMultisensePointCloudOnImage((Point3DBasics)pointToCamera, param);
    }

    public static int[] projectMultisensePointCloudOnImage(Point3DBasics point, CameraPinholeBrown param) {
        double fx = param.getFx();
        double fy = param.getFy();
        double cx = param.getCx();
        double cy = param.getCy();
        double cameraX = -point.getY();
        double cameraY = -point.getZ();
        double cameraZ = point.getX();
        double normX = cameraX / cameraZ;
        double normY = cameraY / cameraZ;
        int u = (int)(fx * normX + cx);
        int v = (int)(fy * normY + cy);
        int[] pixel = new int[]{u, v};
        return pixel;
    }

    static {
        multisenseOnCartIntrinsicParameters.setFx(566.8350830078125);
        multisenseOnCartIntrinsicParameters.setFy(566.8350830078125);
        multisenseOnCartIntrinsicParameters.setCx(505.5);
        multisenseOnCartIntrinsicParameters.setCy(260.5);
    }
}

