/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHull;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCutModel;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullCutPoint;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.geometry.ConvexPolygonCutResult;
import us.ihmc.robotics.geometry.ConvexPolygonTools;

public class ConcaveHullCutter {
    public static final int MIN_VERTICES_TO_HAVE_CONCAVITY = 4;

    public static List<ConcaveHull> cutPolygonToLeftOfLine(ConcaveHull concaveHullToCrop, Line2DReadOnly cuttingLine) {
        Vector2D upDirection = new Vector2D((Tuple2DReadOnly)cuttingLine.getDirection());
        upDirection.normalize();
        upDirection.set(-upDirection.getY(), upDirection.getX());
        ConcaveHull filteredConcaveHullToCrop = new ConcaveHull();
        for (Point2D point2D : concaveHullToCrop) {
            Point2D filteredVertex = new Point2D((Tuple2DReadOnly)point2D);
            double distance = EuclidGeometryTools.signedDistanceFromPoint2DToLine2D((Point2DReadOnly)point2D, (Point2DReadOnly)cuttingLine.getPoint(), (Vector2DReadOnly)cuttingLine.getDirection());
            if (Math.abs(distance) < 1.0E-5) {
                Vector2D moveBy = new Vector2D();
                if (distance >= 0.0) {
                    moveBy.set(upDirection);
                } else {
                    moveBy.set(-upDirection.getX(), -upDirection.getY());
                }
                moveBy.scale(1.0E-5);
                filteredVertex.add((Tuple2DReadOnly)moveBy);
            }
            filteredConcaveHullToCrop.addVertex(filteredVertex);
        }
        ArrayList<ConcaveHull> resultingConcaveHulls = new ArrayList<ConcaveHull>();
        if (filteredConcaveHullToCrop.getNumberOfVertices() < 4) {
            ConvexPolygon2D convexPolygonToCrop = new ConvexPolygon2D();
            for (Point2D concaveHullVertex : filteredConcaveHullToCrop.getConcaveHullVertices()) {
                convexPolygonToCrop.addVertex((Point2DReadOnly)concaveHullVertex);
            }
            convexPolygonToCrop.update();
            ConvexPolygon2D croppedPolygonToPack = new ConvexPolygon2D();
            ConvexPolygonCutResult result = ConvexPolygonTools.cutPolygonToLeftOfLine((ConvexPolygon2DReadOnly)convexPolygonToCrop, (Line2DReadOnly)cuttingLine, (ConvexPolygon2DBasics)croppedPolygonToPack);
            if (result != ConvexPolygonCutResult.REMOVE_ALL) {
                ConcaveHull concaveHullToReturn = new ConcaveHull(croppedPolygonToPack.getVertexBufferView());
                resultingConcaveHulls.add(concaveHullToReturn);
            }
            return resultingConcaveHulls;
        }
        if (filteredConcaveHullToCrop.getNumberOfVertices() < 4) {
            throw new RuntimeException("This polygon must be convex and shouldn't have gotten this far.");
        }
        HashMap<Integer, Point2D> intersections = new HashMap<Integer, Point2D>();
        List<Point2D> concaveHullVertices = filteredConcaveHullToCrop.getConcaveHullVertices();
        for (int i = 0; i < concaveHullVertices.size(); ++i) {
            int nextVertex = EuclidGeometryPolygonTools.next((int)i, (int)concaveHullVertices.size());
            double lineSegmentDirectionX = concaveHullVertices.get(nextVertex).getX() - concaveHullVertices.get(i).getX();
            double lineSegmentDirectionY = concaveHullVertices.get(nextVertex).getY() - concaveHullVertices.get(i).getY();
            double percentage = EuclidCoreMissingTools.percentageOfIntersectionBetweenTwoLine2DsInfCase((double)concaveHullVertices.get(i).getX(), (double)concaveHullVertices.get(i).getY(), (double)lineSegmentDirectionX, (double)lineSegmentDirectionY, (double)cuttingLine.getPoint().getX(), (double)cuttingLine.getPoint().getY(), (double)cuttingLine.getDirection().getX(), (double)cuttingLine.getDirection().getY());
            if (percentage == Double.NaN || percentage == Double.POSITIVE_INFINITY || !(percentage > 0.0) || !(percentage < 1.0)) continue;
            Point2D intersection = new Point2D();
            intersection.interpolate((Tuple2DReadOnly)concaveHullVertices.get(i), (Tuple2DReadOnly)concaveHullVertices.get(nextVertex), percentage);
            intersection.setX(MathTools.roundToPrecision((double)intersection.getX(), (double)1.0E-6));
            intersection.setY(MathTools.roundToPrecision((double)intersection.getY(), (double)1.0E-6));
            intersections.put(nextVertex, intersection);
        }
        boolean vertex0IsAbove = EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)filteredConcaveHullToCrop.getVertex(0), (Point2DReadOnly)cuttingLine.getPoint(), (Vector2DReadOnly)upDirection);
        LogTools.trace((String)"Intersection count: {} vertex(0) is above line: {}", (Object)intersections.size(), (Object)vertex0IsAbove);
        if (intersections.size() == 0) {
            if (vertex0IsAbove) {
                resultingConcaveHulls.add(new ConcaveHull(filteredConcaveHullToCrop));
                return resultingConcaveHulls;
            }
            return resultingConcaveHulls;
        }
        if (intersections.size() == 1) {
            if (filteredConcaveHullToCrop.getNumberOfVertices() > 1) {
                boolean isOnOrAboveTwo = EuclidGeometryTools.isPoint2DInFrontOfRay2D((Point2DReadOnly)filteredConcaveHullToCrop.getVertex(1), (Point2DReadOnly)cuttingLine.getPoint(), (Vector2DReadOnly)upDirection);
                if (vertex0IsAbove && isOnOrAboveTwo) {
                    resultingConcaveHulls.add(new ConcaveHull(filteredConcaveHullToCrop));
                    return resultingConcaveHulls;
                }
                return resultingConcaveHulls;
            }
            return resultingConcaveHulls;
        }
        ConcaveHullCutModel model = new ConcaveHullCutModel(concaveHullVertices, cuttingLine, (Vector2DReadOnly)upDirection, intersections);
        while (!model.allIntersectionsVisited()) {
            int firstUnvisitedVertex = model.indexOfFirstUnvisitedIntersection();
            ConcaveHull currentResultingConcaveHull = new ConcaveHull();
            currentResultingConcaveHull.addVertex(new Point2D(((ConcaveHullCutPoint)model.getPoints().get(firstUnvisitedVertex)).getPoint()));
            ((ConcaveHullCutPoint)model.getPoints().get(firstUnvisitedVertex)).setVisited(true);
            int travellingIndex = firstUnvisitedVertex;
            int ALONG_HULL = 5;
            int TRAVERSE_CUT_LINE = 6;
            int drawState = 5;
            do {
                if (drawState == 5) {
                    travellingIndex = model.getPoints().getNextIndex(travellingIndex);
                    boolean nextPointIsIntersection = ((ConcaveHullCutPoint)model.getPoints().get(travellingIndex)).isIntersection();
                    if (nextPointIsIntersection) {
                        drawState = 6;
                    }
                } else {
                    travellingIndex = model.indexOfIntersectionToLeft(travellingIndex);
                    drawState = 5;
                }
                if (travellingIndex == firstUnvisitedVertex) continue;
                currentResultingConcaveHull.addVertex(new Point2D(((ConcaveHullCutPoint)model.getPoints().get(travellingIndex)).getPoint()));
                ((ConcaveHullCutPoint)model.getPoints().get(travellingIndex)).setVisited(true);
            } while (travellingIndex != firstUnvisitedVertex);
            resultingConcaveHulls.add(currentResultingConcaveHull);
        }
        return resultingConcaveHulls;
    }
}

