/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.geometry;

import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;

public class PointMean
extends Point3D {
    private int sampleSize = 0;

    public void update(Tuple3DBasics tuple) {
        this.update(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public void update(Tuple3DBasics tuple, int updateSize) {
        this.update(tuple.getX(), tuple.getY(), tuple.getZ(), updateSize);
    }

    public void update(double x, double y, double z) {
        this.update(x, y, z, 1);
    }

    public void update(double x, double y, double z, int updateSize) {
        this.sampleSize += updateSize;
        double nInv = (double)updateSize / (double)this.sampleSize;
        this.setX(this.getX() + (x - this.getX()) * nInv);
        this.setY(this.getY() + (y - this.getY()) * nInv);
        this.setZ(this.getZ() + (z - this.getZ()) * nInv);
    }

    public void clear() {
        this.sampleSize = 0;
        this.set(0.0, 0.0, 0.0);
    }

    public int getNumberOfSamples() {
        return this.sampleSize;
    }
}

