/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.perceptionSuite;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import perception_msgs.msg.dds.NormalEstimationParametersMessage;
import perception_msgs.msg.dds.OcTreeKeyListMessage;
import perception_msgs.msg.dds.PlanarRegionSegmentationParametersMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import perception_msgs.msg.dds.PolygonizerParametersMessage;
import perception_msgs.msg.dds.REASensorDataFilterParametersMessage;
import perception_msgs.msg.dds.REAStateRequestMessage;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotEnvironmentAwareness.communication.REAModuleAPI;
import us.ihmc.robotEnvironmentAwareness.communication.converters.OcTreeMessageConverter;
import us.ihmc.robotEnvironmentAwareness.communication.converters.REAParametersMessageHelper;
import us.ihmc.robotEnvironmentAwareness.ros.REAModuleROS2Subscription;
import us.ihmc.robotEnvironmentAwareness.ros.REASourceType;
import us.ihmc.robotEnvironmentAwareness.updaters.REANetworkProvider;
import us.ihmc.robotEnvironmentAwareness.updaters.RegionFeaturesProvider;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;

public class RealSenseREANetworkProvider
implements REANetworkProvider {
    private final IHMCROS2Publisher<PlanarRegionsListMessage> stereoRegionPublisher;
    private final IHMCROS2Publisher<OcTreeKeyListMessage> ocTreePublisher;
    private final ROS2Node ros2Node;
    private final ROS2Topic inputTopic;
    private PlanarRegionsListMessage lastPlanarRegionsListMessage;

    public RealSenseREANetworkProvider(ROS2Topic inputTopic, ROS2Topic stereoOutputTopic) {
        this(ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"REA_module"), inputTopic, stereoOutputTopic);
    }

    public RealSenseREANetworkProvider(ROS2Node ros2Node, ROS2Topic inputTopic, ROS2Topic stereoOutputTopic) {
        this.ros2Node = ros2Node;
        this.inputTopic = inputTopic;
        this.stereoRegionPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)stereoOutputTopic);
        this.ocTreePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, OcTreeKeyListMessage.class, (ROS2Topic)stereoOutputTopic);
    }

    @Override
    public void registerMessager(Messager messager) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, NormalEstimationParametersMessage.class, (ROS2Topic)this.inputTopic, s -> messager.submitMessage(REAModuleAPI.NormalEstimationParameters, (Object)REAParametersMessageHelper.convertFromMessage((NormalEstimationParametersMessage)s.takeNextData())));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, PlanarRegionSegmentationParametersMessage.class, (ROS2Topic)this.inputTopic, s -> messager.submitMessage(REAModuleAPI.PlanarRegionsSegmentationParameters, (Object)REAParametersMessageHelper.convertFromMessage((PlanarRegionSegmentationParametersMessage)s.takeNextData())));
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, PolygonizerParametersMessage.class, (ROS2Topic)this.inputTopic, s -> messager.submitMessage(REAModuleAPI.PlanarRegionsPolygonizerParameters, (Object)((PolygonizerParametersMessage)s.takeNextData())));
    }

    @Override
    public void update(RegionFeaturesProvider regionFeaturesProvider, boolean planarRegionsHaveBeenUpdated, NormalOcTree ocTree) {
        if (regionFeaturesProvider.getPlanarRegionsList() != null && !regionFeaturesProvider.getPlanarRegionsList().isEmpty()) {
            if (planarRegionsHaveBeenUpdated) {
                this.lastPlanarRegionsListMessage = PlanarRegionMessageConverter.convertToPlanarRegionsListMessage((PlanarRegionsList)regionFeaturesProvider.getPlanarRegionsList());
            }
            this.stereoRegionPublisher.publish((Object)this.lastPlanarRegionsListMessage);
        }
        if (ocTree != null && ocTree.getRoot() != null) {
            OcTreeKeyListMessage ocTreeMessage = OcTreeMessageConverter.createOcTreeDataMessage(ocTree);
            this.ocTreePublisher.publish((Object)ocTreeMessage);
        }
    }

    @Override
    public void publishCurrentState() {
    }

    @Override
    public void registerStereoVisionPointCloudHandler(NewMessageListener<StereoVisionPointCloudMessage> stereoVisionPointCloudHandler) {
        ROS2Tools.createCallbackSubscription((ROS2NodeInterface)this.ros2Node, (ROS2Topic)ROS2Tools.D435_POINT_CLOUD, stereoVisionPointCloudHandler);
    }

    @Override
    public void registerStereoVisionPointCloudHandler(Messager messager, NewMessageListener<StereoVisionPointCloudMessage> stereoVisionPointCloudHandler) {
        new REAModuleROS2Subscription<StereoVisionPointCloudMessage>((ROS2NodeInterface)this.ros2Node, messager, REASourceType.STEREO_POINT_CLOUD, StereoVisionPointCloudMessage.class, stereoVisionPointCloudHandler, ROS2QosProfile.BEST_EFFORT());
    }

    @Override
    public void registerCustomRegionsHandler(NewMessageListener<PlanarRegionsListMessage> customRegionsHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.subscriberCustomRegionsTopicName, customRegionsHandler);
    }

    @Override
    public void registerREAStateRequestHandler(NewMessageListener<REAStateRequestMessage> requestHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, REAStateRequestMessage.class, (ROS2Topic)this.inputTopic, requestHandler);
    }

    @Override
    public void registerREASensorDataFilterParametersHandler(NewMessageListener<REASensorDataFilterParametersMessage> parametersHandler) {
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, REASensorDataFilterParametersMessage.class, (ROS2Topic)this.inputTopic, parametersHandler);
    }

    @Override
    public void stop() {
        this.ros2Node.destroy();
    }
}

