/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.Scanner;
import us.ihmc.jOctoMap.tools.ScannerTools;

public class CustomRegionMergeParameters {
    private static final double DEFAULT_SEARCH_RADIUS = 0.22;
    private static final double DEFAULT_MAX_DISTANCE_FROM_PLANE = 0.05;
    private static final double DEFAULT_MAX_ANGLE_FROM_PLANE = Math.toRadians(10.0);
    private double searchRadius;
    private double maxDistanceFromPlane;
    private double maxAngleFromPlane;

    public CustomRegionMergeParameters() {
        this.setDefaultParameters();
    }

    public CustomRegionMergeParameters(CustomRegionMergeParameters other) {
        this.set(other);
    }

    public void setDefaultParameters() {
        this.searchRadius = 0.22;
        this.maxDistanceFromPlane = 0.05;
        this.maxAngleFromPlane = DEFAULT_MAX_ANGLE_FROM_PLANE;
    }

    public void set(CustomRegionMergeParameters other) {
        this.searchRadius = other.searchRadius;
        this.maxDistanceFromPlane = other.maxDistanceFromPlane;
        this.maxAngleFromPlane = other.maxAngleFromPlane;
    }

    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    public void setMaxDistanceFromPlane(double maxDistanceFromPlane) {
        this.maxDistanceFromPlane = maxDistanceFromPlane;
    }

    public void setMaxAngleFromPlane(double maxAngleFromPlane) {
        this.maxAngleFromPlane = maxAngleFromPlane;
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public double getMaxDistanceFromPlane() {
        return this.maxDistanceFromPlane;
    }

    public double getMaxAngleFromPlane() {
        return this.maxAngleFromPlane;
    }

    public String toString() {
        return "search radius: " + this.searchRadius + ", max distance from plane: " + this.maxDistanceFromPlane + ", maxAngleFromPlane: " + this.maxAngleFromPlane;
    }

    public static CustomRegionMergeParameters parse(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        CustomRegionMergeParameters parameters = new CustomRegionMergeParameters();
        parameters.setSearchRadius(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getSearchRadius()));
        parameters.setMaxDistanceFromPlane(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaxDistanceFromPlane()));
        parameters.setMaxAngleFromPlane(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaxAngleFromPlane()));
        scanner.close();
        return parameters;
    }
}

