/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment1D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.planarRegion.IntersectionEstimationParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;

public class PlanarRegionIntersectionCalculator {
    public static List<LineSegment3D> computeIntersections(List<PlanarRegionSegmentationRawData> rawData, IntersectionEstimationParameters parameters) {
        ArrayList<LineSegment3D> allIntersections = new ArrayList<LineSegment3D>();
        HashMap<List<LineSegment3D>, ImmutablePair> intersectionsToRegionsMap = new HashMap<List<LineSegment3D>, ImmutablePair>();
        for (int i = 0; i < rawData.size(); ++i) {
            PlanarRegionSegmentationRawData currentRegion = rawData.get(i);
            if (currentRegion.size() < parameters.getMinRegionSize()) continue;
            for (int j = i + 1; j < rawData.size(); ++j) {
                double minIntersectionLength;
                double maxDistanceToRegion;
                List<LineSegment3D> intersectionList;
                double minRegionAngleDifference;
                Line3D intersectionLine;
                PlanarRegionSegmentationRawData currentNeighbor = rawData.get(j);
                if (currentNeighbor.size() < parameters.getMinRegionSize() || (intersectionLine = PlanarRegionIntersectionCalculator.computeIntersectionLine3d(currentRegion, currentNeighbor, minRegionAngleDifference = parameters.getMinRegionAngleDifference())) == null || (intersectionList = PlanarRegionIntersectionCalculator.findIntersectionEndPoints(currentRegion, currentNeighbor, maxDistanceToRegion = parameters.getMaxDistanceToRegion(), minIntersectionLength = parameters.getMinIntersectionLength(), intersectionLine)) == null) continue;
                allIntersections.addAll(intersectionList);
                intersectionsToRegionsMap.put(intersectionList, ImmutablePair.of((Object)currentRegion, (Object)currentNeighbor));
            }
        }
        PlanarRegionIntersectionCalculator.extendLinesToIntersection(allIntersections);
        if (parameters.isAddIntersectionsToRegions()) {
            for (Map.Entry entry : intersectionsToRegionsMap.entrySet()) {
                List intersections = (List)entry.getKey();
                PlanarRegionSegmentationRawData region1 = (PlanarRegionSegmentationRawData)((Pair)entry.getValue()).getLeft();
                PlanarRegionSegmentationRawData region2 = (PlanarRegionSegmentationRawData)((Pair)entry.getValue()).getRight();
                region1.addIntersections(intersections);
                region2.addIntersections(intersections);
            }
        }
        return allIntersections;
    }

    private static void extendLinesToIntersection(List<LineSegment3D> allIntersections) {
        Point3D closestPointOnCurrentLine = new Point3D();
        Point3D closestPointOnOtherLine = new Point3D();
        for (int i = 0; i < allIntersections.size(); ++i) {
            LineSegment3D currentIntersectionSegment = allIntersections.get(i);
            Line3D currentIntersectionLine = new Line3D((LineSegment3DReadOnly)currentIntersectionSegment);
            for (int j = i + 1; j < allIntersections.size(); ++j) {
                LineSegment3D otherIntersectionSegment = allIntersections.get(j);
                Line3D otherIntersectionLine = new Line3D((LineSegment3DReadOnly)otherIntersectionSegment);
                double distanceBetweenLines = currentIntersectionLine.closestPointsWith((Line3DReadOnly)otherIntersectionLine, (Point3DBasics)closestPointOnCurrentLine, (Point3DBasics)closestPointOnOtherLine);
                if (distanceBetweenLines > 0.05 || !(currentIntersectionSegment.distance((Point3DReadOnly)closestPointOnCurrentLine) <= 0.05) || !(otherIntersectionSegment.distance((Point3DReadOnly)closestPointOnOtherLine) <= 0.05)) continue;
                double alphaCurrent = currentIntersectionSegment.percentageAlongLineSegment((Point3DReadOnly)closestPointOnCurrentLine);
                if (alphaCurrent < 0.0) {
                    currentIntersectionSegment.getFirstEndpoint().set((Tuple3DReadOnly)closestPointOnCurrentLine);
                } else if (alphaCurrent > 1.0) {
                    currentIntersectionSegment.getSecondEndpoint().set((Tuple3DReadOnly)closestPointOnCurrentLine);
                }
                double alphaOther = otherIntersectionSegment.percentageAlongLineSegment((Point3DReadOnly)closestPointOnOtherLine);
                if (alphaOther < 0.0) {
                    otherIntersectionSegment.getFirstEndpoint().set((Tuple3DReadOnly)closestPointOnOtherLine);
                    continue;
                }
                if (!(alphaOther > 1.0)) continue;
                otherIntersectionSegment.getSecondEndpoint().set((Tuple3DReadOnly)closestPointOnOtherLine);
            }
        }
    }

    private static Line3D computeIntersectionLine3d(PlanarRegionSegmentationRawData currentRegion, PlanarRegionSegmentationRawData currentNeighbor, double minRegionAngleDifference) {
        Vector3D intersectionDirection;
        Point3D pointOnIntersection;
        Vector3D normal2;
        Point3D origin2;
        Vector3D normal1;
        Point3D origin1 = currentRegion.getOrigin();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)origin1, (Vector3DReadOnly)(normal1 = currentRegion.getNormal()), (Point3DReadOnly)(origin2 = currentNeighbor.getOrigin()), (Vector3DReadOnly)(normal2 = currentNeighbor.getNormal()), (double)minRegionAngleDifference, (Point3DBasics)(pointOnIntersection = new Point3D()), (Vector3DBasics)(intersectionDirection = new Vector3D()));
        if (!success) {
            return null;
        }
        return new Line3D((Point3DReadOnly)pointOnIntersection, (Vector3DReadOnly)intersectionDirection);
    }

    private static List<LineSegment3D> findIntersectionEndPoints(PlanarRegionSegmentationRawData currentRegion, PlanarRegionSegmentationRawData currentNeighbor, double maxDistance, double minIntersectionLength, Line3D intersectionLine) {
        List<LineSegment1D> intersectionsFromRegion1 = PlanarRegionIntersectionCalculator.findIntersectionLineSegments(currentRegion, maxDistance, minIntersectionLength, intersectionLine);
        if (intersectionsFromRegion1 == null || intersectionsFromRegion1.isEmpty()) {
            return null;
        }
        List<LineSegment1D> intersectionsFromRegion2 = PlanarRegionIntersectionCalculator.findIntersectionLineSegments(currentNeighbor, maxDistance, minIntersectionLength, intersectionLine);
        if (intersectionsFromRegion2 == null || intersectionsFromRegion2.isEmpty()) {
            return null;
        }
        ArrayList<LineSegment3D> intersections = new ArrayList<LineSegment3D>();
        for (LineSegment1D intersectionFromRegion1 : intersectionsFromRegion1) {
            for (LineSegment1D intersectionFromRegion2 : intersectionsFromRegion2) {
                LineSegment1D overlap = intersectionFromRegion1.computeOverlap(intersectionFromRegion2);
                if (overlap == null || !(overlap.length() > minIntersectionLength)) continue;
                intersections.add(overlap.toLineSegment3d((Line3DReadOnly)intersectionLine));
            }
        }
        return intersections.isEmpty() ? null : intersections;
    }

    private static List<LineSegment1D> findIntersectionLineSegments(PlanarRegionSegmentationRawData currentRegion, double maxDistance, double minIntersectionLength, Line3D intersectionLine) {
        Vector3D perpendicularToDirection = new Vector3D();
        perpendicularToDirection.cross((Tuple3DReadOnly)currentRegion.getNormal(), (Tuple3DReadOnly)intersectionLine.getDirection());
        perpendicularToDirection.normalize();
        Vector3D distance = new Vector3D();
        Point3D regionPoint = new Point3D();
        PriorityQueue<Double> points1D = new PriorityQueue<Double>();
        for (int i = 0; i < currentRegion.size(); ++i) {
            currentRegion.getPoint(i, regionPoint);
            distance.sub((Tuple3DReadOnly)regionPoint, (Tuple3DReadOnly)intersectionLine.getPoint());
            double orthogonalDistanceFromLine = Math.abs(distance.dot((Tuple3DReadOnly)perpendicularToDirection));
            if (!(orthogonalDistanceFromLine <= maxDistance)) continue;
            points1D.add(distance.dot((Tuple3DReadOnly)intersectionLine.getDirection()));
        }
        if (points1D.size() < 2) {
            return null;
        }
        ArrayList<LineSegment1D> intersectionSegments = new ArrayList<LineSegment1D>();
        double firstEndpoint = (Double)points1D.poll();
        double secondEndpoint = Double.NaN;
        double lastPoint1D = firstEndpoint;
        while (!points1D.isEmpty()) {
            double currentPoint1D = (Double)points1D.poll();
            if (Math.abs(currentPoint1D - lastPoint1D) < maxDistance) {
                secondEndpoint = currentPoint1D;
                if (points1D.isEmpty() && Math.abs(secondEndpoint - firstEndpoint) >= minIntersectionLength) {
                    intersectionSegments.add(new LineSegment1D(firstEndpoint, secondEndpoint));
                }
            } else {
                if (!Double.isNaN(secondEndpoint) || Math.abs(secondEndpoint - firstEndpoint) >= minIntersectionLength) {
                    intersectionSegments.add(new LineSegment1D(firstEndpoint, secondEndpoint));
                }
                if (points1D.size() < 2) break;
                firstEndpoint = currentPoint1D;
                secondEndpoint = Double.NaN;
            }
            lastPoint1D = currentPoint1D;
        }
        return intersectionSegments.isEmpty() ? null : intersectionSegments;
    }
}

