/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.Scanner;
import us.ihmc.jOctoMap.tools.ScannerTools;

public class PlanarRegionSegmentationParameters {
    private static final double DEFAULT_SEARCH_RADIUS = 0.05;
    private static final double DEFAULT_MAX_DISTANCE_FROM_PLANE = 0.05;
    private static final double DEFAULT_MAX_ANGLE_FROM_PLANE = Math.toRadians(10.0);
    private static final double DEFAULT_MIN_NORMAL_QUALITY = 0.005;
    private static final int DEFAULT_MIN_REGION_SIZE = 50;
    private static final double DEFAULT_MAX_STANDARD_DEVIATION = 0.015;
    private static final double DEFAULT_VOLUMIC_DENSITY = 100000.0;
    private double searchRadius;
    private double maxDistanceFromPlane;
    private double maxAngleFromPlane;
    private double minNormalQuality;
    private int minRegionSize;
    private double maxStandardDeviation;
    private double minVolumicDensity;

    public PlanarRegionSegmentationParameters() {
        this.setDefaultParameters();
    }

    public PlanarRegionSegmentationParameters(PlanarRegionSegmentationParameters other) {
        this.set(other);
    }

    public void setDefaultParameters() {
        this.searchRadius = 0.05;
        this.maxDistanceFromPlane = 0.05;
        this.maxAngleFromPlane = DEFAULT_MAX_ANGLE_FROM_PLANE;
        this.minNormalQuality = 0.005;
        this.minRegionSize = 50;
        this.maxStandardDeviation = 0.015;
        this.minVolumicDensity = 100000.0;
    }

    public void set(PlanarRegionSegmentationParameters other) {
        this.searchRadius = other.searchRadius;
        this.maxDistanceFromPlane = other.maxDistanceFromPlane;
        this.maxAngleFromPlane = other.maxAngleFromPlane;
        this.minNormalQuality = other.minNormalQuality;
        this.minRegionSize = other.minRegionSize;
        this.maxStandardDeviation = other.maxStandardDeviation;
        this.minVolumicDensity = other.minVolumicDensity;
    }

    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    public void setMaxDistanceFromPlane(double maxDistanceFromPlane) {
        this.maxDistanceFromPlane = maxDistanceFromPlane;
    }

    public void setMaxAngleFromPlane(double maxAngleFromPlane) {
        this.maxAngleFromPlane = maxAngleFromPlane;
    }

    public void setMinNormalQuality(double minNormalQuality) {
        this.minNormalQuality = minNormalQuality;
    }

    public void setMinRegionSize(int minRegionSize) {
        this.minRegionSize = minRegionSize;
    }

    public void setMaxStandardDeviation(double maxStandardDeviation) {
        this.maxStandardDeviation = maxStandardDeviation;
    }

    public void setMinVolumicDensity(double minVolumicDensity) {
        this.minVolumicDensity = minVolumicDensity;
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public double getMaxDistanceFromPlane() {
        return this.maxDistanceFromPlane;
    }

    public double getMaxAngleFromPlane() {
        return this.maxAngleFromPlane;
    }

    public double getMinNormalQuality() {
        return this.minNormalQuality;
    }

    public int getMinRegionSize() {
        return this.minRegionSize;
    }

    public double getMaxStandardDeviation() {
        return this.maxStandardDeviation;
    }

    public double getMinVolumicDensity() {
        return this.minVolumicDensity;
    }

    public String toString() {
        return "search radius: " + this.searchRadius + ", max distance from plane: " + this.maxDistanceFromPlane + ", maxAngleFromPlane: " + this.maxAngleFromPlane + ", minNormalQuality: " + this.minNormalQuality + ", min region size: " + this.minRegionSize + ", max standard deviation: " + this.maxStandardDeviation + ", min volumic density: " + this.minVolumicDensity;
    }

    public static PlanarRegionSegmentationParameters parse(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        PlanarRegionSegmentationParameters parameters = new PlanarRegionSegmentationParameters();
        parameters.setSearchRadius(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getSearchRadius()));
        parameters.setMaxDistanceFromPlane(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaxDistanceFromPlane()));
        parameters.setMaxAngleFromPlane(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaxAngleFromPlane()));
        parameters.setMinNormalQuality(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMinNormalQuality()));
        parameters.setMinRegionSize(ScannerTools.readNextInt((Scanner)scanner, (int)parameters.getMinRegionSize()));
        parameters.setMaxStandardDeviation(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMaxStandardDeviation()));
        parameters.setMinVolumicDensity(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getMinVolumicDensity()));
        scanner.close();
        return parameters;
    }
}

