/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.planarRegion;

import java.util.Scanner;
import us.ihmc.jOctoMap.tools.ScannerTools;

public class SurfaceNormalFilterParameters {
    private boolean useSurfaceNormalFilter;
    private double surfaceNormalUpperBound;
    private double surfaceNormalLowerBound;
    private static final double DEFAULT_LOWER_BOUND_DEGREE = -45.0;
    private static final double DEFAULT_UPPER_BOUND_DEGREE = 45.0;

    public SurfaceNormalFilterParameters() {
        this.setDefaultParameters();
    }

    public SurfaceNormalFilterParameters(SurfaceNormalFilterParameters other) {
        this.set(other);
    }

    public void set(SurfaceNormalFilterParameters other) {
        this.useSurfaceNormalFilter = other.useSurfaceNormalFilter;
        this.surfaceNormalUpperBound = other.surfaceNormalUpperBound;
        this.surfaceNormalLowerBound = other.surfaceNormalLowerBound;
    }

    public void setDefaultParameters() {
        this.useSurfaceNormalFilter = true;
        this.surfaceNormalUpperBound = Math.toRadians(45.0);
        this.surfaceNormalLowerBound = Math.toRadians(-45.0);
    }

    public boolean isUseSurfaceNormalFilter() {
        return this.useSurfaceNormalFilter;
    }

    public double getSurfaceNormalUpperBound() {
        return this.surfaceNormalUpperBound;
    }

    public double getSurfaceNormalLowerBound() {
        return this.surfaceNormalLowerBound;
    }

    public void setUseSurfaceNormalFilter(boolean useSurfaceNormalFilter) {
        this.useSurfaceNormalFilter = useSurfaceNormalFilter;
    }

    public void setSurfaceNormalUpperBound(double surfaceNormalUpperBound) {
        this.surfaceNormalUpperBound = surfaceNormalUpperBound;
    }

    public void setSurfaceNormalLowerBound(double surfaceNormalLowerBound) {
        this.surfaceNormalLowerBound = surfaceNormalLowerBound;
    }

    public String toString() {
        return "surfaceNormalUpperBound: " + this.surfaceNormalUpperBound + ", surfaceNormalLowerBound: " + this.surfaceNormalLowerBound + ", useSurfaceNormalFilter: " + this.useSurfaceNormalFilter;
    }

    public static SurfaceNormalFilterParameters parse(String parametersAsString) {
        parametersAsString = parametersAsString.replace(",", "");
        Scanner scanner = new Scanner(parametersAsString);
        SurfaceNormalFilterParameters parameters = new SurfaceNormalFilterParameters();
        parameters.setSurfaceNormalUpperBound(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getSurfaceNormalUpperBound()));
        parameters.setSurfaceNormalLowerBound(ScannerTools.readNextDouble((Scanner)scanner, (double)parameters.getSurfaceNormalLowerBound()));
        parameters.setUseSurfaceNormalFilter(ScannerTools.readNextBoolean((Scanner)scanner, (boolean)parameters.useSurfaceNormalFilter));
        scanner.close();
        return parameters;
    }
}

