/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam;

import com.google.common.util.concurrent.AtomicDouble;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxInterface;
import us.ihmc.jOctoMap.boundingBox.OcTreeBoundingBoxWithCenterAndYaw;
import us.ihmc.jOctoMap.iterators.OcTreeIteratorFactory;
import us.ihmc.jOctoMap.node.NormalOcTreeNode;
import us.ihmc.jOctoMap.node.baseImplementation.AbstractOcTreeNode;
import us.ihmc.jOctoMap.normalEstimation.NormalEstimationParameters;
import us.ihmc.jOctoMap.ocTree.NormalOcTree;
import us.ihmc.jOctoMap.pointCloud.Scan;
import us.ihmc.log.LogTools;
import us.ihmc.robotEnvironmentAwareness.communication.packets.BoundingBoxParametersMessage;
import us.ihmc.robotEnvironmentAwareness.slam.DriftCorrectionResult;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrame;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMInterface;
import us.ihmc.robotEnvironmentAwareness.slam.tools.SLAMTools;

public class SLAMBasics
implements SLAMInterface {
    private final AtomicReference<SLAMFrame> latestSlamFrame = new AtomicReference<Object>(null);
    protected Point3DBasics[] correctedCorrespondingPointLocation;
    protected final NormalOcTree mapOcTree;
    private final AtomicInteger mapSize = new AtomicInteger();
    private final AtomicDouble latestComputationTime = new AtomicDouble();
    protected final DriftCorrectionResult driftCorrectionResult = new DriftCorrectionResult();
    private final RigidBodyTransformReadOnly transformFromLocalToSensor;
    private final NormalEstimationParameters frameNormalEstimationParameters = new NormalEstimationParameters();
    private boolean computeInParallel = false;

    public SLAMBasics(double octreeResolution) {
        this(octreeResolution, (RigidBodyTransformReadOnly)new RigidBodyTransform());
    }

    public SLAMBasics(double octreeResolution, RigidBodyTransformReadOnly transformFromLocalFrameToSensor) {
        this.transformFromLocalToSensor = transformFromLocalFrameToSensor;
        this.mapOcTree = new NormalOcTree(octreeResolution);
        this.frameNormalEstimationParameters.setNumberOfIterations(10);
    }

    protected void insertNewPointCloud(SLAMFrame frame, boolean insertMiss) {
        List<? extends Point3DReadOnly> pointCloud = frame.getCorrectedPointCloudInWorld();
        RigidBodyTransformReadOnly sensorPose = frame.getCorrectedSensorPoseInWorld();
        Scan scan = SLAMTools.toScan(pointCloud, sensorPose.getTranslation());
        scan.getPointCloud().setTimestamp(frame.getTimeStamp().longValue());
        try {
            this.mapOcTree.insertScan(scan, insertMiss);
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("The given node is null.")) {
                LogTools.warn((String)"Failed to insert scan. null node in jOctoMap");
            }
            throw e;
        }
        this.mapOcTree.enableParallelComputationForNormals(true);
    }

    public void updateSurfaceNormals() {
        this.mapOcTree.updateNormals();
    }

    public void updateSurfaceNormalsInBoundingBox(NormalEstimationParameters normalEstimationParameters) {
        List leafNodesToUpdate = OcTreeIteratorFactory.createLeafBoundingBoxIteratable((AbstractOcTreeNode)((NormalOcTreeNode)this.mapOcTree.getRoot()), (OcTreeBoundingBoxInterface)this.mapOcTree.getBoundingBox()).toList();
        this.mapOcTree.updateNodesNormals((Collection)leafNodesToUpdate, normalEstimationParameters);
    }

    public void setComputeInParallel(boolean computeInParallel) {
        this.computeInParallel = computeInParallel;
    }

    @Override
    public void addKeyFrame(StereoVisionPointCloudMessage pointCloudMessage, boolean insertMiss) {
        SLAMFrame frame = new SLAMFrame(this.transformFromLocalToSensor, pointCloudMessage, this.frameNormalEstimationParameters, this.computeInParallel);
        this.setLatestFrame(frame);
        this.insertNewPointCloud(frame, insertMiss);
        this.driftCorrectionResult.setDefault();
    }

    @Override
    public boolean addFrame(StereoVisionPointCloudMessage pointCloudMessage, boolean insertMiss) {
        SLAMFrame frame = new SLAMFrame(this.getLatestFrame(), this.transformFromLocalToSensor, pointCloudMessage, this.frameNormalEstimationParameters, this.computeInParallel);
        long startTime = System.nanoTime();
        RigidBodyTransformReadOnly driftCorrectionTransformer = this.computeFrameCorrectionTransformer(frame);
        this.latestComputationTime.set((double)Math.round(Conversions.nanosecondsToSeconds((long)(System.nanoTime() - startTime)) * 100.0) / 100.0);
        this.driftCorrectionResult.setComputationTime(this.latestComputationTime.get());
        if (driftCorrectionTransformer == null) {
            return false;
        }
        frame.updateOptimizedCorrection(driftCorrectionTransformer);
        this.setLatestFrame(frame);
        this.insertNewPointCloud(frame, insertMiss);
        return true;
    }

    @Override
    public void clear() {
        this.latestSlamFrame.set(null);
        this.mapSize.set(0);
        this.mapOcTree.clear();
    }

    public Point3DReadOnly[] getSourcePoints() {
        return this.correctedCorrespondingPointLocation;
    }

    public boolean isEmpty() {
        return this.mapSize.get() == 0;
    }

    public int getMapSize() {
        return this.mapSize.get();
    }

    public void setLatestFrame(SLAMFrame frameToSet) {
        this.latestSlamFrame.set(frameToSet);
        this.mapSize.incrementAndGet();
    }

    public void handleBoundingBox(Pose3DReadOnly sensorPose, BoundingBoxParametersMessage boundingBoxParameters, boolean useBoundingBox) {
        this.handleBoundingBox((Tuple3DReadOnly)sensorPose.getPosition(), (Orientation3DReadOnly)sensorPose.getOrientation(), boundingBoxParameters, useBoundingBox);
    }

    public void handleBoundingBox(Tuple3DReadOnly sensorPosition, Orientation3DReadOnly sensorOrientation, BoundingBoxParametersMessage boundingBoxParameters, boolean useBoundingBox) {
        if (!useBoundingBox) {
            this.mapOcTree.disableBoundingBox();
            return;
        }
        OcTreeBoundingBoxWithCenterAndYaw boundingBox = new OcTreeBoundingBoxWithCenterAndYaw();
        Point3D min = boundingBoxParameters.getMin();
        Point3D max = boundingBoxParameters.getMax();
        boundingBox.setLocalMinMaxCoordinates((Point3DReadOnly)min, (Point3DReadOnly)max);
        if (sensorPosition != null && sensorOrientation != null) {
            boundingBox.setOffset(sensorPosition);
            boundingBox.setYawFromQuaternion(new Quaternion(sensorOrientation));
        }
        boundingBox.update(this.mapOcTree.getResolution(), this.mapOcTree.getTreeDepth());
        this.mapOcTree.setBoundingBox((OcTreeBoundingBoxInterface)boundingBox);
    }

    public SLAMFrame getLatestFrame() {
        return this.latestSlamFrame.get();
    }

    public double getOctreeResolution() {
        return this.mapOcTree.getResolution();
    }

    public NormalOcTree getMapOcTree() {
        return this.mapOcTree;
    }

    public void clearNormals() {
        this.mapOcTree.clearNormals();
    }

    public void setNormalEstimationParameters(NormalEstimationParameters normalEstimationParameters) {
        this.mapOcTree.setNormalEstimationParameters(normalEstimationParameters);
    }

    public void setFrameNormalEstimationParameters(NormalEstimationParameters normalEstimationParameters) {
        this.frameNormalEstimationParameters.set(normalEstimationParameters);
    }

    public double getComputationTimeForLatestFrame() {
        return this.latestComputationTime.get();
    }

    public DriftCorrectionResult getDriftCorrectionResult() {
        return this.driftCorrectionResult;
    }
}

