/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam;

import gnu.trove.list.array.TLongArrayList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotEnvironmentAwareness.slam.DriftCorrectionResult;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrame;

public class SLAMHistory {
    private static final String SLAM_HISTORY_EXTENSION = ".csv";
    private static final String FILE_NAME_HEADER = "slam_history_";
    private final TLongArrayList timeStamps = new TLongArrayList();
    private final List<RigidBodyTransformReadOnly> uncorrectedLocalFrames = new ArrayList<RigidBodyTransformReadOnly>();
    private final List<RigidBodyTransformReadOnly> correctedLocalFrames = new ArrayList<RigidBodyTransformReadOnly>();
    private final List<DriftCorrectionResult> driftCorrectionResults = new ArrayList<DriftCorrectionResult>();

    public void clearHistory() {
        this.timeStamps.clear();
        this.uncorrectedLocalFrames.clear();
        this.correctedLocalFrames.clear();
        this.driftCorrectionResults.clear();
    }

    public void addLatestFrameHistory(SLAMFrame latestFrame) {
        this.timeStamps.add(latestFrame.getTimeStamp().longValue());
        this.uncorrectedLocalFrames.add(latestFrame.getUncorrectedLocalPoseInWorld());
        this.correctedLocalFrames.add(latestFrame.getCorrectedLocalPoseInWorld());
    }

    public void addDriftCorrectionHistory(DriftCorrectionResult latestResult) {
        DriftCorrectionResult result = new DriftCorrectionResult();
        result.set(latestResult);
        this.driftCorrectionResults.add(result);
    }

    public void export(Path path) {
        File sensorPoseFile = new File(path.toFile(), FILE_NAME_HEADER + System.currentTimeMillis() + SLAM_HISTORY_EXTENSION);
        try {
            FileWriter sensorPoseFileWriter = new FileWriter(sensorPoseFile);
            StringBuilder builder = new StringBuilder("");
            builder.append("timeStamps,");
            builder.append("success,");
            builder.append("computationTime (sec),");
            builder.append("icpIterations,");
            builder.append("numberOfSurfels,");
            builder.append("numberOfCorrespondances,");
            builder.append("initialDistance,");
            builder.append("finalDistance\n");
            for (int i = 0; i < this.timeStamps.size(); ++i) {
                builder.append(this.timeStamps.get(i) + ",");
                DriftCorrectionResult driftCorrectionResult = this.driftCorrectionResults.get(i);
                builder.append(driftCorrectionResult.isSuccess() + ",");
                builder.append(driftCorrectionResult.getComputationTime() + ",");
                builder.append(driftCorrectionResult.getIcpIterations() + ",");
                builder.append(driftCorrectionResult.getNumberOfSurfels() + ",");
                builder.append(driftCorrectionResult.getNumberOfCorrespondances() + ",");
                builder.append(driftCorrectionResult.getInitialDistance() + ",");
                builder.append(driftCorrectionResult.getFinalDistance() + "\n");
            }
            sensorPoseFileWriter.write(builder.toString());
            sensorPoseFileWriter.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

