/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotEnvironmentAwareness.slam.viewer;

import controller_msgs.msg.dds.FootstepDataMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.javaFXToolkit.shapes.JavaFXMultiColorMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette1D;
import us.ihmc.javafx.FootstepMeshManager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REAUIMessager;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotics.robotSide.RobotSide;

public class FootstepMeshViewer
extends AnimationTimer {
    private static final int MAXIMUM_NUMBER_OF_FOOTSTEPS_TO_VIZ = 200;
    private final Group root = new Group();
    private final JavaFXMultiColorMeshBuilder meshBuilder;
    private final TextureColorPalette1D normalBasedColorPalette1D = new TextureColorPalette1D();
    private final AtomicInteger numberOfFootstepsToRender = new AtomicInteger();
    private final AtomicReference<FootstepDataMessage> newFootstepDataMessage;
    private final List<FootstepMeshManager> footstepMesheManagers = new ArrayList<FootstepMeshManager>();
    private final AtomicReference<Boolean> enable;
    private boolean isRunning = false;
    private final AtomicBoolean clearRequested = new AtomicBoolean(false);

    public FootstepMeshViewer(REAUIMessager uiMessager, Function<RobotSide, ConvexPolygon2D> contactPointsProvider) {
        this.newFootstepDataMessage = uiMessager.createInput(SLAMModuleAPI.FootstepDataState);
        MessagerAPIFactory.Topic<Boolean> showviz = SLAMModuleAPI.ShowFootstepDataViz;
        this.enable = uiMessager.createInput(showviz, true);
        uiMessager.registerTopicListener(SLAMModuleAPI.ClearFootstepDataViz, c -> this.clear());
        uiMessager.registerTopicListener(SLAMModuleAPI.SLAMClear, c -> this.clear());
        this.meshBuilder = new JavaFXMultiColorMeshBuilder((TextureColorPalette)this.normalBasedColorPalette1D);
        int i = 0;
        while (i < 200) {
            int index = i++;
            this.footstepMesheManagers.add(new FootstepMeshManager(this.root, this.meshBuilder, contactPointsProvider, () -> this.numberOfFootstepsToRender.get() == index + 1, () -> false));
        }
        uiMessager.registerTopicListener(showviz, show -> Platform.runLater(() -> this.footstepMesheManagers.forEach(mesh -> mesh.getMeshHolder().getMeshView().setVisible(show.booleanValue()))));
        uiMessager.registerModuleMessagerStateListener(isMessagerOpen -> {
            if (isMessagerOpen) {
                this.start();
            } else {
                this.stop();
            }
        });
    }

    private void render() {
        int numberOfFootstepsToViz = this.numberOfFootstepsToRender.get();
        for (int i = 0; i < numberOfFootstepsToViz; ++i) {
            this.footstepMesheManagers.get(i).computeMesh();
            this.footstepMesheManagers.get(i).updateMesh();
        }
    }

    public void addFootstepDataMessage(FootstepDataMessage footstepDataMessage) {
        int index = this.numberOfFootstepsToRender.getAndAdd(1);
        this.footstepMesheManagers.get(index).setFootstepDataMessage(footstepDataMessage);
    }

    public void clear() {
        if (this.isRunning) {
            this.clearRequested.set(true);
        } else {
            Platform.runLater(this::clearNow);
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public void start() {
        super.start();
        this.isRunning = true;
    }

    public void stop() {
        super.stop();
        this.isRunning = false;
    }

    public void handle(long now) {
        if (this.clearRequested.getAndSet(false)) {
            this.clearNow();
        }
        if (!this.enable.get().booleanValue()) {
            return;
        }
        this.render();
        if (this.newFootstepDataMessage.get() == null) {
            return;
        }
        this.addFootstepDataMessage(this.newFootstepDataMessage.getAndSet(null));
    }

    private void clearNow() {
        for (int i = 0; i < this.footstepMesheManagers.size(); ++i) {
            this.footstepMesheManagers.get(i).clear();
        }
        this.numberOfFootstepsToRender.set(0);
    }
}

